#include <Application.h>
#include <Bitmap.h>
#include <View.h>
#include <Window.h>
#include <stdio.h>
#include <string.h>

uint32 kBitmapBits[] = {
	0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477,
	0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477,
	0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477,
	0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477,
	0x00777477, 0x00777477, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477,
	0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477,
	0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477,
	0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477,
	0x00777477, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00111111,
	0x00777777, 0x00000000, 0x00777477, 0x00777477, 0x00777477, 0x00777477,
	0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477,
	0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477,
	0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477,
	0x00777477, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00111111,
	0x00777777, 0x00444444, 0x00000000, 0x00000000, 0x00777477, 0x00777477,
	0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477,
	0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477,
	0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477,
	0x00777477, 0x00000000, 0x00000000, 0x00bb0000, 0x00ffffff, 0x00000000,
	0x00444444, 0x00777777, 0x00111111, 0x00000000, 0x00000000, 0x00000000,
	0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477,
	0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477,
	0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477,
	0x00777477, 0x00777477, 0x00000000, 0x00bb0000, 0x00ee0000, 0x00ee0000,
	0x00ff0000, 0x00ffffff, 0x00ee0000, 0x00111111, 0x00000000, 0x00000000,
	0x00000000, 0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477,
	0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477,
	0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477,
	0x00777477, 0x00777477, 0x00777477, 0x00000000, 0x00bb0000, 0x00ee0000,
	0x00ee0000, 0x00ff0000, 0x00ffffff, 0x00ee0000, 0x00ee0000, 0x00ee0000,
	0x00000000, 0x00000000, 0x00000000, 0x00777477, 0x00777477, 0x00777477,
	0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477,
	0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477,
	0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00000000, 0x00bb0000,
	0x00ee0000, 0x00ee0000, 0x00ff0000, 0x00ffffff, 0x00ee0000, 0x00ee0000,
	0x00ee0000, 0x00cc0000, 0x00000000, 0x00000000, 0x00000000, 0x00777477,
	0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477,
	0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477,
	0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00000000,
	0x00bb0000, 0x00ee0000, 0x00ee0000, 0x00ff0000, 0x00ffffff, 0x00ee0000,
	0x00ee0000, 0x00ee0000, 0x00cc0000, 0x00990000, 0x00990000, 0x00000000,
	0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477,
	0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477,
	0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477,
	0x00777477, 0x00000000, 0x00ee0000, 0x00ee0000, 0x00ee0000, 0x00ffffff,
	0x00ee0000, 0x00ff0000, 0x00cc0000, 0x00cc0000, 0x00990000, 0x00bb0000,
	0x00880000, 0x00000000, 0x00777477, 0x00777477, 0x00777477, 0x00777477,
	0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477,
	0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477,
	0x00777477, 0x00777477, 0x00000000, 0x00ee0000, 0x00ee0000, 0x00ee0000,
	0x00ffffff, 0x00ee0000, 0x00ff0000, 0x00cc0000, 0x00cc0000, 0x00990000,
	0x00bb0000, 0x00880000, 0x00000000, 0x00777477, 0x00777477, 0x00777477,
	0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477,
	0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477,
	0x00777477, 0x00777477, 0x00777477, 0x00000000, 0x00ee0000, 0x00ee0000,
	0x00ee0000, 0x00ffffff, 0x00ee0000, 0x00ff0000, 0x00cc0000, 0x00cc0000,
	0x00990000, 0x00bb0000, 0x00880000, 0x00990000, 0x00000000, 0x00777477,
	0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477,
	0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477,
	0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00000000, 0x00ee0000,
	0x00ee0000, 0x00ee0000, 0x00ffffff, 0x00ee0000, 0x00ff0000, 0x00cc0000,
	0x00cc0000, 0x00990000, 0x00bb0000, 0x00880000, 0x00990000, 0x00000000,
	0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477,
	0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477,
	0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477,
	0x00000000, 0x00ee0000, 0x00ff0000, 0x00ffffff, 0x00ee0000, 0x00ee0000,
	0x00ee0000, 0x00cc0000, 0x00990000, 0x00bb0000, 0x00880000, 0x00880000,
	0x00000000, 0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477,
	0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477,
	0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477,
	0x00777477, 0x00000000, 0x00ee0000, 0x00ee0000, 0x00ffffff, 0x00ee0000,
	0x00ff0000, 0x00cc0000, 0x00cc0000, 0x00990000, 0x00bb0000, 0x00880000,
	0x00990000, 0x00000000, 0x00777477, 0x00777477, 0x00777477, 0x00777477,
	0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477,
	0x00777477, 0x00777477, 0x00777477, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00ee0000, 0x00ffffff,
	0x00ee0000, 0x00ff0000, 0x00cc0000, 0x00cc0000, 0x00990000, 0x00bb0000,
	0x00880000, 0x00000000, 0x00000000, 0x00777477, 0x00777477, 0x00777477,
	0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477,
	0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00000000, 0x00ff6666,
	0x00ff6666, 0x00ff6666, 0x00ff6666, 0x00880000, 0x00000000, 0x00ee0000,
	0x00ff6666, 0x00000000, 0x00ee0000, 0x00ee0000, 0x00bb0000, 0x00bb0000,
	0x00bb0000, 0x00880000, 0x00000000, 0x00777477, 0x00777477, 0x00777477,
	0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477,
	0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00000000,
	0x00ee0000, 0x00ff0000, 0x00ee0000, 0x00880000, 0x00990000, 0x00000000,
	0x00ee0000, 0x00ff6666, 0x00880000, 0x00000000, 0x00cc0000, 0x00990000,
	0x00bb0000, 0x00880000, 0x00990000, 0x00000000, 0x00777477, 0x00777477,
	0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477,
	0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477,
	0x00000000, 0x00ee0000, 0x00ff0000, 0x00ee0000, 0x00880000, 0x00990000,
	0x00000000, 0x00ee0000, 0x00ff6666, 0x00880000, 0x00000000, 0x00990000,
	0x00880000, 0x00880000, 0x00990000, 0x00000000, 0x00000000, 0x00777477,
	0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477,
	0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477,
	0x00777477, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00ff6666, 0x00880000, 0x00000000,
	0x00990000, 0x00880000, 0x00880000, 0x00000000, 0x00000000, 0x00777477,
	0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477,
	0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477,
	0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477,
	0x00777477, 0x00777477, 0x00000000, 0x00444444, 0x00ff6666, 0x00880000,
	0x00000000, 0x00990000, 0x00880000, 0x00880000, 0x00000000, 0x00ee0000,
	0x00000000, 0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477,
	0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777777, 0x00777777,
	0x00777777, 0x00777777, 0x00777777, 0x00777777, 0x00777477, 0x00777477,
	0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00000000, 0x00ff6666,
	0x00880000, 0x00000000, 0x00000000, 0x00000000, 0x00990000, 0x00000000,
	0x00880000, 0x00ee0000, 0x00000000, 0x00777477, 0x00777477, 0x00777477,
	0x00777477, 0x00777477, 0x00777777, 0x00777777, 0x00777777, 0x00777777,
	0x00777777, 0x00777777, 0x00777777, 0x00777777, 0x00777777, 0x00777777,
	0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00000000, 0x00000000,
	0x00ff9900, 0x00000000, 0x00000000, 0x00000000, 0x00444444, 0x00000000,
	0x00000000, 0x00880000, 0x00990000, 0x00ee0000, 0x00000000, 0x00777477,
	0x00777477, 0x00777477, 0x00777777, 0x00777777, 0x00777777, 0x00777777,
	0x00777777, 0x00777777, 0x00777777, 0x00777777, 0x00777777, 0x00777777,
	0x00777777, 0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00000000,
	0x00ff9900, 0x00ff9900, 0x00ffff00, 0x00ffff00, 0x00ffff00, 0x00000000,
	0x00444444, 0x00000000, 0x00000000, 0x00880000, 0x00ff0000, 0x00ee0000,
	0x00000000, 0x00777477, 0x00777777, 0x00777777, 0x00777777, 0x00777777,
	0x00777777, 0x00777777, 0x00777777, 0x00777777, 0x00777777, 0x00777777,
	0x00777777, 0x00777777, 0x00777777, 0x00777477, 0x00777477, 0x00777477,
	0x00000000, 0x00ff9900, 0x00ff9900, 0x00ffff00, 0x00ffff00, 0x00ffff00,
	0x00ff9900, 0x00000000, 0x00000000, 0x00777477, 0x00000000, 0x00ee0000,
	0x00ff0000, 0x00880000, 0x00000000, 0x00777477, 0x00777777, 0x00777777,
	0x00777777, 0x00777777, 0x00777777, 0x00777777, 0x00777777, 0x00777777,
	0x00777777, 0x00777777, 0x00777777, 0x00777777, 0x00777477, 0x00777477,
	0x00777477, 0x00777477, 0x00000000, 0x00ff9900, 0x00ff9900, 0x00ffff00,
	0x00ffff00, 0x00ff9900, 0x00000000, 0x00777777, 0x00777777, 0x00777777,
	0x00000000, 0x00ee0000, 0x00990000, 0x00000000, 0x00777777, 0x00777777,
	0x00777777, 0x00777777, 0x00777777, 0x00777777, 0x00777777, 0x00777777,
	0x00777777, 0x00777777, 0x00777777, 0x00777777, 0x00777477, 0x00777477,
	0x00777477, 0x00777477, 0x00777477, 0x00000000, 0x00ff9900, 0x00ff9900,
	0x00ffff00, 0x00ff9900, 0x00ff9900, 0x00ff9900, 0x00000000, 0x00777777,
	0x00777777, 0x00777777, 0x00000000, 0x00880000, 0x00000000, 0x00777777,
	0x00777777, 0x00777777, 0x00777777, 0x00777777, 0x00777777, 0x00777777,
	0x00777777, 0x00777777, 0x00777777, 0x00777777, 0x00777477, 0x00777477,
	0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00000000,
	0x00ff9900, 0x00ffff00, 0x00ff9900, 0x00ff9900, 0x00ff9900, 0x00000000,
	0x00777477, 0x00777477, 0x00777477, 0x00777777, 0x00000000, 0x00000000,
	0x00777777, 0x00777777, 0x00777777, 0x00777777, 0x00777777, 0x00777777,
	0x00777777, 0x00777777, 0x00777777, 0x00777477, 0x00777477, 0x00777477,
	0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477,
	0x00000000, 0x00ff9900, 0x00ffff00, 0x00ff9900, 0x00ff9900, 0x00000000,
	0x00000000, 0x00777477, 0x00777777, 0x00777777, 0x00777777, 0x00777777,
	0x00000000, 0x00777777, 0x00777777, 0x00777777, 0x00777777, 0x00777777,
	0x00777777, 0x00777777, 0x00777477, 0x00777477, 0x00777477, 0x00777477,
	0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477,
	0x00777477, 0x00777477, 0x00000000, 0x00ffff00, 0x00ff9900, 0x00000000,
	0x00000000, 0x00777477, 0x00777777, 0x00777777, 0x00777777, 0x00777777,
	0x00777777, 0x00777777, 0x00777777, 0x00777777, 0x00777777, 0x00777777,
	0x00777777, 0x00777777, 0x00777477, 0x00777477, 0x00777477, 0x00777477,
	0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477,
	0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00000000, 0x00000000,
	0x00000000, 0x00777477, 0x00777477, 0x00777777, 0x00777777, 0x00777777,
	0x00777777, 0x00777777, 0x00777777, 0x00777777, 0x00777777, 0x00777777,
	0x00777777, 0x00777777, 0x00777777, 0x00777777, 0x00777477, 0x00777477,
	0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477,
	0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477,
	0x00777477, 0x00777477, 0x00777477, 0x00777777, 0x00777777, 0x00777777,
	0x00777777, 0x00777777, 0x00777777, 0x00777777, 0x00777777, 0x00777477,
	0x00777477, 0x00777477, 0x00777777, 0x00777777, 0x00777777, 0x00777777,
	0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477,
	0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477,
	0x00777477, 0x00777477, 0x00777477, 0x00777777, 0x00777777, 0x00777777,
	0x00777777, 0x00777777, 0x00777777, 0x00777477, 0x00777477, 0x00777477,
	0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777777, 0x00777777,
	0x00777777, 0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477,
	0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477, 0x00777477,
	0x00777477, 0x00777477, 0x00777477, 0x00777477
};

class DrawingModeView : public BView {
public:
							DrawingModeView(BRect frame);
virtual						~DrawingModeView();

virtual	void				Draw(BRect updateRect);

private:
		BBitmap *			fBitmap;
};


class DrawingModeWindow : public BWindow {
public:
							DrawingModeWindow(BRect frame);

private:
		DrawingModeView *	fView;
};


class DrawingModeApp : public BApplication {
public:
							DrawingModeApp();

private:
		DrawingModeWindow *	fWindow;
};


DrawingModeApp::DrawingModeApp()
	:	BApplication("application/x.vnd-Haiku.DrawingModeTest")
{
	fWindow = new DrawingModeWindow(BRect(200, 200, 380, 600));
	fWindow->Show();
}


DrawingModeWindow::DrawingModeWindow(BRect frame)
	:	BWindow(frame, "Drawing Modes Test", B_TITLED_WINDOW,
			B_QUIT_ON_WINDOW_CLOSE)
{
	fView = new DrawingModeView(frame.OffsetToSelf(0, 0));
	AddChild(fView);
	fView->SetViewColor(255, 203, 0);
	fView->SetDrawingMode(B_OP_OVER);
}


DrawingModeView::DrawingModeView(BRect frame)
	:	BView(frame, "DrawingModeView", B_FOLLOW_ALL, B_WILL_DRAW),
		fBitmap(NULL)
{
	fBitmap = new BBitmap(BRect(0, 0, 31, 31), B_RGB32);
	memcpy(fBitmap->Bits(), kBitmapBits, fBitmap->BitsLength());
}


DrawingModeView::~DrawingModeView()
{
	delete fBitmap;
}


void
DrawingModeView::Draw(BRect updateRect)
{
	SetDrawingMode(B_OP_COPY);
	SetLowColor(ViewColor());
	FillRect(Bounds(), B_SOLID_LOW);

	SetLowColor(255, 0, 0);
	SetHighColor(0, 0, 255);

	BRect bitmapBounds = fBitmap->Bounds();
	int32 imageHeight = bitmapBounds.IntegerHeight() + 10;
	int32 imageWidth = bitmapBounds.IntegerWidth() + 10;

	struct {
		drawing_mode mode;
		const char *name;
	} drawingModes[] = {
		{ B_OP_COPY, "B_OP_COPY" },
		{ B_OP_OVER, "B_OP_OVER" },
		{ B_OP_ERASE, "B_OP_ERASE" },
		{ B_OP_INVERT, "B_OP_INVERT" },
		{ B_OP_SELECT, "B_OP_SELECT" },
		{ B_OP_ADD, "B_OP_ADD" },
		{ B_OP_SUBTRACT, "B_OP_SUBTRACT" },
		{ B_OP_BLEND, "B_OP_BLEND" },
		{ B_OP_MIN, "B_OP_MIN" },
		{ B_OP_MAX, "B_OP_MAX" }
	};

	int32 modeCount = sizeof(drawingModes) / sizeof(drawingModes[0]);
	for (int32 i = 0; i < modeCount; i++) {
		if (drawingModes[i].mode == B_OP_SELECT) {
			// make the background contain the low and high color to see
			// actual effect of B_OP_SELECT
			SetDrawingMode(B_OP_COPY);
			FillRect(BRect(0, imageHeight * i, imageWidth * 2 - 10,
				imageHeight * i + bitmapBounds.Height() / 2), B_SOLID_LOW);
			FillRect(BRect(0, imageHeight * i  + bitmapBounds.Height() / 2,
				imageWidth * 2 - 10, imageHeight * i + bitmapBounds.Height()),
				B_SOLID_HIGH);
		} else if (drawingModes[i].mode == B_OP_MAX
			|| drawingModes[i].mode == B_OP_MIN) {
			// need a darker/lighter color as a background otherwise nothing
			// will be selected from the source
			SetDrawingMode(B_OP_COPY);
			SetHighColor(255, 255, 255);
			FillRect(BRect(0, imageHeight * i, imageWidth * 2 - 10,
				imageHeight * i + bitmapBounds.Height() / 3), B_SOLID_HIGH);
			SetHighColor(128, 128, 128);
			FillRect(BRect(0, imageHeight * i  + bitmapBounds.Height() / 3,
				imageWidth * 2 - 10, imageHeight * i + bitmapBounds.Height()),
				B_SOLID_HIGH);
			SetHighColor(0, 0, 0);
			FillRect(BRect(0, imageHeight * i  + bitmapBounds.Height() / 3 * 2,
				imageWidth * 2 - 10, imageHeight * i + bitmapBounds.Height()),
				B_SOLID_HIGH);
			SetHighColor(0, 0, 255);
		}

		SetDrawingMode(drawingModes[i].mode);
		DrawBitmap(fBitmap, BPoint(0, imageHeight * i));
		FillRect(bitmapBounds.OffsetToCopy(imageWidth,
			imageHeight * i), B_MIXED_COLORS);

		SetDrawingMode(B_OP_OVER);
		DrawString(drawingModes[i].name, BPoint(imageWidth * 2,
			imageHeight * i + 20));
	}
}


int
main(int argc, const char *argv[])
{
	DrawingModeApp *app = new DrawingModeApp();
	app->Run();
	delete app;
	return 0;
}
