static const char haiku_js[] =
  "/*\n"
  " * Copyright 2012, Haiku, Inc.\n"
  " * Distributed under the terms of the MIT License.\n"
  " *\n"
  " * Authors:\n"
  " *		François Revol <revol@free.fr>\n"
  " *\n"
  " * Loosely inspired by\n"
  " * http://git.gnome.org/browse/gtk+/tree/gdk/broadway/broadway.js?h=broadway\n"
  " */\n"
  "\n"
  "var logDiv;\n"
  "var desktop;	// the canvas\n"
  "\n"
  "var b64Values = new Array(\n"
  "	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,\n"
  "	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,\n"
  "	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63,\n"
  "	52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -2, -1, -1,\n"
  "	-1,  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14,\n"
  "	15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1,\n"
  "	-1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40,\n"
  "	41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1);\n"
  "\n"
  "//DEBUG\n"
  "var stream={s:\"YWJjZA==YWI=YQ==VQ==qg==qlU=Vao=VaqqVQ==qlVVqg==\",i:0};\n"
  "var stream2={s:\"YWJjZAYWIYQVQqgqlUVaoVaqqVQqlVVqg\",i:0};\n"
  "\n"
  "\n"
  "function b64_get_u32_(t, i)\n"
  "{\n"
  "	var v = 0;\n"
  "	if (b64Values[t.charCodeAt(i)] < 0)	return v;\n"
  "	v += b64Values[t.charCodeAt(i++)] << 26;\n"
  "	if (b64Values[t.charCodeAt(i)] < 0)	return v;\n"
  "	v += b64Values[t.charCodeAt(i++)] << 20;\n"
  "	if (b64Values[t.charCodeAt(i)] < 0)	return v;\n"
  "	v += b64Values[t.charCodeAt(i++)] << 14;\n"
  "	if (b64Values[t.charCodeAt(i)] < 0)	return v;\n"
  "	v += b64Values[t.charCodeAt(i++)] << 8;\n"
  "	if (b64Values[t.charCodeAt(i)] < 0)	return v;\n"
  "	v += b64Values[t.charCodeAt(i++)] << 2;\n"
  "	if (b64Values[t.charCodeAt(i)] < 0)	return v;\n"
  "	v += b64Values[t.charCodeAt(i++)] >> 4;\n"
  "	if (b64Values[t.charCodeAt(i)] < 0)	i++;\n"
  "	if (b64Values[t.charCodeAt(i)] < 0)	i++;\n"
  "	dbg(\"u32:\" + v + \" 0x\" + v.toString(16));\n"
  "	return v;\n"
  "}\n"
  "\n"
  "\n"
  "function b64_get_u8(s)\n"
  "{\n"
  "	var v = 0;\n"
  "	if (b64Values[s.s.charCodeAt(s.i)] < 0)	return v;\n"
  "	v += b64Values[s.s.charCodeAt(s.i++)] << 2;\n"
  "	if (b64Values[s.s.charCodeAt(s.i)] < 0)	return v;\n"
  "	v += b64Values[s.s.charCodeAt(s.i++)] >> 4;\n"
  "	if (b64Values[s.s.charCodeAt(s.i)] < 0)	s.i++;\n"
  "	if (b64Values[s.s.charCodeAt(s.i)] < 0)	s.i++;\n"
  "	dbg(\" u8:\" + v + \" 0x\" + v.toString(16));\n"
  "	return v;\n"
  "}\n"
  "\n"
  "function b64_get_u16(s)\n"
  "{\n"
  "	var v = 0;\n"
  "	if (b64Values[s.s.charCodeAt(s.i)] < 0)	return v;\n"
  "	v += b64Values[s.s.charCodeAt(s.i++)] << 10;\n"
  "	if (b64Values[s.s.charCodeAt(s.i)] < 0)	return v;\n"
  "	v += b64Values[s.s.charCodeAt(s.i++)] << 4;\n"
  "	if (b64Values[s.s.charCodeAt(s.i)] < 0)	return v;\n"
  "	v += b64Values[s.s.charCodeAt(s.i++)] >> 2;\n"
  "	if (b64Values[s.s.charCodeAt(s.i)] < 0)	s.i++;\n"
  "	dbg(\"u16:\" + v + \" 0x\" + v.toString(16));\n"
  "	return v;\n"
  "}\n"
  "\n"
  "function b64_get_u32(s)\n"
  "{\n"
  "	var v = 0;\n"
  "	if (b64Values[s.s.charCodeAt(s.i)] < 0)	return v;\n"
  "	v += b64Values[s.s.charCodeAt(s.i++)] << 26;\n"
  "	if (b64Values[s.s.charCodeAt(s.i)] < 0)	return v;\n"
  "	v += b64Values[s.s.charCodeAt(s.i++)] << 20;\n"
  "	if (b64Values[s.s.charCodeAt(s.i)] < 0)	return v;\n"
  "	v += b64Values[s.s.charCodeAt(s.i++)] << 14;\n"
  "	if (b64Values[s.s.charCodeAt(s.i)] < 0)	return v;\n"
  "	v += b64Values[s.s.charCodeAt(s.i++)] << 8;\n"
  "	if (b64Values[s.s.charCodeAt(s.i)] < 0)	return v;\n"
  "	v += b64Values[s.s.charCodeAt(s.i++)] << 2;\n"
  "	if (b64Values[s.s.charCodeAt(s.i)] < 0)	return v;\n"
  "	v += b64Values[s.s.charCodeAt(s.i++)] >> 4;\n"
  "	//v &= 0x0ffffffff;\n"
  "	if (b64Values[s.s.charCodeAt(s.i)] < 0)	s.i++;\n"
  "	if (b64Values[s.s.charCodeAt(s.i)] < 0)	s.i++;\n"
  "	dbg(\"u32:\" + v + \" 0x\" + v.toString(16));\n"
  "	return v;\n"
  "}\n"
  "\n"
  "function dbg(str)\n"
  "{\n"
  "	var div = document.createElement(\"div\");\n"
  "	div.className = \"haiku_online_debug\";\n"
  "	div.appendChild(document.createTextNode(str));\n"
  "	logDiv.appendChild(div);\n"
  "}\n"
  "\n"
  "function err(str)\n"
  "{\n"
  "	var div = document.createElement(\"div\");\n"
  "	div.className = \"haiku_online_error\";\n"
  "	div.appendChild(document.createTextNode(str));\n"
  "	logDiv.appendChild(div);\n"
  "}\n"
  "\n"
  "function createXHR()\n"
  "{\n"
  "	try {\n"
  "		return new XMLHttpRequest();\n"
  "	} catch(e) {\n"
  "		err(\"Failed to create XHR: \" + e);\n"
  "	}\n"
  "	return null;\n"
  "}\n"
  "\n"
  "function onMessage(message)\n"
  "{\n"
  "	dbg(\"onMessage: \");\n"
  "window.popup(\"plop\");\n"
  "	dbg(message.target.responseText);\n"
  "}\n"
  "\n"
  "function decodeCanvasMessage(msg)\n"
  "{\n"
  "	dbg(\"decodeCanvasMessage()\");\n"
  "	var code = b64_get_u16(msg);\n"
  "	dbg(\"code: \" + code);\n"
  "/*	switch (code) {\n"
  "	//case 1:\n"
  "		//break;\n"
  "	default:\n"
  "		dbg(\"unhandled code \" + code);\n"
  "		return;\n"
  "	}*/\n"
  "}\n"
  "\n"
  "function onReadyStateChange()\n"
  "{\n"
  "	dbg(\"readystate changed: \" + this.readyState);\n"
  "	if (this.readyState != 4)\n"
  "		return;\n"
  "	dbg(\"status: \" + this.status);\n"
  "	dbg(\"resonseType: \" + this.responseType);\n"
  "	dbg(\"response: \" + this.responseText);\n"
  "	//dbg(\"headers: \" + this.getAllResponseHeaders());\n"
  "//var stream={s:\"YWJjZA==YWI=YQ==VQ==qg==qlU=Vao=VaqqVQ==qlVVqg==\",i:0};\n"
  "	var msg = {s:(this.responseText),i:0};\n"
  "	decodeCanvasMessage(msg);\n"
  "}\n"
  "\n"
  "//DEBUG\n"
  "function testB64(stream)\n"
  "{\n"
  "	var i = 0;\n"
  "	b64_get_u32(stream);\n"
  "	b64_get_u16(stream);\n"
  "	b64_get_u8(stream);\n"
  "	b64_get_u8(stream);\n"
  "	b64_get_u8(stream);\n"
  "	b64_get_u16(stream);\n"
  "	b64_get_u16(stream);\n"
  "	b64_get_u32(stream);\n"
  "	b64_get_u32(stream);\n"
  "	dbg(\"s.i:\"+stream.i);\n"
  "}\n"
  "\n"
  "function initDesktop()\n"
  "{\n"
  "	dbg(\"initDesktop()\");\n"
  "\n"
  "	//testB64(stream);\n"
  "	//testB64(stream2);\n"
  "\n"
  "//var stream={s:\"YWJjZA==YWI=YQ==VQ==qg==qlU=Vao=VaqqVQ==qlVVqg==\",i:0};\n"
  "	var msg = {s:\"YWJjZA==YWI=YQ==VQ==qg==qlU=Vao=VaqqVQ==qlVVqg==\",i:0};\n"
  "	decodeCanvasMessage(stream);\n"
  "\n"
  "	desktop = document.getElementById(\"desktop\");\n"
  "	var xhr = createXHR();\n"
  "	if (xhr) {\n"
  "		if (typeof xhr.multipart != \"undefined\")\n"
  "			xhr.multipart = true;\n"
  "		else {\n"
  "			err(\"XHR has no multipart field!\");\n"
  "			return;\n"
  "		}\n"
  "		if (typeof xhr.async != \"undefined\")\n"
  "			xhr.async = true;\n"
  "		else {\n"
  "			dbg(\"XHR has no async field!\");\n"
  "		}\n"
  "		dbg(\"multipart: \" + xhr.multipart);\n"
  "		xhr.open(\"GET\", \"http://127.0.0.1:8080/output\", true);\n"
  "		//xhr.onload = onMessage;\n"
  "		xhr.onreadystatechange = onReadyStateChange;\n"
  "		//xhr.responseType = \"arraybuffer\";\n"
  "		//dbg(\"xhr.onload:\" + xhr.onload);\n"
  "		//dbg(\"xhr.send:\" + xhr.send);\n"
  "		//xhr.overrideMimeType(\"multipart/x-mixed-replace;boundary=x\");\n"
  "		xhr.send(null);\n"
  "		//dbg(\"headers: \" + xhr.getAllResponseHeaders());\n"
  "	} else\n"
  "		err(\"No XHR\");\n"
  "	dbg(\"done\");\n"
  "}\n"
  "\n"
  "\n"
  "function onPageLoad() {\n"
  "	logDiv = document.getElementById(\"log\");\n"
  "	dbg(\"onPageLoad()\");\n"
  "	initDesktop();\n"
  "}\n"
  "\n"
  "function onPageUnload() {\n"
  "	dbg(\"onPageUnload()\");\n"
  "}\n"
  "\n"
  "\n";
