/*
 * Copyright 2010 Stephan Aßmus <superstippi@gmx.de>.
 * All rights reserved. Distributed under the terms of the MIT License.
 */
#ifndef CURSOR_DATA_H
#define CURSOR_DATA_H


#include <GraphicsDefs.h>


const uint32 kCursorWidth = 22;
const uint32 kCursorHeight = 22;
const color_space kCursorFormat = B_RGBA32;

extern const uint8 kCursorContextMenuBits[];
extern const uint8 kCursorCopyBits[];
extern const uint8 kCursorCreateLinkBits[];
extern const uint8 kCursorCrossHairBits[];
extern const uint8 kCursorFollowLinkBits[];
extern const uint8 kCursorGrabBits[];
extern const uint8 kCursorGrabbingBits[];
extern const uint8 kCursorHelpBits[];
extern const uint8 kCursorIBeamBits[];
extern const uint8 kCursorIBeamHorizontalBits[];
extern const uint8 kCursorMoveBits[];
extern const uint8 kCursorNoCursor[];
extern const uint8 kCursorNotAllowedBits[];
extern const uint8 kCursorProgressBits[];
extern const uint8 kCursorResizeEastBits[];
extern const uint8 kCursorResizeEastWestBits[];
extern const uint8 kCursorResizeNorthBits[];
extern const uint8 kCursorResizeNorthEastBits[];
extern const uint8 kCursorResizeNorthEastSouthWestBits[];
extern const uint8 kCursorResizeNorthSouthBits[];
extern const uint8 kCursorResizeNorthWestBits[];
extern const uint8 kCursorResizeNorthWestSouthEastBits[];
extern const uint8 kCursorResizeSouthBits[];
extern const uint8 kCursorResizeSouthEastBits[];
extern const uint8 kCursorResizeSouthWestBits[];
extern const uint8 kCursorResizeWestBits[];
extern const uint8 kCursorSystemDefaultBits[];
extern const uint8 kCursorZoomInBits[];
extern const uint8 kCursorZoomOutBits[];


#endif // CURSOR_DATA_H
