/*---------------------------------------------------------------------------*
 |              PDFlib - A library for generating PDF on the fly             |
 +---------------------------------------------------------------------------+
 | Copyright (c) 1997-2004 Thomas Merz and PDFlib GmbH. All rights reserved. |
 +---------------------------------------------------------------------------+
 |                                                                           |
 |    This software is subject to the PDFlib license. It is NOT in the       |
 |    public domain. Extended versions and commercial licenses are           |
 |    available, please check http://www.pdflib.com.                         |
 |                                                                           |
 *---------------------------------------------------------------------------*/

/* $Id: p_cid.h 14574 2005-10-29 16:27:43Z bonefish $
 *
 * Header file for PDFlib CID font information
 *
 */

#ifndef P_CID_H
#define P_CID_H

#include "pc_corefont.h"

typedef struct {
    const char *name;
    pdc_charcoll charcoll;
    short codesize;
    short compatibility;
    short supplement13;
    short supplement14;
} pdf_cmap;

static const pdc_keyconn charcoll_names[] =
{
    { "\107\102\061",                     cc_simplified_chinese },    /* GB1 */
    { "\103\116\123\061",                 cc_traditional_chinese},   /* CNS1 */
    { "\112\141\160\141\156\061",         cc_japanese },           /* Japan1 */
    { "\113\157\162\145\141\061",         cc_korean},              /* Korea1 */
    { "\111\144\145\156\164\151\164\171", cc_identity}           /* Identity */
};

/* predefined CMaps and the corresponding character collection */

static const pdf_cmap cmaps[] = {
    { "GB-EUC-H",       cc_simplified_chinese, 0, PDC_1_3, 0, 0 },
    { "GB-EUC-V",       cc_simplified_chinese, 0, PDC_1_3, 0, 0 },
    { "GBpc-EUC-H",     cc_simplified_chinese, 0, PDC_1_3, 0, 0 },
    { "GBpc-EUC-V",     cc_simplified_chinese, 0, PDC_1_3, 0, 0 },
    { "GBK-EUC-H",      cc_simplified_chinese, 0, PDC_1_3, 2, 2 },
    { "GBK-EUC-V",      cc_simplified_chinese, 0, PDC_1_3, 2, 2 },
    { "GBKp-EUC-H",     cc_simplified_chinese, 0, PDC_1_4, 0, 2 },
    { "GBKp-EUC-V",     cc_simplified_chinese, 0, PDC_1_4, 0, 2 },
    { "GBK2K-H",        cc_simplified_chinese, 0, PDC_1_4, 0, 4 },
    { "GBK2K-V",        cc_simplified_chinese, 0, PDC_1_4, 0, 4 },
    { "UniGB-UCS2-H",   cc_simplified_chinese, 2, PDC_1_3, 2, 4 },
    { "UniGB-UCS2-V",   cc_simplified_chinese, 2, PDC_1_3, 2, 4 },

    { "B5pc-H",         cc_traditional_chinese, 0, PDC_1_3, 0, 0 },
    { "B5pc-V",         cc_traditional_chinese, 0, PDC_1_3, 0, 0 },
    { "HKscs-B5-H",     cc_traditional_chinese, 0, PDC_1_4, 0, 3 },
    { "HKscs-B5-V",     cc_traditional_chinese, 0, PDC_1_4, 0, 3 },
    { "ETen-B5-H",      cc_traditional_chinese, 0, PDC_1_3, 0, 0 },
    { "ETen-B5-V",      cc_traditional_chinese, 0, PDC_1_3, 0, 0 },
    { "ETenms-B5-H",    cc_traditional_chinese, 0, PDC_1_3, 0, 0 },
    { "ETenms-B5-V",    cc_traditional_chinese, 0, PDC_1_3, 0, 0 },
    { "CNS-EUC-H",      cc_traditional_chinese, 0, PDC_1_3, 0, 0 },
    { "CNS-EUC-V",      cc_traditional_chinese, 0, PDC_1_3, 0, 0 },
    { "UniCNS-UCS2-H",  cc_traditional_chinese, 2, PDC_1_3, 0, 3 },
    { "UniCNS-UCS2-V",  cc_traditional_chinese, 2, PDC_1_3, 0, 3 },

    { "83pv-RKSJ-H",    cc_japanese, 0, PDC_1_3, 1, 1 },
    { "90ms-RKSJ-H",    cc_japanese, 0, PDC_1_3, 2, 2 },
    { "90ms-RKSJ-V",    cc_japanese, 0, PDC_1_3, 2, 2 },
    { "90msp-RKSJ-H",   cc_japanese, 0, PDC_1_3, 2, 2 },
    { "90msp-RKSJ-V",   cc_japanese, 0, PDC_1_3, 2, 2 },
    { "90pv-RKSJ-H",    cc_japanese, 0, PDC_1_3, 1, 1 },
    { "Add-RKSJ-H",     cc_japanese, 0, PDC_1_3, 1, 1 },
    { "Add-RKSJ-V",     cc_japanese, 0, PDC_1_3, 1, 1 },
    { "EUC-H",          cc_japanese, 0, PDC_1_3, 1, 1 },
    { "EUC-V",          cc_japanese, 0, PDC_1_3, 1, 1 },
    { "Ext-RKSJ-H",     cc_japanese, 0, PDC_1_3, 2, 2 },
    { "Ext-RKSJ-V",     cc_japanese, 0, PDC_1_3, 2, 2 },
    { "H",              cc_japanese, 0, PDC_1_3, 1, 1 },
    { "V",              cc_japanese, 0, PDC_1_3, 1, 1 },
    { "UniJIS-UCS2-H",  cc_japanese, 2, PDC_1_3, 2, 4 },
    { "UniJIS-UCS2-V",  cc_japanese, 2, PDC_1_3, 2, 4 },
    { "UniJIS-UCS2-HW-H",       cc_japanese, -2, PDC_1_3, 2, 4 },
    { "UniJIS-UCS2-HW-V",       cc_japanese, -2, PDC_1_3, 2, 4 },

    { "KSC-EUC-H",      cc_korean, 0, PDC_1_3, 0, 0 },
    { "KSC-EUC-V",      cc_korean, 0, PDC_1_3, 0, 0 },
    { "KSCms-UHC-H",    cc_korean, 0, PDC_1_3, 1, 1 },
    { "KSCms-UHC-V",    cc_korean, 0, PDC_1_3, 1, 1 },
    { "KSCms-UHC-HW-H", cc_korean, 0, PDC_1_3, 1, 1 },
    { "KSCms-UHC-HW-V", cc_korean, 0, PDC_1_3, 1, 1 },
    { "KSCpc-EUC-H",    cc_korean, 0, PDC_1_3, 0, 0 },
    { "UniKS-UCS2-H",   cc_korean, 2, PDC_1_3, 1, 1 },
    { "UniKS-UCS2-V",   cc_korean, 2, PDC_1_3, 1, 1 },

    { "Identity-H",     cc_identity, 0, PDC_1_3, 0, 0 },
    { "Identity-V",     cc_identity, 0, PDC_1_3, 0, 0 }
};


#ifdef PDF_CJKFONTWIDTHS_SUPPORTED

/* PDF width arrays for glyph widths indexed by CID */
/* Must be parallel to the pdf_cid_metrics array */

static char *pdf_cid_width_arrays[] =
{
    /* HeiseiKakuGo-W5 */
    "/W[1[278 278 355 556 556 889 667 191 333 333 389 584 278 333 278\n"
    "278 556 556 556 556 556 556 556 556 556 556 278 278 584 584 584\n"
    "556 1015 667 667 722 722 667 611 778 722 278 500 667 556 833 722\n"
    "778 667 778 722 667 611 722 667 944 667 667 611 278 556 278 469\n"
    "556 333 556 556 500 556 556 278 556 556 222 222 500 222 833 556\n"
    "556 556 556 333 500 278 556 500 722 500 500 500 334 260 334 333\n"
    "1000 278 1000 260 1000 333 556 556 167 1000 1000 556 1000 556 333 333\n"
    "500 500 556 1000 1000 278 1000 350 222 333 1000 556 1000 1000 611]\n"
    "127 137 333\n"
    "140[370 556 778 1000\n"
    "365 889 278 222 611 944 611 584 737 584 737 1000 1000 333 333 556\n"
    "333 834 834 834 667 667 667 667 667 667 722 667 667 667 667 278\n"
    "278 278 278 722 722 778 778 778 778 778 1000 722 722 722 722 667\n"
    "667 556 556 556 556 556 556 500 556 556 556 556 278 278 278 278\n"
    "556 556 556 556 556 556 556 1000 556 556 556 556 500 556 500 667\n"
    "667 611 556 500 1000 500 556]\n"
    "231 632 500\n"
    "8718 8719 500]\n",

    /* HeiseiMin-W3 */
    "/W[1[250 333 408 500 500 833 778 180 333 333 500 564 250 333 250\n"
    "278 500 500 500 500 500 500 500 500 500 500 278 278 564 564 564\n"
    "444 921 722 667 667 722 611 556 722 722 333 389 722 611 889 722\n"
    "722 556 722 667 556 611 722 722 944 722 722 611 333 500 333 469\n"
    "500 333 444 500 444 500 444 333 500 500 278 278 500 278 778 500\n"
    "500 500 500 333 389 278 500 500 722 500 500 444 480 200 480 333\n"
    "1000 278 1000 200 1000 333 500 500 167 1000 1000 500 1000 500 333 333\n"
    "556 556 500 1000 1000 250 1000 350 333 444 1000 500 1000 1000 444]\n"
    "127 137 333\n"
    "139[889 276 611 722 889\n"
    "310 667 278 278 500 722 500 564 760 564 760 1000 1000 300 300 500\n"
    "300 750 750 750 722 722 722 722 722 722 667 611 611 611 611 333\n"
    "333 333 333 722 722 722 722 722 722 722 1000 722 722 722 722 722\n"
    "556 444 444 444 444 444 444 444 444 444 444 444 278 278 278 278\n"
    "500 500 500 500 500 500 500 1000 500 500 500 500 500 500 500 556\n"
    "722 611 500 389 980 444]\n"
    "230 632 500\n"
    "8718 8719 500]\n",

    /* HYGoThic-Medium */
    "/W[1[333 416 416 833 666 916 750 250 416 416 583 833 375 833 375\n"
    "375 583 583 583 583 583 583 583 583 583 583 416 416 833 833 833\n"
    "583 1000 666 708 750 750 666 625 833 750 291 541 708 583 875 750\n"
    "791 666 791 708 666 583 750 625 916 625 625 625 416 375 416 500\n"
    "500 500 583 625 583 625 583 375 625 583 250 250 541 250 916 625\n"
    "625 625 625 333 541 333 583 500 750 500 500 500 500 500 500 750]]\n",

    /* "HYSMyeongJo-Medium" */
    "/W[1[278 278 355 556 556 889 667 222 333 333 389 584 278 333 278\n"
    "278 556 556 556 556 556 556 556 556 556 556 278 278 584 584 584\n"
    "556 1015 667 667 722 722 667 611 778 722 278 500 667 556 833 722\n"
    "778 667 778 722 667 611 722 667 944 667 667 611 278 278 278 469\n"
    "556 222 556 556 500 556 556 278 556 556 222 222 500 222 833 556\n"
    "556 556 556 333 500 278 556 500 722 500 500 500 334 260 334 584]]\n",

    /* "MHei-Medium" (identical with HYSMyeongJo-Medium) */
    "/W[1[278 278 355 556 556 889 667 222 333 333 389 584 278 333 278\n"
    "278 556 556 556 556 556 556 556 556 556 556 278 278 584 584 584\n"
    "556 1015 667 667 722 722 667 611 778 722 278 500 667 556 833 722\n"
    "778 667 778 722 667 611 722 667 944 667 667 611 278 278 278 469\n"
    "556 222 556 556 500 556 556 278 556 556 222 222 500 222 833 556\n"
    "556 556 556 333 500 278 556 500 722 500 500 500 334 260 334 584]]\n",

    /* "MSung-Light" */
    "/W[1[250 250 408 668 490 875 698 250 240 240 417 667 250 313 250\n"
    "520 500 500 500 500 500 500 500 500 500 500 250 250 667 667 667\n"
    "396 921 677 615 719 760 625 552 771 802 354 354 781 604 927 750\n"
    "823 563 823 729 542 698 771 729 948 771 677 635 344 520 344 469\n"
    "500 250 469 521 427 521 438 271 469 531 250 250 458 240 802 531\n"
    "500 521 521 365 333 292 521 458 677 479 458 427 480 496 480 667]]\n",

    /* "STSong-Light" */
    "/W[1[207 270 342 467 462 797 710 239 374 374 423 605 238 375 238\n"
    "334 462 462 462 462 462 462 462 462 462 462 238 238 605 605 605\n"
    "344 748 684 560 695 739 563 511 729 793 318 312 666 526 896 758\n"
    "772 544 772 628 465 607 753 711 972 647 620 607 374 333 374 606\n"
    "500 239 417 503 427 529 415 264 444 518 241 230 495 228 793 527\n"
    "524 524 504 338 336 277 517 450 652 466 452 407 370 258 370 605]]\n",

    /* HYSMyeongJoStd-Medium-Acro */
    "/W[1[333 416 416 833 625 916 833 250 500 500 500 833 291 833 291\n"
    "375 625 625 625 625 625 625 625 625 625 625 333 333 833 833 916\n"
    "500 1000 791 708 708 750 708 666 750 791 375 500 791 666 916 791\n"
    "750 666 750 708 666 791 791 750 1000 708 708 666 500 375 500 500\n"
    "500 333 541 583 541 583 583 375 583 583 291 333 583 291 875 583\n"
    "583 583 583 458 541 375 583 583 833 625 625 500 583 583 583 750]]\n",

    /* KozMinPro-Regular-Acro */
    "/W[1[278 299 353 614 614 721 735 216 323 323 449 529 219 306 219\n"
    "453 614 614 614 614 614 614 614 614 614 614 219 219 529 529 529\n"
    "486 744 646 604 617 681 567 537 647 738 320 433 637 566 904 710\n"
    "716 605 716 623 517 601 690 668 990 681 634 578 316 614 316 529\n"
    "500 387 509 566 478 565 503 337 549 580 275 266 544 276 854 579\n"
    "550 578 566 410 444 340 575 512 760 503 529 453 326 380 326 387\n"
    "1000 453 1000 380 1000 299 614 614 265 1000 1000 614 1000 451 291 291\n"
    "588 589 500 1000 1000 219 1000 452 216 353 1000 451 1000 1000 486 387]\n"
    "128 135 387\n"
    "136[387 387 1000 880 448 566 716 903\n"
    "460 805 275 276 550 886 582 529 738 529 738 1000 1000 406 406 575\n"
    "406 934 934 934 646 646 646 646 646 646 617 567 567 567 567 320\n"
    "320 320 320 681 710 716 716 716 716 716 1000 690 690 690 690 634\n"
    "605 509 509 509 509 509 509 478 503 503 503 503 275 275 275 275\n"
    "550 579 550 550 550 550 550 1000 575 575 575 575 529 578 529 517\n"
    "634 578 445 444 842 453 1000 500]\n"
    "323[500 1000 500 1000 500]\n"
    "328 383 500\n"
    "384[500 500 500 500 500 500]\n"
    "9354[614 684 1000 1000 648 899\n"
    "903 509 275 575 503 550 646 320 690 567 716 934 934 934 934 934\n"
    "934 426 426 426 426 426 426 426 426 425 425 425 439 426 426 426\n"
    "426 426 646 567 1000 567 320 1000 320 716 1000 690 690 690 509 503\n"
    "1000 503 275 1000 275 550 1000 575 575 575 513 1000 1000 805 1000 478\n"
    "1000 1000 503 1000 1000 735 1000 1000 426 1000 1000 1000 578 553 512\n"
    "1000 1000 640 594 284]]\n",

    /* MSungStd-Light-Acro */
    "/W[1[250 250 408 668 490 875 698 250 240 240 417 667 250 313 250\n"
    "520 500 500 500 500 500 500 500 500 500 500 250 250 667 667 667\n"
    "396 921 677 615 719 760 625 552 771 802 354 354 781 604 927 750\n"
    "823 563 823 729 542 698 771 729 948 771 677 635 344 520 344 469\n"
    "500 250 469 521 427 521 438 271 469 531 250 250 458 240 802 531\n"
    "500 521 521 365 333 292 521 458 677 479 458 427 480 496 480 667]\n"
    "17601 17601 500]\n",

    /* STSongStd-Light-Acro */
    "/W[1[207 270 342 467 462 797 710 239 374 374 423 605 238 375 238\n"
    "334 462 462 462 462 462 462 462 462 462 462 238 238 605 605 605\n"
    "344 748 684 560 695 739 563 511 729 793 318 312 666 526 896 758\n"
    "772 544 772 628 465 607 753 711 972 647 620 607 374 333 374 606\n"
    "500 239 417 503 427 529 415 264 444 518 241 230 495 228 793 527\n"
    "524 524 504 338 336 277 517 450 652 466 452 407 370 258 370 605]\n"
    "22353[462 462 1000 1000 500]]\n",

    NULL
};


/* Unicode intervals for glyph widths of preinstalled CID fonts */

static pdc_interwidth pdf_HeiseiKakuGo_W5_widths[163] =
{
    {0x0000, 278}, {0x0022, 355}, {0x0023, 556}, {0x0025, 889},
    {0x0026, 667}, {0x0027, 191}, {0x0028, 333}, {0x002A, 389},
    {0x002B, 584}, {0x002C, 278}, {0x002D, 333}, {0x002E, 278},
    {0x0030, 556}, {0x003A, 278}, {0x003C, 584}, {0x003F, 556},
    {0x0040,1015}, {0x0041, 667}, {0x0043, 722}, {0x0045, 667},
    {0x0046, 611}, {0x0047, 778}, {0x0048, 722}, {0x0049, 278},
    {0x004A, 500}, {0x004B, 667}, {0x004C, 556}, {0x004D, 833},
    {0x004E, 722}, {0x004F, 778}, {0x0050, 667}, {0x0051, 778},
    {0x0052, 722}, {0x0053, 667}, {0x0054, 611}, {0x0055, 722},
    {0x0056, 667}, {0x0057, 944}, {0x0058, 667}, {0x005A, 611},
    {0x005B, 278}, {0x005E, 469}, {0x005F, 556}, {0x0060, 333},
    {0x0061, 556}, {0x0063, 500}, {0x0064, 556}, {0x0066, 278},
    {0x0067, 556}, {0x0069, 222}, {0x006B, 500}, {0x006C, 222},
    {0x006D, 833}, {0x006E, 556}, {0x0072, 333}, {0x0073, 500},
    {0x0074, 278}, {0x0075, 556}, {0x0076, 500}, {0x0077, 722},
    {0x0078, 500}, {0x007B, 334}, {0x007C, 260}, {0x007D, 334},
    {0x007E, 333}, {0x007F,1000}, {0x00A1, 333}, {0x00A2, 556},
    {0x00A6, 260}, {0x00A7,1000}, {0x00A9, 737}, {0x00AA, 370},
    {0x00AB, 556}, {0x00AC, 584}, {0x00AE, 737}, {0x00AF, 333},
    {0x00B0,1000}, {0x00B2, 333}, {0x00B4,1000}, {0x00B5, 556},
    {0x00B6,1000}, {0x00B7, 278}, {0x00B8, 333}, {0x00BA, 365},
    {0x00BB, 556}, {0x00BC, 834}, {0x00BF, 611}, {0x00C0, 667},
    {0x00C6,1000}, {0x00C7, 722}, {0x00C8, 667}, {0x00CC, 278},
    {0x00D0, 722}, {0x00D2, 778}, {0x00D7,1000}, {0x00D8, 778},
    {0x00D9, 722}, {0x00DD, 667}, {0x00DF, 611}, {0x00E0, 556},
    {0x00E6, 889}, {0x00E7, 500}, {0x00E8, 556}, {0x00EC, 278},
    {0x00F0, 556}, {0x00F7,1000}, {0x00F8, 611}, {0x00F9, 556},
    {0x00FD, 500}, {0x00FE, 556}, {0x00FF, 500}, {0x0100,1000},
    {0x0131, 278}, {0x0132,1000}, {0x0141, 556}, {0x0142, 222},
    {0x0143,1000}, {0x0153, 944}, {0x0154,1000}, {0x0160, 667},
    {0x0161, 500}, {0x0162,1000}, {0x0178, 667}, {0x0179,1000},
    {0x017D, 611}, {0x017E, 500}, {0x017F,1000}, {0x01C0, 260},
    {0x01C1,1000}, {0x0300, 333}, {0x0305, 556}, {0x0306, 333},
    {0x0309,1000}, {0x030A, 333}, {0x030D,1000}, {0x0327, 333},
    {0x0329,1000}, {0x0332, 556}, {0x0333,1000}, {0x2002, 500},
    {0x2003,1000}, {0x2011, 333}, {0x2012, 556}, {0x2014,1000},
    {0x201A, 222}, {0x201B,1000}, {0x201E, 333}, {0x201F,1000},
    {0x2022, 350}, {0x2023,1000}, {0x2039, 333}, {0x203B,1000},
    {0x203E, 500}, {0x203F,1000}, {0x2044, 167}, {0x2045,1000},
    {0xFB01, 500}, {0xFB03,1000}, {0xFF61, 500}, {0xFFA0,1000},
    {0xFFE8, 500}, {0xFFE9,1000}, {0xFFFF,1000}
};

static pdc_interwidth pdf_HeiseiMin_W3_widths[164] =
{
    {0x0000, 250}, {0x0021, 333}, {0x0022, 408}, {0x0023, 500},
    {0x0025, 833}, {0x0026, 778}, {0x0027, 180}, {0x0028, 333},
    {0x002A, 500}, {0x002B, 564}, {0x002C, 250}, {0x002D, 333},
    {0x002E, 250}, {0x002F, 278}, {0x0030, 500}, {0x003A, 278},
    {0x003C, 564}, {0x003F, 444}, {0x0040, 921}, {0x0041, 722},
    {0x0042, 667}, {0x0044, 722}, {0x0045, 611}, {0x0046, 556},
    {0x0047, 722}, {0x0049, 333}, {0x004A, 389}, {0x004B, 722},
    {0x004C, 611}, {0x004D, 889}, {0x004E, 722}, {0x0050, 556},
    {0x0051, 722}, {0x0052, 667}, {0x0053, 556}, {0x0054, 611},
    {0x0055, 722}, {0x0057, 944}, {0x0058, 722}, {0x005A, 611},
    {0x005B, 333}, {0x005C, 278}, {0x005D, 333}, {0x005E, 469},
    {0x005F, 500}, {0x0060, 333}, {0x0061, 444}, {0x0062, 500},
    {0x0063, 444}, {0x0064, 500}, {0x0065, 444}, {0x0066, 333},
    {0x0067, 500}, {0x0069, 278}, {0x006B, 500}, {0x006C, 278},
    {0x006D, 778}, {0x006E, 500}, {0x0072, 333}, {0x0073, 389},
    {0x0074, 278}, {0x0075, 500}, {0x0077, 722}, {0x0078, 500},
    {0x007A, 444}, {0x007B, 480}, {0x007C, 200}, {0x007D, 480},
    {0x007E, 333}, {0x007F,1000}, {0x00A1, 333}, {0x00A2, 500},
    {0x00A6, 200}, {0x00A7,1000}, {0x00A9, 760}, {0x00AA, 276},
    {0x00AB, 500}, {0x00AC, 564}, {0x00AE, 760}, {0x00AF, 333},
    {0x00B0,1000}, {0x00B2, 300}, {0x00B4,1000}, {0x00B5, 500},
    {0x00B6,1000}, {0x00B7, 250}, {0x00B8, 333}, {0x00B9, 300},
    {0x00BA, 310}, {0x00BB, 500}, {0x00BC, 750}, {0x00BF, 444},
    {0x00C0, 722}, {0x00C6, 889}, {0x00C7, 667}, {0x00C8, 611},
    {0x00CC, 333}, {0x00D0, 722}, {0x00D7,1000}, {0x00D8, 722},
    {0x00DE, 556}, {0x00DF, 500}, {0x00E0, 444}, {0x00E6, 667},
    {0x00E7, 444}, {0x00EC, 278}, {0x00F0, 500}, {0x00F7,1000},
    {0x00F8, 500}, {0x0100,1000}, {0x0131, 278}, {0x0132,1000},
    {0x0141, 611}, {0x0142, 278}, {0x0143,1000}, {0x0152, 889},
    {0x0153, 722}, {0x0154,1000}, {0x0160, 556}, {0x0161, 389},
    {0x0162,1000}, {0x0178, 722}, {0x0179,1000}, {0x017D, 611},
    {0x017E, 444}, {0x017F,1000}, {0x01C0, 200}, {0x01C1,1000},
    {0x0300, 333}, {0x0305, 500}, {0x0306, 333}, {0x0309,1000},
    {0x030A, 333}, {0x030D,1000}, {0x0327, 333}, {0x0329,1000},
    {0x0332, 500}, {0x0333,1000}, {0x2002, 500}, {0x2003,1000},
    {0x2011, 333}, {0x2012, 500}, {0x2014,1000}, {0x201A, 333},
    {0x201B,1000}, {0x201E, 444}, {0x201F,1000}, {0x2022, 350},
    {0x2023,1000}, {0x2039, 333}, {0x203B,1000}, {0x203E, 500},
    {0x203F,1000}, {0x2044, 167}, {0x2045,1000}, {0x2122, 980},
    {0x2123,1000}, {0xFB01, 556}, {0xFB03,1000}, {0xFF61, 500},
    {0xFFA0,1000}, {0xFFE8, 500}, {0xFFE9,1000}, {0xFFFF,1000}
};

static pdc_interwidth pdf_HYGoThic_Medium_widths[68] =
{
    {0x0000, 333}, {0x0021, 416}, {0x0023, 833}, {0x0024, 666},
    {0x0025, 916}, {0x0026, 750}, {0x0027, 250}, {0x0028, 416},
    {0x002A, 583}, {0x002B, 833}, {0x002C, 375}, {0x002D, 833},
    {0x002E, 375}, {0x0030, 583}, {0x003A, 416}, {0x003C, 833},
    {0x003F, 583}, {0x0040,1000}, {0x0041, 666}, {0x0042, 708},
    {0x0043, 750}, {0x0045, 666}, {0x0046, 625}, {0x0047, 833},
    {0x0048, 750}, {0x0049, 291}, {0x004A, 541}, {0x004B, 708},
    {0x004C, 583}, {0x004D, 875}, {0x004E, 750}, {0x004F, 791},
    {0x0050, 666}, {0x0051, 791}, {0x0052, 708}, {0x0053, 666},
    {0x0054, 583}, {0x0055, 750}, {0x0056, 625}, {0x0057, 916},
    {0x0058, 625}, {0x005B, 416}, {0x005C, 375}, {0x005D, 416},
    {0x005E, 500}, {0x0061, 583}, {0x0062, 625}, {0x0063, 583},
    {0x0064, 625}, {0x0065, 583}, {0x0066, 375}, {0x0067, 625},
    {0x0068, 583}, {0x0069, 250}, {0x006B, 541}, {0x006C, 250},
    {0x006D, 916}, {0x006E, 625}, {0x0072, 333}, {0x0073, 541},
    {0x0074, 333}, {0x0075, 583}, {0x0076, 500}, {0x0077, 750},
    {0x0078, 500}, {0x007E, 750}, {0x007F,1000}, {0xFFFF,1000}
};

static pdc_interwidth pdf_HYSMyeongJo_Medium_widths[67] =
{
    {0x0000, 278}, {0x0022, 355}, {0x0023, 556}, {0x0025, 889},
    {0x0026, 667}, {0x0027, 222}, {0x0028, 333}, {0x002A, 389},
    {0x002B, 584}, {0x002C, 278}, {0x002D, 333}, {0x002E, 278},
    {0x0030, 556}, {0x003A, 278}, {0x003C, 584}, {0x003F, 556},
    {0x0040,1015}, {0x0041, 667}, {0x0043, 722}, {0x0045, 667},
    {0x0046, 611}, {0x0047, 778}, {0x0048, 722}, {0x0049, 278},
    {0x004A, 500}, {0x004B, 667}, {0x004C, 556}, {0x004D, 833},
    {0x004E, 722}, {0x004F, 778}, {0x0050, 667}, {0x0051, 778},
    {0x0052, 722}, {0x0053, 667}, {0x0054, 611}, {0x0055, 722},
    {0x0056, 667}, {0x0057, 944}, {0x0058, 667}, {0x005A, 611},
    {0x005B, 278}, {0x005E, 469}, {0x005F, 556}, {0x0060, 222},
    {0x0061, 556}, {0x0063, 500}, {0x0064, 556}, {0x0066, 278},
    {0x0067, 556}, {0x0069, 222}, {0x006B, 500}, {0x006C, 222},
    {0x006D, 833}, {0x006E, 556}, {0x0072, 333}, {0x0073, 500},
    {0x0074, 278}, {0x0075, 556}, {0x0076, 500}, {0x0077, 722},
    {0x0078, 500}, {0x007B, 334}, {0x007C, 260}, {0x007D, 334},
    {0x007E, 584}, {0x007F,1000}, {0xFFFF,1000}
};

static pdc_interwidth pdf_MSung_Light_widths[80] =
{
    {0x0000, 250}, {0x0022, 408}, {0x0023, 668}, {0x0024, 490},
    {0x0025, 875}, {0x0026, 698}, {0x0027, 250}, {0x0028, 240},
    {0x002A, 417}, {0x002B, 667}, {0x002C, 250}, {0x002D, 313},
    {0x002E, 250}, {0x002F, 520}, {0x0030, 500}, {0x003A, 250},
    {0x003C, 667}, {0x003F, 396}, {0x0040, 921}, {0x0041, 677},
    {0x0042, 615}, {0x0043, 719}, {0x0044, 760}, {0x0045, 625},
    {0x0046, 552}, {0x0047, 771}, {0x0048, 802}, {0x0049, 354},
    {0x004B, 781}, {0x004C, 604}, {0x004D, 927}, {0x004E, 750},
    {0x004F, 823}, {0x0050, 563}, {0x0051, 823}, {0x0052, 729},
    {0x0053, 542}, {0x0054, 698}, {0x0055, 771}, {0x0056, 729},
    {0x0057, 948}, {0x0058, 771}, {0x0059, 677}, {0x005A, 635},
    {0x005B, 344}, {0x005C, 520}, {0x005D, 344}, {0x005E, 469},
    {0x005F, 500}, {0x0060, 250}, {0x0061, 469}, {0x0062, 521},
    {0x0063, 427}, {0x0064, 521}, {0x0065, 438}, {0x0066, 271},
    {0x0067, 469}, {0x0068, 531}, {0x0069, 250}, {0x006B, 458},
    {0x006C, 240}, {0x006D, 802}, {0x006E, 531}, {0x006F, 500},
    {0x0070, 521}, {0x0072, 365}, {0x0073, 333}, {0x0074, 292},
    {0x0075, 521}, {0x0076, 458}, {0x0077, 677}, {0x0078, 479},
    {0x0079, 458}, {0x007A, 427}, {0x007B, 480}, {0x007C, 496},
    {0x007D, 480}, {0x007E, 667}, {0x007F,1000}, {0xFFFF,1000}
};

static pdc_interwidth pdf_STSong_Light_widths[83] =
{
    {0x0000, 207}, {0x0021, 270}, {0x0022, 342}, {0x0023, 467},
    {0x0024, 462}, {0x0025, 797}, {0x0026, 710}, {0x0027, 239},
    {0x0028, 374}, {0x002A, 423}, {0x002B, 605}, {0x002C, 238},
    {0x002D, 375}, {0x002E, 238}, {0x002F, 334}, {0x0030, 462},
    {0x003A, 238}, {0x003C, 605}, {0x003F, 344}, {0x0040, 748},
    {0x0041, 684}, {0x0042, 560}, {0x0043, 695}, {0x0044, 739},
    {0x0045, 563}, {0x0046, 511}, {0x0047, 729}, {0x0048, 793},
    {0x0049, 318}, {0x004A, 312}, {0x004B, 666}, {0x004C, 526},
    {0x004D, 896}, {0x004E, 758}, {0x004F, 772}, {0x0050, 544},
    {0x0051, 772}, {0x0052, 628}, {0x0053, 465}, {0x0054, 607},
    {0x0055, 753}, {0x0056, 711}, {0x0057, 972}, {0x0058, 647},
    {0x0059, 620}, {0x005A, 607}, {0x005B, 374}, {0x005C, 333},
    {0x005D, 374}, {0x005E, 606}, {0x005F, 500}, {0x0060, 239},
    {0x0061, 417}, {0x0062, 503}, {0x0063, 427}, {0x0064, 529},
    {0x0065, 415}, {0x0066, 264}, {0x0067, 444}, {0x0068, 518},
    {0x0069, 241}, {0x006A, 230}, {0x006B, 495}, {0x006C, 228},
    {0x006D, 793}, {0x006E, 527}, {0x006F, 524}, {0x0071, 504},
    {0x0072, 338}, {0x0073, 336}, {0x0074, 277}, {0x0075, 517},
    {0x0076, 450}, {0x0077, 652}, {0x0078, 466}, {0x0079, 452},
    {0x007A, 407}, {0x007B, 370}, {0x007C, 258}, {0x007D, 370},
    {0x007E, 605}, {0x007F,1000}, {0xFFFF,1000}
};

static pdc_interwidth pdf_HYSMyeongJoStd_Medium_widths[69] =
{
    {0x0000, 333}, {0x0021, 416}, {0x0023, 833}, {0x0024, 625},
    {0x0025, 916}, {0x0026, 833}, {0x0027, 250}, {0x0028, 500},
    {0x002B, 833}, {0x002C, 291}, {0x002D, 833}, {0x002E, 291},
    {0x002F, 375}, {0x0030, 625}, {0x003A, 333}, {0x003C, 833},
    {0x003E, 916}, {0x003F, 500}, {0x0040,1000}, {0x0041, 791},
    {0x0042, 708}, {0x0044, 750}, {0x0045, 708}, {0x0046, 666},
    {0x0047, 750}, {0x0048, 791}, {0x0049, 375}, {0x004A, 500},
    {0x004B, 791}, {0x004C, 666}, {0x004D, 916}, {0x004E, 791},
    {0x004F, 750}, {0x0050, 666}, {0x0051, 750}, {0x0052, 708},
    {0x0053, 666}, {0x0054, 791}, {0x0056, 750}, {0x0057,1000},
    {0x0058, 708}, {0x005A, 666}, {0x005B, 500}, {0x005C, 375},
    {0x005D, 500}, {0x0060, 333}, {0x0061, 541}, {0x0062, 583},
    {0x0063, 541}, {0x0064, 583}, {0x0066, 375}, {0x0067, 583},
    {0x0069, 291}, {0x006A, 333}, {0x006B, 583}, {0x006C, 291},
    {0x006D, 875}, {0x006E, 583}, {0x0072, 458}, {0x0073, 541},
    {0x0074, 375}, {0x0075, 583}, {0x0077, 833}, {0x0078, 625},
    {0x007A, 500}, {0x007B, 583}, {0x007E, 750}, {0x007F,1000},
    {0xFFFF,1000}
};

static pdc_interwidth pdf_KozMinPro_Regular_widths[265] =
{
    {0x0000, 278}, {0x0021, 299}, {0x0022, 353}, {0x0023, 614},
    {0x0025, 721}, {0x0026, 735}, {0x0027, 216}, {0x0028, 323},
    {0x002A, 449}, {0x002B, 529}, {0x002C, 219}, {0x002D, 306},
    {0x002E, 219}, {0x002F, 453}, {0x0030, 614}, {0x003A, 219},
    {0x003C, 529}, {0x003F, 486}, {0x0040, 744}, {0x0041, 646},
    {0x0042, 604}, {0x0043, 617}, {0x0044, 681}, {0x0045, 567},
    {0x0046, 537}, {0x0047, 647}, {0x0048, 738}, {0x0049, 320},
    {0x004A, 433}, {0x004B, 637}, {0x004C, 566}, {0x004D, 904},
    {0x004E, 710}, {0x004F, 716}, {0x0050, 605}, {0x0051, 716},
    {0x0052, 623}, {0x0053, 517}, {0x0054, 601}, {0x0055, 690},
    {0x0056, 668}, {0x0057, 990}, {0x0058, 681}, {0x0059, 634},
    {0x005A, 578}, {0x005B, 316}, {0x005C, 453}, {0x005D, 316},
    {0x005E, 529}, {0x005F, 500}, {0x0060, 387}, {0x0061, 509},
    {0x0062, 566}, {0x0063, 478}, {0x0064, 565}, {0x0065, 503},
    {0x0066, 337}, {0x0067, 549}, {0x0068, 580}, {0x0069, 275},
    {0x006A, 266}, {0x006B, 544}, {0x006C, 276}, {0x006D, 854},
    {0x006E, 579}, {0x006F, 550}, {0x0070, 578}, {0x0071, 566},
    {0x0072, 410}, {0x0073, 444}, {0x0074, 340}, {0x0075, 575},
    {0x0076, 512}, {0x0077, 760}, {0x0078, 503}, {0x0079, 529},
    {0x007A, 453}, {0x007B, 326}, {0x007C, 380}, {0x007D, 326},
    {0x007E, 387}, {0x007F,1000}, {0x00A1, 299}, {0x00A2, 614},
    {0x00A6, 380}, {0x00A7,1000}, {0x00A9, 738}, {0x00AA, 448},
    {0x00AB, 451}, {0x00AC, 529}, {0x00AE, 738}, {0x00AF, 387},
    {0x00B0,1000}, {0x00B2, 406}, {0x00B4,1000}, {0x00B5, 575},
    {0x00B6,1000}, {0x00B7, 219}, {0x00B8, 387}, {0x00B9, 406},
    {0x00BA, 460}, {0x00BB, 451}, {0x00BC, 934}, {0x00BF, 486},
    {0x00C0, 646}, {0x00C6, 880}, {0x00C7, 617}, {0x00C8, 567},
    {0x00CC, 320}, {0x00D0, 681}, {0x00D1, 710}, {0x00D2, 716},
    {0x00D7,1000}, {0x00D8, 716}, {0x00D9, 690}, {0x00DD, 634},
    {0x00DE, 605}, {0x00DF, 582}, {0x00E0, 509}, {0x00E6, 805},
    {0x00E7, 478}, {0x00E8, 503}, {0x00EC, 275}, {0x00F0, 550},
    {0x00F1, 579}, {0x00F2, 550}, {0x00F7,1000}, {0x00F8, 550},
    {0x00F9, 575}, {0x00FD, 529}, {0x00FE, 578}, {0x00FF, 529},
    {0x0100, 646}, {0x0101, 509}, {0x0102,1000}, {0x0112, 567},
    {0x0113, 503}, {0x0114,1000}, {0x011A, 567}, {0x011B, 503},
    {0x011C,1000}, {0x0128, 320}, {0x0129, 275}, {0x012A, 320},
    {0x012B, 275}, {0x012C,1000}, {0x0131, 275}, {0x0132,1000},
    {0x0141, 566}, {0x0142, 276}, {0x0143,1000}, {0x014B, 578},
    {0x014C, 716}, {0x014D, 550}, {0x014E,1000}, {0x0152, 903},
    {0x0153, 886}, {0x0154,1000}, {0x0160, 517}, {0x0161, 444},
    {0x0162,1000}, {0x0168, 690}, {0x0169, 575}, {0x016A, 690},
    {0x016B, 575}, {0x016C,1000}, {0x016E, 690}, {0x016F, 575},
    {0x0170,1000}, {0x0178, 634}, {0x0179,1000}, {0x017D, 578},
    {0x017E, 453}, {0x017F,1000}, {0x01C0, 380}, {0x01C1,1000},
    {0x01CD, 646}, {0x01CE, 509}, {0x01CF, 320}, {0x01D0, 275},
    {0x01D1, 716}, {0x01D2, 550}, {0x01D3, 690}, {0x01D4, 575},
    {0x01D5,1000}, {0x01FD, 805}, {0x01FE,1000}, {0x0251, 513},
    {0x0252,1000}, {0x0254, 478}, {0x0255,1000}, {0x0259, 503},
    {0x025A, 735}, {0x025B, 426}, {0x025C,1000}, {0x0275, 553},
    {0x0276,1000}, {0x0283, 594}, {0x0284,1000}, {0x028C, 512},
    {0x028D,1000}, {0x0292, 640}, {0x0293,1000}, {0x02D0, 284},
    {0x02D1,1000}, {0x0300, 387}, {0x0305, 445}, {0x0306, 387},
    {0x0309,1000}, {0x030A, 387}, {0x030D,1000}, {0x0327, 387},
    {0x0329,1000}, {0x0332, 500}, {0x0333,1000}, {0x0EBC, 567},
    {0x0EBD, 503}, {0x0EBE,1000}, {0x2002, 500}, {0x2003,1000},
    {0x2011, 306}, {0x2012, 500}, {0x2014,1000}, {0x201A, 216},
    {0x201B,1000}, {0x201E, 353}, {0x201F,1000}, {0x2022, 452},
    {0x2023,1000}, {0x2039, 291}, {0x203B,1000}, {0x203E, 500},
    {0x203F,1000}, {0x2044, 265}, {0x2045,1000}, {0x2070, 426},
    {0x2071,1000}, {0x2074, 426}, {0x207A,1000}, {0x2080, 426},
    {0x2081, 425}, {0x2084, 439}, {0x2085, 426}, {0x208A,1000},
    {0x20AC, 614}, {0x20AD,1000}, {0x2122, 842}, {0x2123,1000},
    {0x2126, 684}, {0x2127,1000}, {0x2153, 934}, {0x2155,1000},
    {0x215B, 934}, {0x215F,1000}, {0xFB00, 648}, {0xFB01, 588},
    {0xFB02, 589}, {0xFB03, 899}, {0xFB04, 903}, {0xFB05,1000},
    {0xFF61, 500}, {0xFFA0,1000}, {0xFFE8, 500}, {0xFFE9,1000},
    {0xFFFF,1000}
};

static pdc_interwidth pdf_MSungStd_Light_widths[82] =
{
    {0x0000, 250}, {0x0022, 408}, {0x0023, 668}, {0x0024, 490},
    {0x0025, 875}, {0x0026, 698}, {0x0027, 250}, {0x0028, 240},
    {0x002A, 417}, {0x002B, 667}, {0x002C, 250}, {0x002D, 313},
    {0x002E, 250}, {0x002F, 520}, {0x0030, 500}, {0x003A, 250},
    {0x003C, 667}, {0x003F, 396}, {0x0040, 921}, {0x0041, 677},
    {0x0042, 615}, {0x0043, 719}, {0x0044, 760}, {0x0045, 625},
    {0x0046, 552}, {0x0047, 771}, {0x0048, 802}, {0x0049, 354},
    {0x004B, 781}, {0x004C, 604}, {0x004D, 927}, {0x004E, 750},
    {0x004F, 823}, {0x0050, 563}, {0x0051, 823}, {0x0052, 729},
    {0x0053, 542}, {0x0054, 698}, {0x0055, 771}, {0x0056, 729},
    {0x0057, 948}, {0x0058, 771}, {0x0059, 677}, {0x005A, 635},
    {0x005B, 344}, {0x005C, 520}, {0x005D, 344}, {0x005E, 469},
    {0x005F, 500}, {0x0060, 250}, {0x0061, 469}, {0x0062, 521},
    {0x0063, 427}, {0x0064, 521}, {0x0065, 438}, {0x0066, 271},
    {0x0067, 469}, {0x0068, 531}, {0x0069, 250}, {0x006B, 458},
    {0x006C, 240}, {0x006D, 802}, {0x006E, 531}, {0x006F, 500},
    {0x0070, 521}, {0x0072, 365}, {0x0073, 333}, {0x0074, 292},
    {0x0075, 521}, {0x0076, 458}, {0x0077, 677}, {0x0078, 479},
    {0x0079, 458}, {0x007A, 427}, {0x007B, 480}, {0x007C, 496},
    {0x007D, 480}, {0x007E, 667}, {0x007F,1000}, {0x20AC, 500},
    {0x20AD,1000}, {0xFFFF,1000}
};

static pdc_interwidth pdf_STSongStd_Light_widths[89] =
{
    {0x0000, 207}, {0x0021, 270}, {0x0022, 342}, {0x0023, 467},
    {0x0024, 462}, {0x0025, 797}, {0x0026, 710}, {0x0027, 239},
    {0x0028, 374}, {0x002A, 423}, {0x002B, 605}, {0x002C, 238},
    {0x002D, 375}, {0x002E, 238}, {0x002F, 334}, {0x0030, 462},
    {0x003A, 238}, {0x003C, 605}, {0x003F, 344}, {0x0040, 748},
    {0x0041, 684}, {0x0042, 560}, {0x0043, 695}, {0x0044, 739},
    {0x0045, 563}, {0x0046, 511}, {0x0047, 729}, {0x0048, 793},
    {0x0049, 318}, {0x004A, 312}, {0x004B, 666}, {0x004C, 526},
    {0x004D, 896}, {0x004E, 758}, {0x004F, 772}, {0x0050, 544},
    {0x0051, 772}, {0x0052, 628}, {0x0053, 465}, {0x0054, 607},
    {0x0055, 753}, {0x0056, 711}, {0x0057, 972}, {0x0058, 647},
    {0x0059, 620}, {0x005A, 607}, {0x005B, 374}, {0x005C, 333},
    {0x005D, 374}, {0x005E, 606}, {0x005F, 500}, {0x0060, 239},
    {0x0061, 417}, {0x0062, 503}, {0x0063, 427}, {0x0064, 529},
    {0x0065, 415}, {0x0066, 264}, {0x0067, 444}, {0x0068, 518},
    {0x0069, 241}, {0x006A, 230}, {0x006B, 495}, {0x006C, 228},
    {0x006D, 793}, {0x006E, 527}, {0x006F, 524}, {0x0071, 504},
    {0x0072, 338}, {0x0073, 336}, {0x0074, 277}, {0x0075, 517},
    {0x0076, 450}, {0x0077, 652}, {0x0078, 466}, {0x0079, 452},
    {0x007A, 407}, {0x007B, 370}, {0x007C, 258}, {0x007D, 370},
    {0x007E, 605}, {0x007F,1000}, {0x00A5, 462}, {0x00A6,1000},
    {0x20AC, 462}, {0x20AD,1000}, {0x303F, 500}, {0x3040,1000},
    {0xFFFF,1000}
};

#endif /* PDF_CJKFONTWIDTHS_SUPPORTED */

/* Font descriptors for the preinstalled CID fonts */

static const pdc_core_metric pdf_cid_metrics[] = {

/* Acrobat 4 standard fonts */
/* ---------------------------------------------------------- */
{	"HeiseiKakuGo-W5",		/* FontName */
	4L,				/* Font flags */
        pdc_CIDFontType0,               /* font type */
	cc_japanese,			/* Character collection */
	(float) 0.0,			/* ItalicAngle */
	pdc_true,			/* isFixedPitch */
	-92,				/* llx */
	-250,				/* lly */
	1010,				/* urx */
	922,				/* ury */
	-100,				/* UnderlinePosition */
	50,				/* UnderlineThickness */
	737,				/* CapHeight */
	553,				/* xHeight */
	752,				/* Ascender */
	-221,				/* Descender */
	114,				/* StdVW */
	0,				/* StdHW */

#ifdef PDF_CJKFONTWIDTHS_SUPPORTED
        163,                            /* numOfInter */
        pdf_HeiseiKakuGo_W5_widths,     /* ciw */
#else  /* PDF_CJKFONTWIDTHS_SUPPORTED */
        0,
        NULL,
#endif /* !PDF_CJKFONTWIDTHS_SUPPORTED */

        0,                              /* numOfGlyphs */
        (pdc_glyphwidth *) NULL,        /* glw */

},

/* ---------------------------------------------------------- */
{	"HeiseiMin-W3",			/* FontName */
	6L,				/* Font flags */
        pdc_CIDFontType0,               /* font type */
	cc_japanese,			/* Character collection */
	(float) 0.0,			/* ItalicAngle */
	pdc_true,			/* isFixedPitch */
	-123,				/* llx */
	-257,				/* lly */
	1001,				/* urx */
	910,				/* ury */
	-100,				/* UnderlinePosition */
	50,				/* UnderlineThickness */
	709,				/* CapHeight */
	450,				/* xHeight */
	723,				/* Ascender */
	-241,				/* Descender */
	69,				/* StdVW */
	0,				/* StdHW */

#ifdef PDF_CJKFONTWIDTHS_SUPPORTED
        164,                            /* numOfInter */
        pdf_HeiseiMin_W3_widths,        /* ciw */
#else  /* PDF_CJKFONTWIDTHS_SUPPORTED */
        0,
        NULL,
#endif /* !PDF_CJKFONTWIDTHS_SUPPORTED */

        0,                              /* numOfGlyphs */
        (pdc_glyphwidth *) NULL,        /* glw */

},

/* ---------------------------------------------------------- */
{	"HYGoThic-Medium",		/* FontName */
	6L,				/* Font flags */
        pdc_CIDFontType0,               /* font type */
	cc_korean,			/* Character collection */
	(float) 0.0,			/* ItalicAngle */
	pdc_true,			/* isFixedPitch */
	-6,				/* llx */
	-145,				/* lly */
	1003,				/* urx */
	880,				/* ury */
	-100,				/* UnderlinePosition */
	50,				/* UnderlineThickness */
	737,				/* CapHeight */
	553,				/* xHeight */
	752,				/* Ascender */
	-271,				/* Descender */
	58,				/* StdVW */
	0,				/* StdHW */

#ifdef PDF_CJKFONTWIDTHS_SUPPORTED
        68,                             /* numOfInter */
        pdf_HYGoThic_Medium_widths,     /* ciw */
#else  /* PDF_CJKFONTWIDTHS_SUPPORTED */
        0,
        NULL,
#endif /* !PDF_CJKFONTWIDTHS_SUPPORTED */

        0,                              /* numOfGlyphs */
        (pdc_glyphwidth *) NULL,        /* glw */

},

/* ---------------------------------------------------------- */
{	"HYSMyeongJo-Medium",		/* FontName */
	6L,				/* Font flags */
        pdc_CIDFontType0,               /* font type */
	cc_korean,			/* Character collection */
	(float) 0.0,			/* ItalicAngle */
	pdc_true,			/* isFixedPitch */
	-0,				/* llx */
	-148,				/* lly */
	1001,				/* urx */
	880,				/* ury */
	-100,				/* UnderlinePosition */
	50,				/* UnderlineThickness */
	737,				/* CapHeight */
	553,				/* xHeight */
	752,				/* Ascender */
	-271,				/* Descender */
	58,				/* StdVW */
	0,				/* StdHW */

#ifdef PDF_CJKFONTWIDTHS_SUPPORTED
        67,                             /* numOfInter */
        pdf_HYSMyeongJo_Medium_widths,  /* ciw */
#else  /* PDF_CJKFONTWIDTHS_SUPPORTED */
        0,
        NULL,
#endif /* !PDF_CJKFONTWIDTHS_SUPPORTED */

        0,                              /* numOfGlyphs */
        (pdc_glyphwidth *) NULL,        /* glw */

},

/* ---------------------------------------------------------- */
{	"MHei-Medium",		/* FontName */
	6L,				/* Font flags */
        pdc_CIDFontType0,               /* font type */
	cc_traditional_chinese,		/* Character collection */
	(float) 0.0,			/* ItalicAngle */
	pdc_true,			/* isFixedPitch */
	-45,				/* llx */
	-250,				/* lly */
	1015,				/* urx */
	887,				/* ury */
	-100,				/* UnderlinePosition */
	50,				/* UnderlineThickness */
	737,				/* CapHeight */
	553,				/* xHeight */
	752,				/* Ascender */
	-271,				/* Descender */
	58,				/* StdVW */
	0,				/* StdHW */

#ifdef PDF_CJKFONTWIDTHS_SUPPORTED
        67,                             /* numOfInter */
        pdf_HYSMyeongJo_Medium_widths,  /* ciw */
#else  /* PDF_CJKFONTWIDTHS_SUPPORTED */
        0,
        NULL,
#endif /* !PDF_CJKFONTWIDTHS_SUPPORTED */

        0,                              /* numOfGlyphs */
        (pdc_glyphwidth *) NULL,        /* glw */

},

/* ---------------------------------------------------------- */
{	"MSung-Light",			/* FontName */
	6L,				/* Font flags */
        pdc_CIDFontType0,               /* font type */
	cc_traditional_chinese,		/* Character collection */
	(float) 0.0,			/* ItalicAngle */
	pdc_true,			/* isFixedPitch */
	-160,				/* llx */
	-259,				/* lly */
	1015,				/* urx */
	888,				/* ury */
	-100,				/* UnderlinePosition */
	50,				/* UnderlineThickness */
	737,				/* CapHeight */
	553,				/* xHeight */
	752,				/* Ascender */
	-271,				/* Descender */
	58,				/* StdVW */
	0,				/* StdHW */

#ifdef PDF_CJKFONTWIDTHS_SUPPORTED
        80,                             /* numOfInter */
        pdf_MSung_Light_widths,         /* ciw */
#else  /* PDF_CJKFONTWIDTHS_SUPPORTED */
        0,
        NULL,
#endif /* !PDF_CJKFONTWIDTHS_SUPPORTED */

        0,                              /* numOfGlyphs */
        (pdc_glyphwidth *) NULL,        /* glw */

},

/* ---------------------------------------------------------- */
{	"STSong-Light",			/* FontName */
	4L,				/* Font flags */
        pdc_CIDFontType0,               /* font type */
	cc_simplified_chinese,		/* Character collection */
	(float) 0.0,			/* ItalicAngle */
	pdc_true,			/* isFixedPitch */
	-250,				/* llx */
	-143,				/* lly */
	600,				/* urx */
	857,				/* ury */
	-100,				/* UnderlinePosition */
	50,				/* UnderlineThickness */
	857,				/* CapHeight */
	599,				/* xHeight */
	857,				/* Ascender */
	-143,				/* Descender */
	91,				/* StdVW */
	91,				/* StdHW */

#ifdef PDF_CJKFONTWIDTHS_SUPPORTED
        83,                             /* numOfInter */
        pdf_STSong_Light_widths,        /* ciw */
#else  /* PDF_CJKFONTWIDTHS_SUPPORTED */
        0,
        NULL,
#endif /* !PDF_CJKFONTWIDTHS_SUPPORTED */

        0,                              /* numOfGlyphs */
        (pdc_glyphwidth *) NULL,        /* glw */

},

/* Acrobat 5 standard fonts */
/* ---------------------------------------------------------- */
{	"HYSMyeongJoStd-Medium-Acro",	/* FontName */
	6L,				/* Font flags */
        pdc_CIDFontType0,               /* font type */
	cc_korean,			/* Character collection */
	(float) 0.0,			/* ItalicAngle */
	pdc_true,			/* isFixedPitch */
	-28,				/* llx */
	-148,				/* lly */
	1001,				/* urx */
	880,				/* ury */
	-100,				/* UnderlinePosition */
	50,				/* UnderlineThickness */
	737,				/* CapHeight */
	553,				/* xHeight */
	752,				/* Ascender */
	-271,				/* Descender */
	58,				/* StdVW */
	0,				/* StdHW */

#ifdef PDF_CJKFONTWIDTHS_SUPPORTED
        69,                               /* numOfInter */
        pdf_HYSMyeongJoStd_Medium_widths, /* ciw */
#else  /* PDF_CJKFONTWIDTHS_SUPPORTED */
        0,
        NULL,
#endif /* !PDF_CJKFONTWIDTHS_SUPPORTED */

        0,                              /* numOfGlyphs */
        (pdc_glyphwidth *) NULL,        /* glw */

},

/* ---------------------------------------------------------- */
{	"KozMinPro-Regular-Acro",	/* FontName */
	6L,				/* Font flags */
        pdc_CIDFontType0,               /* font type */
	cc_japanese,			/* Character collection */
	(float) 0.0,			/* ItalicAngle */
	pdc_true,			/* isFixedPitch */
	-195,				/* llx */
	-272,				/* lly */
	1110,				/* urx */
	1075,				/* ury */
	-100,				/* UnderlinePosition */
	50,				/* UnderlineThickness */
	737,				/* CapHeight */
	553,				/* xHeight */
	752,				/* Ascender */
	-271,				/* Descender */
	58,				/* StdVW */
	0,				/* StdHW */

#ifdef PDF_CJKFONTWIDTHS_SUPPORTED
        265,                            /* numOfInter */
        pdf_KozMinPro_Regular_widths,   /* ciw */
#else  /* PDF_CJKFONTWIDTHS_SUPPORTED */
        0,
        NULL,
#endif /* !PDF_CJKFONTWIDTHS_SUPPORTED */

        0,                              /* numOfGlyphs */
        (pdc_glyphwidth *) NULL,        /* glw */

},

/* ---------------------------------------------------------- */
{	"MSungStd-Light-Acro",		/* FontName */
	6L,				/* Font flags */
        pdc_CIDFontType0,               /* font type */
	cc_traditional_chinese,		/* Character collection */
	(float) 0.0,			/* ItalicAngle */
	pdc_true,			/* isFixedPitch */
	-160,				/* llx */
	-249,				/* lly */
	1015,				/* urx */
	1071,				/* ury */
	-100,				/* UnderlinePosition */
	50,				/* UnderlineThickness */
	737,				/* CapHeight */
	553,				/* xHeight */
	752,				/* Ascender */
	-271,				/* Descender */
	58,				/* StdVW */
	0,				/* StdHW */

#ifdef PDF_CJKFONTWIDTHS_SUPPORTED
        82,                             /* numOfInter */
        pdf_MSungStd_Light_widths,      /* ciw */
#else  /* PDF_CJKFONTWIDTHS_SUPPORTED */
        0,
        NULL,
#endif /* !PDF_CJKFONTWIDTHS_SUPPORTED */

        0,                              /* numOfGlyphs */
        (pdc_glyphwidth *) NULL,        /* glw */

},

/* ---------------------------------------------------------- */
{	"STSongStd-Light-Acro",		/* FontName */
	6L,				/* Font flags */
        pdc_CIDFontType0,               /* font type */
	cc_simplified_chinese,		/* Character collection */
	(float) 0.0,			/* ItalicAngle */
	pdc_true,			/* isFixedPitch */
	-134,				/* llx */
	-254,				/* lly */
	1001,				/* urx */
	905,				/* ury */
	-100,				/* UnderlinePosition */
	50,				/* UnderlineThickness */
	737,				/* CapHeight */
	535,				/* xHeight */
	752,				/* Ascender */
	-271,				/* Descender */
	58,				/* StdVW */
	0,				/* StdHW */

#ifdef PDF_CJKFONTWIDTHS_SUPPORTED
        89,                             /* numOfInter */
        pdf_STSongStd_Light_widths,     /* ciw */
#else  /* PDF_CJKFONTWIDTHS_SUPPORTED */
        0,
        NULL,
#endif /* !PDF_CJKFONTWIDTHS_SUPPORTED */

        0,                              /* numOfGlyphs */
        (pdc_glyphwidth *) NULL,        /* glw */

}

};

#define SIZEOF_CID_METRICS	\
        ((int) (sizeof(pdf_cid_metrics)/sizeof(pdc_core_metric)))
#define NUMBER_OF_CMAPS		((int) (sizeof(cmaps)/sizeof(pdf_cmap)))

#endif /* P_CID_H */
