
/*
 Copyright (c) 2007, Ralink Technology Corporation
 All rights reserved.

 Redistribution.  Redistribution and use in binary form, without
 modification, are permitted provided that the following conditions are
 met:

 	* Redistributions must reproduce the above copyright notice and the
 	following disclaimer in the documentation and/or other materials
 	provided with the distribution.
 	* Neither the name of Ralink Technology Corporation nor the names of its
 	suppliers may be used to endorse or promote products derived from this
 	software without specific prior written permission.
 	* No reverse engineering, decompilation, or disassembly of this software
 	is permitted.

 Limited patent license. Ralink Technology Corporation grants a world-wide,
 royalty-free, non-exclusive license under patents it now or hereafter
 owns or controls to make, have made, use, import, offer to sell and
 sell ("Utilize") this software, but solely to the extent that any
 such patent is necessary to Utilize the software alone, or in
 combination with an operating system licensed under an approved Open
 Source license as listed by the Open Source Initiative at
 http://opensource.org/licenses.  The patent license shall not apply to
 any other combinations which include this software.  No hardware per
 se is licensed hereunder.

 DISCLAIMER.  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
 BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 DAMAGE.
*/

#ifndef _RT2860_UCODE_H_
#define _RT2860_UCODE_H_

/*
 * RT2860 microcode v26
 */
static const uint8_t rt2860_ucode[] =
{
	0x02, 0x03, 0x5E, 0x02, 
	0x02, 0xB1, 0x22, 0x22, 
	0xFF, 0xFF, 0xFF, 0x02, 
	0x01, 0x82, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0x02, 
	0x00, 0x1E, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0x02, 
	0x01, 0x33, 0xC0, 0xE0, 
	0xC0, 0xF0, 0xC0, 0x83, 
	0xC0, 0x82, 0xC0, 0xD0, 
	0x75, 0xD0, 0x18, 0xC2, 
	0xAF, 0x30, 0x45, 0x03, 
	0x12, 0x10, 0x09, 0x90, 
	0x04, 0x16, 0xE0, 0x30, 
	0xE3, 0x03, 0x74, 0x08, 
	0xF0, 0x90, 0x04, 0x14, 
	0xE0, 0x20, 0xE7, 0x03, 
	0x02, 0x00, 0xCB, 0x74, 
	0x80, 0xF0, 0x90, 0x70, 
	0x12, 0xE0, 0xF5, 0x2F, 
	0x90, 0x04, 0x04, 0xE0, 
	0x24, 0xCF, 0x60, 0x30, 
	0x14, 0x60, 0x42, 0x24, 
	0xE2, 0x60, 0x47, 0x14, 
	0x60, 0x55, 0x24, 0x21, 
	0x70, 0x60, 0xE5, 0x55, 
	0x24, 0xFE, 0x60, 0x07, 
	0x14, 0x60, 0x08, 0x24, 
	0x02, 0x70, 0x08, 0x7D, 
	0x01, 0x80, 0x28, 0x7D, 
	0x02, 0x80, 0x24, 0x90, 
	0x70, 0x10, 0xE0, 0xF5, 
	0x50, 0x85, 0x2F, 0x40, 
	0xD2, 0x01, 0x80, 0x3E, 
	0xE5, 0x55, 0x64, 0x03, 
	0x60, 0x04, 0xE5, 0x55, 
	0x70, 0x04, 0x7D, 0x02, 
	0x80, 0x09, 0x85, 0x2F, 
	0x41, 0xD2, 0x02, 0x80, 
	0x29, 0xAD, 0x55, 0xAF, 
	0x2F, 0x12, 0x02, 0x8D, 
	0x80, 0x20, 0x90, 0x70, 
	0x10, 0xE0, 0xF5, 0x47, 
	0x90, 0x70, 0x11, 0xE0, 
	0xF5, 0x44, 0x12, 0x10, 
	0x25, 0x80, 0x06, 0x90, 
	0x70, 0x10, 0xE0, 0xF5, 
	0x45, 0xE4, 0xFD, 0xAF, 
	0x2F, 0x12, 0x02, 0x8D, 
	0xD2, 0x04, 0x90, 0x70, 
	0x13, 0xE4, 0xF0, 0xD2, 
	0xAF, 0xD0, 0xD0, 0xD0, 
	0x82, 0xD0, 0x83, 0xD0, 
	0xF0, 0xD0, 0xE0, 0x32, 
	0x90, 0x70, 0x2A, 0xE0, 
	0x30, 0xE1, 0x53, 0xC2, 
	0xAF, 0x90, 0x70, 0x28, 
	0xE0, 0x90, 0x10, 0x1C, 
	0xF0, 0x90, 0x70, 0x29, 
	0xE0, 0x90, 0x10, 0x1D, 
	0xF0, 0x90, 0x70, 0x2A, 
	0xE0, 0x90, 0x10, 0x1E, 
	0xF0, 0x90, 0x10, 0x1C, 
	0xE0, 0xF5, 0x30, 0x90, 
	0x10, 0x1E, 0xE0, 0x20, 
	0xE1, 0xF3, 0x90, 0x10, 
	0x1C, 0xE0, 0x90, 0x70, 
	0x28, 0xF0, 0x90, 0x10, 
	0x1D, 0xE0, 0x90, 0x70, 
	0x29, 0xF0, 0x90, 0x10, 
	0x1E, 0xE0, 0x90, 0x70, 
	0x2A, 0xF0, 0x30, 0x4A, 
	0x0D, 0x90, 0x70, 0x24, 
	0xE0, 0x44, 0x01, 0xF0, 
	0x90, 0x02, 0x2C, 0x74, 
	0xFF, 0xF0, 0xC2, 0x05, 
	0xD2, 0xAF, 0x22, 0xC0, 
	0xE0, 0xC0, 0xF0, 0xC0, 
	0x83, 0xC0, 0x82, 0xC0, 
	0xD0, 0xE8, 0xC0, 0xE0, 
	0xE9, 0xC0, 0xE0, 0xEA, 
	0xC0, 0xE0, 0xEB, 0xC0, 
	0xE0, 0xEC, 0xC0, 0xE0, 
	0xED, 0xC0, 0xE0, 0xEE, 
	0xC0, 0xE0, 0xEF, 0xC0, 
	0xE0, 0xC2, 0xAF, 0x30, 
	0x45, 0x03, 0x12, 0x10, 
	0x12, 0xD2, 0xAF, 0xD0, 
	0xE0, 0xFF, 0xD0, 0xE0, 
	0xFE, 0xD0, 0xE0, 0xFD, 
	0xD0, 0xE0, 0xFC, 0xD0, 
	0xE0, 0xFB, 0xD0, 0xE0, 
	0xFA, 0xD0, 0xE0, 0xF9, 
	0xD0, 0xE0, 0xF8, 0xD0, 
	0xD0, 0xD0, 0x82, 0xD0, 
	0x83, 0xD0, 0xF0, 0xD0, 
	0xE0, 0x32, 0xC0, 0xE0, 
	0xC0, 0xF0, 0xC0, 0x83, 
	0xC0, 0x82, 0xC0, 0xD0, 
	0x75, 0xD0, 0x10, 0xC2, 
	0xAF, 0x30, 0x45, 0x03, 
	0x12, 0x10, 0x0C, 0x30, 
	0x58, 0x0A, 0xE5, 0x54, 
	0x60, 0x04, 0x15, 0x54, 
	0x80, 0x02, 0xC2, 0x58, 
	0x30, 0x59, 0x0A, 0xE5, 
	0x50, 0x60, 0x04, 0x15, 
	0x50, 0x80, 0x02, 0xC2, 
	0x59, 0xD5, 0x53, 0x07, 
	0x30, 0x60, 0x04, 0x15, 
	0x46, 0xD2, 0x04, 0x30, 
	0x45, 0x03, 0x12, 0x10, 
	0x0F, 0xC2, 0x8D, 0xD2, 
	0xAF, 0xD0, 0xD0, 0xD0, 
	0x82, 0xD0, 0x83, 0xD0, 
	0xF0, 0xD0, 0xE0, 0x32, 
	0x12, 0x02, 0xD3, 0x30, 
	0x45, 0x03, 0x12, 0x10, 
	0x03, 0x30, 0x01, 0x06, 
	0x20, 0x09, 0x03, 0x12, 
	0x10, 0x1C, 0x30, 0x02, 
	0x06, 0x20, 0x0A, 0x03, 
	0x12, 0x10, 0x1F, 0x30, 
	0x03, 0x06, 0x20, 0x0B, 
	0x03, 0x12, 0x10, 0x1F, 
	0x30, 0x04, 0x06, 0x20, 
	0x0C, 0x03, 0x12, 0x10, 
	0x22, 0x20, 0x13, 0x09, 
	0x20, 0x11, 0x06, 0xE5, 
	0x2B, 0x45, 0x2C, 0x60, 
	0x03, 0xD3, 0x80, 0x01, 
	0xC3, 0x92, 0xA9, 0x12, 
	0x02, 0xEC, 0x80, 0xBF, 
	0xC2, 0x43, 0xD2, 0x45, 
	0xE4, 0xF5, 0x20, 0xF5, 
	0x21, 0xF5, 0x53, 0xF5, 
	0x46, 0xF5, 0x2B, 0xF5, 
	0x2C, 0xC2, 0x42, 0xF5, 
	0x51, 0xF5, 0x52, 0xF5, 
	0x55, 0x90, 0x04, 0x18, 
	0x74, 0x80, 0xF0, 0x90, 
	0x04, 0x1A, 0x74, 0x08, 
	0xF0, 0xC2, 0x19, 0xC2, 
	0x18, 0xC2, 0x1A, 0x22, 
	0xC8, 0xEF, 0xC8, 0xE6, 
	0xFA, 0x08, 0xE6, 0x4A, 
	0x60, 0x0C, 0xC8, 0xEF, 
	0xC8, 0x08, 0xE6, 0x16, 
	0x18, 0x70, 0x01, 0x16, 
	0xC3, 0x22, 0xED, 0x24, 
	0xFF, 0xFD, 0xEC, 0x34, 
	0xFF, 0xC8, 0xEF, 0xC8, 
	0xF6, 0x08, 0xC6, 0xED, 
	0xC6, 0xD3, 0x22, 0xD0, 
	0x83, 0xD0, 0x82, 0xF8, 
	0xE4, 0x93, 0x70, 0x12, 
	0x74, 0x01, 0x93, 0x70, 
	0x0D, 0xA3, 0xA3, 0x93, 
	0xF8, 0x74, 0x01, 0x93, 
	0xF5, 0x82, 0x88, 0x83, 
	0xE4, 0x73, 0x74, 0x02, 
	0x93, 0x68, 0x60, 0xEF, 
	0xA3, 0xA3, 0xA3, 0x80, 
	0xDF, 0xEF, 0xF4, 0x60, 
	0x1F, 0xE4, 0xFE, 0x12, 
	0x03, 0x6A, 0xE0, 0xB4, 
	0xFF, 0x12, 0x12, 0x03, 
	0x6A, 0xEF, 0xF0, 0x74, 
	0x1C, 0x2E, 0xF5, 0x82, 
	0xE4, 0x34, 0x70, 0xF5, 
	0x83, 0xED, 0xF0, 0x22, 
	0x0E, 0xBE, 0x04, 0xE3, 
	0x22, 0xC0, 0xE0, 0xC0, 
	0xF0, 0xC0, 0x83, 0xC0, 
	0x82, 0xC0, 0xD0, 0x75, 
	0xD0, 0x08, 0xC2, 0xAF, 
	0x30, 0x45, 0x03, 0x12, 
	0x10, 0x06, 0xD2, 0xAF, 
	0xD0, 0xD0, 0xD0, 0x82, 
	0xD0, 0x83, 0xD0, 0xF0, 
	0xD0, 0xE0, 0x32, 0xC2, 
	0xAF, 0x12, 0x00, 0x06, 
	0x12, 0x02, 0x14, 0x12, 
	0x03, 0x1C, 0xE4, 0xF5, 
	0x22, 0xF5, 0x47, 0x90, 
	0x04, 0x00, 0x74, 0x80, 
	0xF0, 0xD2, 0xAF, 0x22, 
	0x30, 0x45, 0x03, 0x12, 
	0x10, 0x15, 0xE5, 0x20, 
	0x70, 0x03, 0x20, 0x10, 
	0x03, 0x30, 0x11, 0x03, 
	0x43, 0x87, 0x01, 0x22, 
	0xC0, 0x2A, 0x74, 0x03, 
	0xC0, 0xE0, 0xC0, 0x82, 
	0xC0, 0x83, 0x75, 0x2A, 
	0x0A, 0x22, 0xC0, 0x2A, 
	0x74, 0x03, 0xC0, 0xE0, 
	0xC0, 0x82, 0xC0, 0x83, 
	0x75, 0x2A, 0x18, 0x22, 
	0x75, 0x89, 0x02, 0xE4, 
	0xF5, 0x8C, 0xF5, 0x8A, 
	0xF5, 0x88, 0xF5, 0xB8, 
	0xF5, 0xE8, 0x75, 0x90, 
	0x18, 0xD2, 0x8C, 0x75, 
	0xA8, 0x05, 0x22, 0xCE, 
	0xEF, 0xCE, 0xEE, 0x60, 
	0x08, 0x7F, 0xFF, 0x12, 
	0x03, 0x80, 0x1E, 0x80, 
	0xF5, 0x22, 0xC8, 0xEF, 
	0xC8, 0xE6, 0x60, 0x03, 
	0x16, 0xC3, 0x22, 0xED, 
	0x14, 0xF6, 0xD3, 0x22, 
	0xC8, 0xEF, 0xC8, 0xE6, 
	0x60, 0x06, 0x16, 0xE6, 
	0x24, 0xFF, 0xB3, 0x22, 
	0xC3, 0x22, 0x78, 0x7F, 
	0xE4, 0xF6, 0xD8, 0xFD, 
	0x75, 0x81, 0x5F, 0x02, 
	0x01, 0xD0, 0x74, 0x14, 
	0x2E, 0xF5, 0x82, 0xE4, 
	0x34, 0x70, 0xF5, 0x83, 
	0x22, 0xEF, 0x90, 0x03, 
	0x7E, 0x93, 0x90, 0x03, 
	0x00, 0x73, 0x0A, 0x18, 
	0xEF, 0x60, 0x03, 0x1F, 
	0x80, 0xFA, 0x22, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0x02, 
	0x10, 0x28, 0x02, 0x10, 
	0x3B, 0x02, 0x10, 0x3C, 
	0x02, 0x12, 0xB8, 0x02, 
	0x12, 0xB9, 0x02, 0x13, 
	0x3E, 0x02, 0x13, 0x3F, 
	0xC3, 0x22, 0xFF, 0xFF, 
	0x02, 0x16, 0x56, 0x02, 
	0x17, 0x6B, 0x02, 0x14, 
	0x2A, 0x02, 0x13, 0x40, 
	0x30, 0x05, 0x06, 0x20, 
	0x0D, 0x03, 0x12, 0x00, 
	0xD8, 0x30, 0x06, 0x06, 
	0x20, 0x0E, 0x03, 0x12, 
	0x18, 0x5E, 0x22, 0x22, 
	0x90, 0x04, 0x14, 0xE0, 
	0x20, 0xE7, 0x03, 0x02, 
	0x12, 0xB7, 0x90, 0x70, 
	0x12, 0xE0, 0xF5, 0x56, 
	0x90, 0x04, 0x04, 0xE0, 
	0x12, 0x02, 0x67, 0x11, 
	0x4E, 0x30, 0x11, 0x25, 
	0x31, 0x10, 0x87, 0x33, 
	0x10, 0xAA, 0x34, 0x10, 
	0xC3, 0x35, 0x11, 0x57, 
	0x50, 0x11, 0x7B, 0x51, 
	0x11, 0x84, 0x52, 0x11, 
	0x84, 0x53, 0x11, 0x84, 
	0x54, 0x11, 0xC5, 0x55, 
	0x11, 0xDC, 0x70, 0x12, 
	0x07, 0x71, 0x12, 0x34, 
	0x72, 0x12, 0x5E, 0x80, 
	0x12, 0x81, 0x83, 0x00, 
	0x00, 0x12, 0xB7, 0x75, 
	0x24, 0x05, 0x75, 0x25, 
	0xDC, 0x90, 0x70, 0x9F, 
	0x74, 0x12, 0xF0, 0xD2, 
	0x18, 0xD2, 0x61, 0x75, 
	0x35, 0x0D, 0xE4, 0x90, 
	0x70, 0x13, 0xF0, 0xE5, 
	0x56, 0xF4, 0x70, 0x03, 
	0x02, 0x12, 0xB7, 0x02, 
	0x12, 0xAA, 0xC2, 0x18, 
	0x90, 0x01, 0x14, 0xE0, 
	0x54, 0xFD, 0xF0, 0xE4, 
	0x90, 0x70, 0x13, 0xF0, 
	0xE5, 0x56, 0xF4, 0x70, 
	0x03, 0x02, 0x12, 0xB7, 
	0x02, 0x12, 0xAA, 0xE5, 
	0x55, 0x64, 0x02, 0x70, 
	0x37, 0x90, 0x70, 0x10, 
	0xE0, 0x60, 0x08, 0x90, 
	0x01, 0x0D, 0x74, 0x09, 
	0xF0, 0x80, 0x25, 0xE5, 
	0x34, 0x14, 0x60, 0x0A, 
	0x14, 0x60, 0x0F, 0x14, 
	0x60, 0x14, 0x24, 0x03, 
	0x70, 0x16, 0x90, 0x01, 
	0x0D, 0x74, 0x08, 0xF0, 
	0x80, 0x0E, 0x90, 0x01, 
	0x0D, 0x74, 0x0B, 0xF0, 
	0x80, 0x06, 0x90, 0x01, 
	0x0D, 0x74, 0x1B, 0xF0, 
	0x7D, 0x01, 0x80, 0x02, 
	0x7D, 0x02, 0xAF, 0x56, 
	0x12, 0x02, 0x8D, 0x90, 
	0x70, 0x11, 0xE0, 0x24, 
	0xFF, 0x92, 0x1B, 0x90, 
	0x04, 0x14, 0x74, 0x80, 
	0xF0, 0xE4, 0x90, 0x70, 
	0x13, 0xF0, 0xE5, 0x56, 
	0xF4, 0x70, 0x03, 0x02, 
	0x12, 0xB7, 0x02, 0x12, 
	0xAA, 0x20, 0x02, 0x03, 
	0x30, 0x03, 0x1D, 0x7D, 
	0x02, 0xAF, 0x56, 0x12, 
	0x02, 0x8D, 0x90, 0x04, 
	0x14, 0x74, 0x80, 0xF0, 
	0xE4, 0x90, 0x70, 0x13, 
	0xF0, 0xE5, 0x56, 0xF4, 
	0x70, 0x03, 0x02, 0x12, 
	0xB7, 0x02, 0x12, 0xAA, 
	0x85, 0x56, 0x41, 0xD2, 
	0x02, 0x22, 0x90, 0x70, 
	0x11, 0xE0, 0x24, 0xFF, 
	0x92, 0x1B, 0x22, 0x90, 
	0x70, 0x10, 0xE0, 0x54, 
	0x7F, 0x64, 0x02, 0x60, 
	0x03, 0x02, 0x12, 0xB7, 
	0x90, 0x70, 0x11, 0xE0, 
	0x64, 0x08, 0x60, 0x08, 
	0xE0, 0x64, 0x20, 0x60, 
	0x03, 0x02, 0x12, 0xB7, 
	0x75, 0x4E, 0x03, 0x75, 
	0x4F, 0x20, 0x22, 0x90, 
	0x70, 0x11, 0xE0, 0x24, 
	0xFF, 0x92, 0x47, 0x22, 
	0x90, 0x04, 0x04, 0xE0, 
	0x25, 0xE0, 0x24, 0x5D, 
	0xF5, 0x57, 0x90, 0x70, 
	0x10, 0xE0, 0xFF, 0x74, 
	0x47, 0x25, 0x57, 0xF8, 
	0xC6, 0xEF, 0xC6, 0x90, 
	0x70, 0x11, 0xE0, 0xFF, 
	0x74, 0x48, 0x25, 0x57, 
	0xF8, 0xC6, 0xEF, 0xC6, 
	0xE4, 0xFD, 0xAF, 0x56, 
	0x12, 0x02, 0x8D, 0x90, 
	0x04, 0x14, 0x74, 0x80, 
	0xF0, 0xE4, 0x90, 0x70, 
	0x13, 0xF0, 0xE5, 0x56, 
	0xF4, 0x70, 0x03, 0x02, 
	0x12, 0xB7, 0x02, 0x12, 
	0xAA, 0xE5, 0x47, 0xB4, 
	0x07, 0x08, 0x90, 0x70, 
	0x11, 0xE0, 0x54, 0x07, 
	0xF5, 0x26, 0xE4, 0xFD, 
	0xAF, 0x56, 0x12, 0x02, 
	0x8D, 0xD2, 0x04, 0x22, 
	0x90, 0x70, 0x10, 0xE0, 
	0xFE, 0x90, 0x70, 0x11, 
	0xE0, 0xFD, 0xED, 0xF8, 
	0xE6, 0xF5, 0x57, 0xFD, 
	0xAF, 0x56, 0x12, 0x02, 
	0x8D, 0x90, 0x04, 0x14, 
	0x74, 0x80, 0xF0, 0xE4, 
	0x90, 0x70, 0x13, 0xF0, 
	0xE5, 0x56, 0xF4, 0x70, 
	0x03, 0x02, 0x12, 0xB7, 
	0x02, 0x12, 0xAA, 0x90, 
	0x70, 0x10, 0xE0, 0xFE, 
	0x90, 0x70, 0x11, 0xE0, 
	0xFD, 0xED, 0xF5, 0x82, 
	0x8E, 0x83, 0xE0, 0xF5, 
	0x57, 0xFD, 0xAF, 0x56, 
	0x12, 0x02, 0x8D, 0x90, 
	0x04, 0x14, 0x74, 0x80, 
	0xF0, 0xE4, 0x90, 0x70, 
	0x13, 0xF0, 0xE5, 0x56, 
	0xF4, 0x70, 0x03, 0x02, 
	0x12, 0xB7, 0x80, 0x76, 
	0xE4, 0xF5, 0x4E, 0xF5, 
	0x4F, 0x75, 0x26, 0xFF, 
	0xC2, 0x19, 0xC2, 0x18, 
	0xC2, 0x1A, 0x75, 0x34, 
	0xFF, 0xAD, 0x57, 0xAF, 
	0x56, 0x12, 0x02, 0x8D, 
	0x90, 0x04, 0x14, 0x74, 
	0x80, 0xF0, 0xE4, 0x90, 
	0x70, 0x13, 0xF0, 0xE5, 
	0x56, 0xF4, 0x60, 0x5B, 
	0x80, 0x4C, 0x90, 0x70, 
	0x10, 0xE0, 0x24, 0xFF, 
	0x92, 0x4A, 0xD2, 0x05, 
	0xAD, 0x57, 0xAF, 0x56, 
	0x12, 0x02, 0x8D, 0x90, 
	0x04, 0x14, 0x74, 0x80, 
	0xF0, 0xE4, 0x90, 0x70, 
	0x13, 0xF0, 0xE5, 0x56, 
	0xF4, 0x60, 0x38, 0x80, 
	0x29, 0x90, 0x70, 0x10, 
	0xE0, 0xF5, 0x34, 0xD3, 
	0x94, 0x00, 0x40, 0x07, 
	0x90, 0x01, 0x0D, 0xE0, 
	0x54, 0xFB, 0xF0, 0xAD, 
	0x57, 0xAF, 0x56, 0x12, 
	0x02, 0x8D, 0x90, 0x04, 
	0x14, 0x74, 0x80, 0xF0, 
	0xE4, 0x90, 0x70, 0x13, 
	0xF0, 0xE5, 0x56, 0xF4, 
	0x60, 0x0D, 0x90, 0x70, 
	0x25, 0xE0, 0x44, 0x01, 
	0xF0, 0x90, 0x02, 0x2C, 
	0x74, 0xFF, 0xF0, 0x22, 
	0x22, 0xE5, 0x53, 0x60, 
	0x03, 0x02, 0x13, 0x3D, 
	0xE5, 0x4F, 0x45, 0x4E, 
	0x60, 0x08, 0xE5, 0x4F, 
	0x15, 0x4F, 0x70, 0x02, 
	0x15, 0x4E, 0xA2, 0x19, 
	0xE4, 0x33, 0x90, 0x70, 
	0x90, 0xF0, 0xA2, 0x18, 
	0xE4, 0x33, 0xA3, 0xF0, 
	0x30, 0x19, 0x4D, 0x90, 
	0x70, 0x98, 0x74, 0x23, 
	0xF0, 0xA3, 0xE5, 0x25, 
	0xF0, 0xE5, 0x24, 0xA3, 
	0xF0, 0x7F, 0x35, 0x7D, 
	0x32, 0x12, 0x03, 0x42, 
	0x50, 0x09, 0x90, 0x10, 
	0x04, 0xE0, 0x54, 0xF7, 
	0xF0, 0xD2, 0x06, 0xE5, 
	0x35, 0xD3, 0x94, 0x10, 
	0x40, 0x1E, 0x30, 0x1A, 
	0x1B, 0xC2, 0x1A, 0xA2, 
	0x18, 0x92, 0x19, 0x20, 
	0x19, 0x12, 0x90, 0x04, 
	0x09, 0xE0, 0x54, 0xDD, 
	0xF0, 0x90, 0x10, 0x04, 
	0xE0, 0x44, 0x08, 0xF0, 
	0xC2, 0x61, 0xD2, 0x03, 
	0xE5, 0x35, 0xB4, 0x0B, 
	0x14, 0xD2, 0x03, 0x22, 
	0xE4, 0xF5, 0x35, 0xA2, 
	0x18, 0x92, 0x19, 0x30, 
	0x19, 0x07, 0x90, 0x04, 
	0x09, 0xE0, 0x44, 0x22, 
	0xF0, 0x22, 0x22, 0x22, 
	0xC2, 0x4B, 0xC2, 0x4C, 
	0xE5, 0x44, 0x12, 0x02, 
	0x67, 0x13, 0x62, 0x00, 
	0x13, 0xF5, 0x04, 0x13, 
	0xF1, 0x08, 0x13, 0xCC, 
	0x10, 0x13, 0x76, 0x20, 
	0x13, 0x96, 0x60, 0x13, 
	0xA7, 0xA0, 0x00, 0x00, 
	0x13, 0xF7, 0x85, 0x48, 
	0x43, 0x85, 0x4A, 0x42, 
	0x85, 0x4C, 0x5E, 0xE5, 
	0x47, 0x64, 0x06, 0x60, 
	0x03, 0x02, 0x13, 0xF7, 
	0x80, 0x1B, 0xE5, 0x48, 
	0xC4, 0x54, 0x0F, 0xF5, 
	0x43, 0xE5, 0x4A, 0xC4, 
	0x54, 0x0F, 0xF5, 0x42, 
	0xE5, 0x4C, 0xC4, 0x54, 
	0x0F, 0xF5, 0x5E, 0xE5, 
	0x47, 0x64, 0x06, 0x70, 
	0x66, 0x53, 0x43, 0x0F, 
	0x80, 0x61, 0x85, 0x49, 
	0x43, 0x85, 0x4B, 0x42, 
	0x85, 0x4D, 0x5E, 0xE5, 
	0x47, 0x64, 0x06, 0x70, 
	0x52, 0x80, 0x1B, 0xE5, 
	0x49, 0xC4, 0x54, 0x0F, 
	0xF5, 0x43, 0xE5, 0x4B, 
	0xC4, 0x54, 0x0F, 0xF5, 
	0x42, 0xE5, 0x4D, 0xC4, 
	0x54, 0x0F, 0xF5, 0x5E, 
	0xE5, 0x47, 0x64, 0x06, 
	0x70, 0x35, 0xE5, 0x43, 
	0x54, 0x0F, 0x44, 0x10, 
	0xF5, 0x43, 0x80, 0x2B, 
	0xE5, 0x47, 0xB4, 0x04, 
	0x06, 0x53, 0x5E, 0xFB, 
	0x75, 0x42, 0x09, 0xE5, 
	0x47, 0xB4, 0x05, 0x06, 
	0x43, 0x5E, 0x04, 0x75, 
	0x42, 0x09, 0xE5, 0x47, 
	0xB4, 0x06, 0x10, 0xE5, 
	0x43, 0x54, 0x0F, 0x44, 
	0x30, 0xF5, 0x43, 0x80, 
	0x06, 0xD2, 0x4B, 0x80, 
	0x02, 0xD2, 0x4C, 0xE4, 
	0xF5, 0x38, 0xE5, 0x42, 
	0xC4, 0x54, 0xF0, 0xFF, 
	0xE5, 0x43, 0x54, 0x0F, 
	0x4F, 0xF5, 0x5F, 0x90, 
	0x70, 0x44, 0xF0, 0xA3, 
	0xE5, 0x5E, 0xF0, 0xA3, 
	0xE5, 0x4A, 0xF0, 0xA3, 
	0xE5, 0x48, 0xF0, 0xA3, 
	0xE5, 0x4C, 0xF0, 0xA3, 
	0xE5, 0x44, 0xF0, 0xA3, 
	0xE5, 0x42, 0xF0, 0xA3, 
	0xE5, 0x43, 0xF0, 0xD2, 
	0x60, 0x22, 0xE5, 0x47, 
	0x60, 0x10, 0x24, 0xC0, 
	0x70, 0x03, 0x12, 0x16, 
	0x36, 0x12, 0x14, 0x3F, 
	0xC2, 0xAF, 0xC2, 0x04, 
	0xD2, 0xAF, 0x22, 0xC2, 
	0xAF, 0x90, 0x04, 0x14, 
	0xE0, 0x54, 0x0E, 0x60, 
	0x04, 0xD2, 0x1C, 0x80, 
	0x08, 0xE5, 0x4E, 0x45, 
	0x4F, 0x24, 0xFF, 0x92, 
	0x1C, 0xD2, 0xAF, 0x90, 
	0x04, 0x14, 0xE0, 0xA2, 
	0xE4, 0x92, 0x1D, 0x74, 
	0x1E, 0xF0, 0xE5, 0x5F, 
	0x54, 0x0F, 0xF5, 0x2D, 
	0xE5, 0x38, 0x70, 0x13, 
	0x30, 0x1C, 0x05, 0xE5, 
	0x5F, 0x20, 0xE5, 0x0B, 
	0x30, 0x1D, 0x19, 0xE5, 
	0x5F, 0x54, 0x30, 0xFF, 
	0xBF, 0x30, 0x11, 0xE5, 
	0x38, 0x70, 0x05, 0x75, 
	0x38, 0x0C, 0x80, 0x02, 
	0x15, 0x38, 0xD2, 0x6C, 
	0xD2, 0x6D, 0x80, 0x0F, 
	0xE5, 0x5F, 0x30, 0xE6, 
	0x06, 0xC2, 0x6C, 0xD2, 
	0x6D, 0x80, 0x04, 0xD2, 
	0x6C, 0xC2, 0x6D, 0xE5, 
	0x47, 0x64, 0x03, 0x70, 
	0x21, 0x30, 0x4B, 0x06, 
	0xC2, 0x6C, 0xD2, 0x6D, 
	0x80, 0x18, 0xE5, 0x38, 
	0x70, 0x03, 0x30, 0x4C, 
	0x11, 0xC2, 0x4C, 0xE5, 
	0x38, 0x70, 0x05, 0x75, 
	0x38, 0x07, 0x80, 0x02, 
	0x15, 0x38, 0xD2, 0x6C, 
	0xD2, 0x6D, 0x90, 0x70, 
	0x46, 0xE5, 0x2D, 0xF0, 
	0x20, 0x69, 0x07, 0xE5, 
	0x5E, 0x20, 0xE0, 0x02, 
	0xB2, 0x68, 0x20, 0x6B, 
	0x07, 0xE5, 0x5E, 0x20, 
	0xE1, 0x02, 0xB2, 0x6A, 
	0x20, 0x6D, 0x07, 0xE5, 
	0x5E, 0x20, 0xE2, 0x02, 
	0xB2, 0x6C, 0x90, 0x70, 
	0x47, 0xE5, 0x2D, 0xF0, 
	0x75, 0x2E, 0x40, 0x20, 
	0x69, 0x04, 0xA2, 0x68, 
	0x80, 0x15, 0x30, 0x68, 
	0x06, 0xE5, 0x46, 0xA2, 
	0xE3, 0x80, 0x0C, 0xE5, 
	0x46, 0x54, 0xF0, 0xFF, 
	0xBF, 0xF0, 0x03, 0xD3, 
	0x80, 0x01, 0xC3, 0x92, 
	0x73, 0x92, 0x72, 0x20, 
	0x6B, 0x04, 0xA2, 0x6A, 
	0x80, 0x15, 0x30, 0x6A, 
	0x06, 0xE5, 0x46, 0xA2, 
	0xE3, 0x80, 0x0C, 0xE5, 
	0x46, 0x54, 0xF0, 0xFF, 
	0xBF, 0xF0, 0x03, 0xD3, 
	0x80, 0x01, 0xC3, 0x92, 
	0x75, 0x92, 0x74, 0x20, 
	0x6D, 0x04, 0xA2, 0x6C, 
	0x80, 0x15, 0x30, 0x6C, 
	0x06, 0xE5, 0x46, 0xA2, 
	0xE3, 0x80, 0x0C, 0xE5, 
	0x46, 0x54, 0xF0, 0xFF, 
	0xBF, 0xF0, 0x03, 0xD3, 
	0x80, 0x01, 0xC3, 0x92, 
	0x71, 0x92, 0x70, 0x90, 
	0x10, 0x2F, 0xE5, 0x2E, 
	0xF0, 0xE5, 0x47, 0x64, 
	0x06, 0x70, 0x46, 0x90, 
	0x02, 0x29, 0xE0, 0x54, 
	0xFE, 0xF0, 0xE5, 0x43, 
	0xC4, 0x54, 0x0F, 0x14, 
	0x60, 0x14, 0x24, 0xFE, 
	0x60, 0x1F, 0x24, 0x03, 
	0x60, 0x03, 0x02, 0x16, 
	0x35, 0x90, 0x02, 0x28, 
	0xE0, 0x30, 0x47, 0x0D, 
	0x80, 0x07, 0x90, 0x02, 
	0x28, 0xE0, 0x20, 0x47, 
	0x04, 0x54, 0xFE, 0xF0, 
	0x22, 0x44, 0x01, 0xF0, 
	0x22, 0xE5, 0x46, 0x30, 
	0xE3, 0x04, 0x7F, 0x01, 
	0x80, 0x02, 0x7F, 0x00, 
	0x90, 0x02, 0x28, 0xE0, 
	0x54, 0xFE, 0x4F, 0xF0, 
	0x22, 0xE5, 0x47, 0x64, 
	0x07, 0x60, 0x03, 0x02, 
	0x16, 0x35, 0xF5, 0x27, 
	0x90, 0x02, 0x29, 0xE0, 
	0x54, 0xFC, 0xF0, 0xE5, 
	0x26, 0x14, 0x60, 0x26, 
	0x14, 0x60, 0x2E, 0x14, 
	0x60, 0x36, 0x24, 0x03, 
	0x70, 0x5F, 0xE5, 0x46, 
	0x13, 0x13, 0x13, 0x54, 
	0x1F, 0x75, 0xF0, 0x03, 
	0x84, 0xAF, 0xF0, 0x20, 
	0x47, 0x04, 0x7E, 0x01, 
	0x80, 0x02, 0x7E, 0x00, 
	0xEF, 0x6E, 0x24, 0xFF, 
	0x80, 0x02, 0xA2, 0x47, 
	0x92, 0x39, 0xA2, 0x47, 
	0xB3, 0x92, 0x38, 0x80, 
	0x3F, 0xE5, 0x46, 0x30, 
	0xE3, 0x03, 0xD3, 0x80, 
	0x27, 0xC3, 0x80, 0x24, 
	0xE5, 0x46, 0x30, 0xE3, 
	0x0D, 0x54, 0x70, 0xC3, 
	0x94, 0x60, 0x50, 0x06, 
	0x7E, 0x00, 0x7F, 0x01, 
	0x80, 0x04, 0x7E, 0x00, 
	0x7F, 0x00, 0x20, 0x47, 
	0x04, 0x7D, 0x01, 0x80, 
	0x02, 0x7D, 0x00, 0xEF, 
	0x6D, 0x4E, 0x24, 0xFF, 
	0x92, 0x38, 0xA2, 0x47, 
	0xB3, 0x92, 0x39, 0x80, 
	0x07, 0xA2, 0x47, 0xB3, 
	0x92, 0x38, 0x92, 0x39, 
	0x90, 0x02, 0x28, 0xE0, 
	0x54, 0xFC, 0x45, 0x27, 
	0xF0, 0x22, 0xE4, 0x90, 
	0x02, 0x29, 0xF0, 0x30, 
	0x47, 0x04, 0xAF, 0x45, 
	0x80, 0x04, 0xE5, 0x45, 
	0xF4, 0xFF, 0x90, 0x02, 
	0x28, 0xEF, 0xF0, 0x22, 
	0x8F, 0x50, 0xD2, 0x59, 
	0x22, 0x8F, 0x54, 0xD2, 
	0x58, 0x22, 0xE4, 0xF5, 
	0x30, 0xC2, 0xAF, 0xE5, 
	0x51, 0x14, 0x60, 0x4A, 
	0x14, 0x60, 0x6A, 0x24, 
	0x02, 0x60, 0x03, 0x02, 
	0x17, 0x4C, 0xD2, 0x59, 
	0x75, 0x55, 0x01, 0x20, 
	0x19, 0x1C, 0x90, 0x02, 
	0x08, 0xE0, 0x54, 0xFE, 
	0xF0, 0xE0, 0x20, 0xE1, 
	0x23, 0x90, 0x04, 0x34, 
	0xE0, 0xB4, 0x02, 0x1C, 
	0xA3, 0xE0, 0xB4, 0x02, 
	0x17, 0xA3, 0xE0, 0xB4, 
	0x02, 0x12, 0x7F, 0x20, 
	0x12, 0x16, 0x4C, 0x90, 
	0x10, 0x04, 0xE0, 0x54, 
	0xF3, 0xF0, 0x75, 0x51, 
	0x01, 0x02, 0x17, 0x4C, 
	0xE5, 0x50, 0x70, 0x06, 
	0x75, 0x30, 0x03, 0x02, 
	0x17, 0x4C, 0x90, 0x12, 
	0x00, 0xE0, 0x54, 0x03, 
	0x70, 0x15, 0x7F, 0x20, 
	0x12, 0x16, 0x4C, 0x20, 
	0x19, 0x07, 0x90, 0x02, 
	0x08, 0xE0, 0x54, 0xFB, 
	0xF0, 0x75, 0x51, 0x02, 
	0x02, 0x17, 0x4C, 0xE5, 
	0x50, 0x70, 0x02, 0x80, 
	0x7A, 0x20, 0x19, 0x0F, 
	0x90, 0x02, 0x08, 0xE0, 
	0x20, 0xE3, 0x6C, 0x90, 
	0x04, 0x37, 0xE0, 0x64, 
	0x22, 0x70, 0x64, 0x90, 
	0x12, 0x04, 0x74, 0x0A, 
	0xF0, 0x30, 0x1B, 0x11, 
	0x90, 0x13, 0x28, 0xE0, 
	0x54, 0xF0, 0xF0, 0xA3, 
	0xE0, 0x54, 0xF0, 0xF0, 
	0xA3, 0xE0, 0x54, 0xFA, 
	0xF0, 0x20, 0x19, 0x07, 
	0x90, 0x04, 0x01, 0xE0, 
	0x44, 0x10, 0xF0, 0xE5, 
	0x34, 0xF4, 0x90, 0x04, 
	0x01, 0x60, 0x06, 0xE0, 
	0x54, 0xFB, 0xF0, 0x80, 
	0x04, 0xE0, 0x54, 0xF9, 
	0xF0, 0x20, 0x19, 0x07, 
	0x90, 0x12, 0x04, 0xE0, 
	0x44, 0x04, 0xF0, 0xE5, 
	0x34, 0xF4, 0x60, 0x14, 
	0x90, 0x01, 0x0D, 0xE0, 
	0xF5, 0x33, 0xE5, 0x34, 
	0xD3, 0x94, 0x02, 0x40, 
	0x07, 0x90, 0x12, 0x04, 
	0xE0, 0x54, 0xFD, 0xF0, 
	0x75, 0x30, 0x01, 0x75, 
	0x55, 0x02, 0xE4, 0xF5, 
	0x51, 0x80, 0x09, 0xE5, 
	0x50, 0x70, 0x05, 0x75, 
	0x30, 0x03, 0xF5, 0x51, 
	0xE5, 0x30, 0x60, 0x18, 
	0xC2, 0x01, 0xE4, 0xF5, 
	0x51, 0xC2, 0x59, 0x20, 
	0x19, 0x0E, 0xAD, 0x30, 
	0xAF, 0x40, 0x12, 0x18, 
	0x2A, 0xE5, 0x30, 0xB4, 
	0x03, 0x02, 0xD2, 0x03, 
	0xD2, 0xAF, 0x22, 0xC2, 
	0xAF, 0x30, 0x01, 0x0E, 
	0xE4, 0xF5, 0x51, 0xC2, 
	0x59, 0xC2, 0x01, 0x7D, 
	0x02, 0xAF, 0x40, 0x12, 
	0x18, 0x2A, 0xE5, 0x52, 
	0x14, 0x60, 0x55, 0x14, 
	0x60, 0x2F, 0x24, 0x02, 
	0x60, 0x03, 0x02, 0x18, 
	0x27, 0xE5, 0x34, 0xF4, 
	0x60, 0x23, 0xE5, 0x34, 
	0xD3, 0x94, 0x02, 0x40, 
	0x16, 0x90, 0x12, 0x04, 
	0xE0, 0x44, 0x02, 0xF0, 
	0x90, 0x01, 0x0D, 0xE0, 
	0x20, 0xE3, 0x03, 0x02, 
	0x18, 0x27, 0x7F, 0x50, 
	0x12, 0x16, 0x51, 0x75, 
	0x52, 0x02, 0x75, 0x55, 
	0x03, 0xE5, 0x34, 0xF4, 
	0x60, 0x0A, 0xE5, 0x54, 
	0x70, 0x69, 0x90, 0x01, 
	0x0D, 0xE5, 0x33, 0xF0, 
	0x90, 0x12, 0x04, 0xE0, 
	0x54, 0xFB, 0xF0, 0x7F, 
	0x20, 0x12, 0x16, 0x51, 
	0x75, 0x52, 0x01, 0x75, 
	0x55, 0x03, 0x80, 0x4F, 
	0xE5, 0x54, 0x70, 0x4B, 
	0x90, 0x04, 0x01, 0xE0, 
	0x44, 0x0E, 0xF0, 0x20, 
	0x19, 0x04, 0xE0, 0x54, 
	0xEF, 0xF0, 0x90, 0x13, 
	0x28, 0xE0, 0x44, 0x0F, 
	0xF0, 0xA3, 0xE0, 0x44, 
	0x0F, 0xF0, 0xA3, 0xE0, 
	0x44, 0x05, 0xF0, 0x90, 
	0x12, 0x04, 0x74, 0x03, 
	0xF0, 0x20, 0x19, 0x07, 
	0x90, 0x02, 0x08, 0xE0, 
	0x44, 0x05, 0xF0, 0x90, 
	0x10, 0x04, 0xE0, 0x44, 
	0x0C, 0xF0, 0xE4, 0xF5, 
	0x52, 0xF5, 0x55, 0x30, 
	0x02, 0x0B, 0xC2, 0x02, 
	0x7D, 0x01, 0xAF, 0x41, 
	0x12, 0x18, 0x2A, 0x80, 
	0x02, 0xC2, 0x03, 0xD2, 
	0xAF, 0x22, 0xEF, 0xF4, 
	0x60, 0x2D, 0xE4, 0xFE, 
	0x74, 0x14, 0x2E, 0xF5, 
	0x82, 0xE4, 0x34, 0x70, 
	0xF5, 0x83, 0xE0, 0xB4, 
	0xFF, 0x19, 0x74, 0x14, 
	0x2E, 0xF5, 0x82, 0xE4, 
	0x34, 0x70, 0xF5, 0x83, 
	0xEF, 0xF0, 0x74, 0x1C, 
	0x2E, 0xF5, 0x82, 0xE4, 
	0x34, 0x70, 0xF5, 0x83, 
	0xED, 0xF0, 0x22, 0x0E, 
	0xBE, 0x04, 0xD5, 0x22, 
	0x22, 0x22, 0x20, 0x19, 
	0x03, 0x02, 0x19, 0x0F, 
	0x90, 0x70, 0x80, 0xE0, 
	0x04, 0xF0, 0x90, 0x04, 
	0x37, 0xE0, 0x30, 0xE5, 
	0x03, 0x02, 0x19, 0x0B, 
	0x90, 0x04, 0x28, 0xE0, 
	0xF5, 0x31, 0xA3, 0xE0, 
	0xF5, 0x30, 0xF5, 0x32, 
	0xE4, 0xF5, 0x37, 0x90, 
	0x70, 0x81, 0xE0, 0x04, 
	0xF0, 0x90, 0x70, 0x82, 
	0xE0, 0x04, 0xF0, 0xE5, 
	0x32, 0x75, 0xF0, 0x80, 
	0xA4, 0x24, 0x00, 0xFF, 
	0xE5, 0xF0, 0x34, 0x80, 
	0xFE, 0xE5, 0x30, 0x65, 
	0x32, 0x70, 0x05, 0xFC, 
	0x7D, 0x18, 0x80, 0x04, 
	0x7C, 0x00, 0x7D, 0x00, 
	0xEF, 0x2D, 0xFF, 0xEE, 
	0x3C, 0xFE, 0x12, 0x19, 
	0x10, 0x50, 0x25, 0x90, 
	0x70, 0x83, 0xE0, 0x04, 
	0xF0, 0x90, 0x01, 0x14, 
	0xE0, 0x44, 0x02, 0xF0, 
	0xE0, 0x30, 0xE1, 0x06, 
	0x90, 0x70, 0x92, 0x74, 
	0x45, 0xF0, 0x90, 0x70, 
	0x93, 0xE0, 0x04, 0xF0, 
	0x90, 0x04, 0x01, 0xE0, 
	0x90, 0x70, 0x94, 0xF0, 
	0xE5, 0x32, 0x65, 0x31, 
	0x60, 0x10, 0xE4, 0x25, 
	0x32, 0xFF, 0xE4, 0x34, 
	0x80, 0x8F, 0x82, 0xF5, 
	0x83, 0xE0, 0xF5, 0x32, 
	0x80, 0x97, 0x90, 0x04, 
	0x10, 0x74, 0x01, 0xF0, 
	0x90, 0x04, 0x28, 0xE5, 
	0x31, 0xF0, 0xA3, 0xE5, 
	0x30, 0xF0, 0x90, 0x04, 
	0x11, 0x74, 0x01, 0xF0, 
	0x02, 0x18, 0x6A, 0xC2, 
	0x06, 0xD2, 0x1A, 0x22, 
	0x90, 0x70, 0x84, 0xE5, 
	0x37, 0xF0, 0xC3, 0x94, 
	0x06, 0x50, 0x19, 0x8F, 
	0x82, 0x8E, 0x83, 0xE0, 
	0xB4, 0xFF, 0x07, 0x05, 
	0x37, 0xE4, 0xF5, 0x36, 
	0x80, 0x59, 0xE4, 0xF5, 
	0x37, 0x8F, 0x82, 0x8E, 
	0x83, 0xF0, 0x80, 0x4F, 
	0xE5, 0x36, 0x75, 0xF0, 
	0x06, 0x84, 0x74, 0x08, 
	0x25, 0xF0, 0xF5, 0x82, 
	0xE4, 0x34, 0x10, 0xF5, 
	0x83, 0xE0, 0xFD, 0x8F, 
	0x82, 0x8E, 0x83, 0xE0, 
	0xFC, 0x6D, 0x70, 0x30, 
	0x90, 0x70, 0x88, 0xE0, 
	0x04, 0xF0, 0xA3, 0xE0, 
	0xFD, 0xD3, 0x95, 0x37, 
	0x40, 0x02, 0x80, 0x02, 
	0xAD, 0x37, 0x90, 0x70, 
	0x89, 0xED, 0xF0, 0x05, 
	0x37, 0x05, 0x36, 0xE5, 
	0x36, 0x75, 0xF0, 0x06, 
	0x84, 0x74, 0x8A, 0x25, 
	0xF0, 0xF5, 0x82, 0xE4, 
	0x34, 0x70, 0xF5, 0x83, 
	0xEC, 0xF0, 0x80, 0x03, 
	0xE4, 0xF5, 0x37, 0x0F, 
	0xBF, 0x00, 0x01, 0x0E, 
	0xEF, 0x54, 0x7F, 0x60, 
	0x0A, 0xE5, 0x37, 0xC3, 
	0x94, 0x4E, 0x50, 0x03, 
	0x02, 0x19, 0x10, 0xE5, 
	0x37, 0xB4, 0x4E, 0x03, 
	0xD3, 0x80, 0x01, 0xC3, 
	0x22, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x0B, 0x94, 0xEB, 
};

#endif /* _RT2860_UCODE_H_ */


