
/*-
 * Copyright (c) 2009-2010 Alexander Egorenkov <egorenar@gmail.com>
 * Copyright (c) 2009 Damien Bergamini <damien.bergamini@free.fr>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef _RT2860_REG_H_
#define _RT2860_REG_H_

#define RT2860_REG_PCI_CFG					0x0000
#define RT2860_REG_EEPROM_CSR					0x0004
#define RT2860_REG_PCI_MCU_CSR					0x0008
#define RT2860_REG_PCI_SYS_CSR					0x000c
#define RT2860_REG_PCIE_JTAG					0x0010

#define RT2860_REG_SCHDMA_INT_STATUS				0x0200
#define RT2860_REG_SCHDMA_INT_MASK					0x0204
#define RT2860_REG_SCHDMA_WPDMA_GLO_CFG				0x0208
#define RT2860_REG_SCHDMA_WPDMA_RST_IDX				0x020c
#define RT2860_REG_SCHDMA_DELAY_INT_CFG				0x0210
#define RT2860_REG_SCHDMA_WMM_AIFSN_CFG				0x0214
#define RT2860_REG_SCHDMA_WMM_CWMIN_CFG				0x0218
#define RT2860_REG_SCHDMA_WMM_CWMAX_CFG				0x021c
#define RT2860_REG_SCHDMA_WMM_TXOP0_CFG    			0x0220
#define RT2860_REG_SCHDMA_WMM_TXOP1_CFG    			0x0224
#define RT2860_REG_SCHDMA_GPIO_CTRL_CFG    			0x0228
#define RT2860_REG_SCHDMA_RX_BASE_PTR				0x0290
#define RT2860_REG_SCHDMA_RX_MAX_CNT				0x0294
#define RT2860_REG_SCHDMA_RX_CALC_IDX				0x0298
#define RT2860_REG_SCHDMA_RX_DRX_IDX				0x029c
#define RT2860_REG_SCHDMA_TX_BASE_PTR(qid)			(0x0230 + (qid) * 16)
#define RT2860_REG_SCHDMA_TX_MAX_CNT(qid)			(0x0234 + (qid) * 16)
#define RT2860_REG_SCHDMA_TX_CTX_IDX(qid)			(0x0238 + (qid) * 16)
#define RT2860_REG_SCHDMA_TX_DTX_IDX(qid)			(0x023c + (qid) * 16)
#define RT2860_REG_SCHDMA_US_CYC_CNT				0x02a4

#define RT2860_REG_PBF_SYS_CTRL						0x0400
#define RT2860_REG_PBF_HOST_CMD						0x0404
#define RT2860_REG_PBF_CFG						0x0408
#define RT2860_REG_PBF_MAX_PCNT						0x040c
#define RT2860_REG_PBF_BUF_CTRL						0x0410
#define RT2860_REG_PBF_MCU_INT_STA					0x0414
#define RT2860_REG_PBF_MCU_INT_ENA					0x0418
#define RT2860_REG_PBF_TX0Q_IO						0x041c
#define RT2860_REG_PBF_TX1Q_IO						0x0420
#define RT2860_REG_PBF_TX2Q_IO						0x0424
#define RT2860_REG_PBF_RX0Q_IO						0x0428
#define RT2860_REG_PBF_BCN_OFFSET0					0x042c
#define RT2860_REG_PBF_BCN_OFFSET1					0x0430
#define RT2860_REG_PBF_TXRXQ_STA					0x0434
#define RT2860_REG_PBF_TXRXQ_PCNT					0x0438
#define RT2860_REG_PBF_DBG						0x043c
#define RT2860_REG_PBF_CAP_CTRL						0x0440

#define RT2872_REG_RF_CSR_CFG						0x500
#define RT2872_REG_RF_SETTING						0x504
#define RT2872_REG_RF_TEST_CONTROL					0x508

#define RT2860_REG_MAC_CSR0						0x1000
#define RT2860_REG_SYS_CTRL						0x1004
#define RT2860_REG_ADDR_DW0						0x1008
#define RT2860_REG_ADDR_DW1						0x100c
#define RT2860_REG_BSSID_DW0						0x1010
#define RT2860_REG_BSSID_DW1						0x1014
#define RT2860_REG_MAX_LEN_CFG						0x1018
#define RT2860_REG_BBP_CSR_CFG						0x101c
#define RT2860_REG_RF_CSR_CFG0						0x1020
#define RT2860_REG_LED_CFG						0x102c
#define RT2860_REG_AMPDU_MAX_LEN_20M1S					0x1030
#define RT2860_REG_AMPDU_MAX_LEN_20M2S					0x1034
#define RT2860_REG_AMPDU_MAX_LEN_40M1S					0x1038
#define RT2860_REG_AMPDU_MAX_LEN_40M2S					0x103c
#define RT2860_REG_AMPDU_BA_WINSIZE					0x1040

#define RT2860_REG_XIFS_TIME_CFG             				0x1100
#define RT2860_REG_BKOFF_SLOT_CFG					0x1104
#define RT2860_REG_NAV_TIME_CFG						0x1108
#define RT2860_REG_CH_TIME_CFG						0x110c
#define RT2860_REG_PBF_LIFE_TIMER					0x1110
#define RT2860_REG_BCN_TIME_CFG						0x1114
#define RT2860_REG_TBTT_SYNC_CFG					0x1118
#define RT2860_REG_TSF_TIMER_DW0					0x111c
#define RT2860_REG_TSF_TIMER_DW1					0x1120
#define RT2860_REG_TBTT_TIMER						0x1124
#define RT2860_REG_INT_TIMER						0x1128
#define RT2860_REG_INT_TIMER_EN						0x112c
#define RT2860_REG_CH_IDLE_STA						0x1130

#define RT2860_REG_STATUS_CFG						0x1200
#define RT2860_REG_PWR_PIN_CFG						0x1204
#define RT2860_REG_AUTO_WAKEUP_CFG					0x1208

#define RT2860_REG_TX_EDCA_AC_CFG(aci)					(0x1300 + (aci) * 4)
#define RT2860_REG_TX_EDCA_TID_AC_MAP					0x1310
#define RT2860_REG_TX_PWR_CFG(ridx)					(0x1314 + (ridx) * 4)
#define RT2860_REG_TX_PIN_CFG						0x1328
#define RT2860_REG_TX_BAND_CFG						0x132c
#define RT2860_REG_TX_SW_CFG0						0x1330
#define RT2860_REG_TX_SW_CFG1						0x1334
#define RT2860_REG_TX_SW_CFG2						0x1338
#define RT2860_REG_TX_TXOP_THRES_CFG					0x133c
#define RT2860_REG_TX_TXOP_CTRL_CFG					0x1340
#define RT2860_REG_TX_RTS_CFG						0x1344
#define RT2860_REG_TX_TIMEOUT_CFG					0x1348
#define RT2860_REG_TX_RTY_CFG						0x134c
#define RT2860_REG_TX_LINK_CFG						0x1350
#define RT2860_REG_TX_HT_FBK_CFG0					0x1354
#define RT2860_REG_TX_HT_FBK_CFG1					0x1358
#define RT2860_REG_TX_LG_FBK_CFG0					0x135c
#define RT2860_REG_TX_LG_FBK_CFG1					0x1360
#define RT2860_REG_TX_CCK_PROT_CFG					0x1364
#define RT2860_REG_TX_OFDM_PROT_CFG					0x1368
#define RT2860_REG_TX_MM20_PROT_CFG					0x136c
#define RT2860_REG_TX_MM40_PROT_CFG					0x1370
#define RT2860_REG_TX_GF20_PROT_CFG					0x1374
#define RT2860_REG_TX_GF40_PROT_CFG					0x1378
#define RT2860_REG_TX_EXP_CTS_TIME					0x137c
#define RT2860_REG_TX_EXP_ACK_TIME					0x1380

#define RT2860_REG_RX_FILTER_CFG					0x1400
#define RT2860_REG_AUTO_RSP_CFG						0x1404
#define RT2860_REG_LEGACY_BASIC_RATE					0x1408
#define RT2860_REG_HT_BASIC_RATE					0x140c
#define RT2860_REG_HT_CTRL_CFG						0x1410
#define RT2860_REG_SIFS_COST_CFG					0x1414
#define RT2860_REG_RX_PARSER_CFG					0x1418

#define RT2860_REG_TX_SEC_CNT0						0x1500
#define RT2860_REG_RX_SEC_CNT0						0x1504
#define RT2860_REG_CCMP_FC_MUTE						0x1508

#define RT2860_REG_HCCAPSMP_TXOP_HLDR_ADDR0				0x1600
#define RT2860_REG_HCCAPSMP_TXOP_HLDR_ADDR1				0x1604
#define RT2860_REG_HCCAPSMP_TXOP_HLDR_ET				0x1608
#define RT2860_REG_HCCAPSMP_QOS_CFPOLL_RA_DW0				0x160c
#define RT2860_REG_HCCAPSMP_QOS_CFPOLL_A1_DW1				0x1610
#define RT2860_REG_HCCAPSMP_QOS_CFPOLL_QC				0x1614

#define RT2860_REG_RX_STA_CNT0						0x1700
#define RT2860_REG_RX_STA_CNT1						0x1704
#define RT2860_REG_RX_STA_CNT2						0x1708
#define RT2860_REG_TX_STA_CNT0						0x170c
#define RT2860_REG_TX_STA_CNT1						0x1710
#define RT2860_REG_TX_STA_CNT2						0x1714
#define RT2860_REG_TX_STA_FIFO						0x1718
#define RT2860_REG_TX_AGG_CNT						0x171c
#define RT2860_REG_TX_AGG_CNT0						0x1720
#define RT2860_REG_TX_AGG_CNT1						0x1724
#define RT2860_REG_TX_AGG_CNT2						0x1728
#define RT2860_REG_TX_AGG_CNT3						0x172c
#define RT2860_REG_TX_AGG_CNT4						0x1730
#define RT2860_REG_TX_AGG_CNT5						0x1734
#define RT2860_REG_TX_AGG_CNT6						0x1738
#define RT2860_REG_TX_AGG_CNT7						0x173c
#define RT2860_REG_TXRX_MPDU_DEN_CNT					0x1740

#define RT2860_REG_WCID(wcid)						(0x1800 + (wcid) * 8)
#define RT2860_REG_PKEY(wcid)						(0x4000 + (wcid) * 32)
#define RT2860_REG_IVEIV(wcid)						(0x6000 + (wcid) * 8)
#define RT2860_REG_WCID_ATTR(wcid)					(0x6800 + (wcid) * 4)
#define RT2860_REG_SKEY(vap, kidx)					(0x6c00 + ((vap) * 4 + (kidx)) * 32)
#define RT2860_REG_SKEY_MODE(vap)					(0x7000 + ((vap) / 2) * 4)

#define RT2860_REG_MCU_UCODE_BASE					0x2000

#define RT2860_REG_H2M_HOST_CMD						0x0404
#define RT2860_REG_H2M_MAILBOX						0x7010
#define RT2860_REG_H2M_MAILBOX_CID					0x7014
#define RT2860_REG_H2M_MAILBOX_STATUS				0x701c
#define RT2860_REG_H2M_MAILBOX_BBP_AGENT			0x7028

#define RT2860_REG_BEACON_BASE(vap)					(0x7800 + (vap) * 512)

/* RT3070 registers */
#define RT3070_RF_CSR_CFG		0x0500
#define RT3070_EFUSE_CTRL		0x0580
#define RT3070_EFUSE_DATA0		0x0590
#define RT3070_EFUSE_DATA1		0x0594
#define RT3070_EFUSE_DATA2		0x0598
#define RT3070_EFUSE_DATA3		0x059c
#define RT3090_OSC_CTRL			0x05a4
#define RT3070_LDO_CFG0			0x05d4
#define RT3070_GPIO_SWITCH		0x05dc

#define RT3090_AUX_CTRL			0x010c
#define RT3070_OPT_14			0x0114

/* possible flags for register RF_CSR_CFG */
#define RT3070_RF_KICK		(1 << 17)
#define RT3070_RF_WRITE		(1 << 16)

/* possible flags for register EFUSE_CTRL */
#define RT3070_SEL_EFUSE	(1 << 31)
#define RT3070_EFSROM_KICK	(1 << 30)
#define RT3070_EFSROM_AIN_MASK	0x03ff0000
#define RT3070_EFSROM_AIN_SHIFT	16
#define RT3070_EFSROM_MODE_MASK	0x000000c0
#define RT3070_EFUSE_AOUT_MASK	0x0000003f

/* possible flags for RT3020 RF register 1 */
#define RT3070_RF_BLOCK	(1 << 0)
#define RT3070_RX0_PD	(1 << 2)
#define RT3070_TX0_PD	(1 << 3)
#define RT3070_RX1_PD	(1 << 4)
#define RT3070_TX1_PD	(1 << 5)
#define RT3070_RX2_PD	(1 << 6)
#define RT3070_TX2_PD	(1 << 7)

/* possible flags for RT3020 RF register 1 */
#define RT3070_RF_BLOCK	(1 << 0)
#define RT3070_RX0_PD	(1 << 2)
#define RT3070_TX0_PD	(1 << 3)
#define RT3070_RX1_PD	(1 << 4)
#define RT3070_TX1_PD	(1 << 5)
#define RT3070_RX2_PD	(1 << 6)
#define RT3070_TX2_PD	(1 << 7)

/* possible flags for RT3020 RF register 7 */
#define RT3070_TUNE	(1 << 0)

/* possible flags for RT3020 RF register 15 */
#define RT3070_TX_LO2	(1 << 3)

/* possible flags for RT3020 RF register 17 */
#define RT3070_TX_LO1	(1 << 3)

/* possible flags for RT3020 RF register 20 */
#define RT3070_RX_LO1	(1 << 3)

/* possible flags for RT3020 RF register 21 */
#define RT3070_RX_LO2	(1 << 3)
#define RT3070_RX_CTB	(1 << 7)

/* possible flags for RT3020 RF register 22 */
#define RT3070_BB_LOOPBACK	(1 << 0)

/* possible flags for RT3053 RF register 1 */
#define RT3593_VCO	(1 << 0)

/* possible flags for RT3053 RF register 2 */
#define RT3593_RESCAL	(1 << 7)

/* possible flags for RT3053 RF register 3 */
#define RT3593_VCOCAL	(1 << 7)

/* possible flags for RT3053 RF register 6 */
#define RT3593_VCO_IC	(1 << 6)

/* possible flags for RT3053 RF register 20 */
#define RT3593_LDO_PLL_VC_MASK	0x0e
#define RT3593_LDO_RF_VC_MASK	0xe0

/* possible flags for RT3053 RF register 22 */
#define RT3593_CP_IC_MASK	0xe0
#define RT3593_CP_IC_SHIFT	5

/* possible flags for RT3053 RF register 46 */
#define RT3593_RX_CTB	(1 << 5)

#define RT3090_DEF_LNA	10


#define RT2860_REG_RF_R1							0
#define RT2860_REG_RF_R2							1
#define RT2860_REG_RF_R3							2
#define RT2860_REG_RF_R4							3

/*
 * RT2860_REG_EEPROM_CSR flags
 */
#define RT2860_REG_EERL								(1 << 7)
#define RT2860_REG_EEDO								(1 << 3)
#define RT2860_REG_EEDI								(1 << 2)
#define RT2860_REG_EECS								(1 << 1)
#define RT2860_REG_EESK								(1 << 0)
#define RT2860_REG_EEOP_READ						0x6

/*
 * RT2860_REG_SCHDMA_INT_STATUS
 * RT2860_REG_SCHDMA_INT_MASK flags
 */
#define RT2860_REG_INT_TX_COHERENT					(1 << 17)
#define RT2860_REG_INT_RX_COHERENT					(1 << 16)
#define RT2860_REG_INT_GP_TIMER						(1 << 15)
#define RT2860_REG_INT_AUTO_WAKEUP					(1 << 14)
#define RT2860_REG_INT_FIFO_STA_FULL				(1 << 13)
#define RT2860_REG_INT_PRE_TBTT						(1 << 12)
#define RT2860_REG_INT_TBTT							(1 << 11)
#define RT2860_REG_INT_TXRX_COHERENT				(1 << 10)
#define RT2860_REG_INT_MCU_CMD						(1 << 9)
#define RT2860_REG_INT_TX_MGMT_DONE					(1 << 8)
#define RT2860_REG_INT_TX_HCCA_DONE					(1 << 7)
#define RT2860_REG_INT_TX_AC3_DONE					(1 << 6)
#define RT2860_REG_INT_TX_AC2_DONE					(1 << 5)
#define RT2860_REG_INT_TX_AC1_DONE					(1 << 4)
#define RT2860_REG_INT_TX_AC0_DONE					(1 << 3)
#define RT2860_REG_INT_RX_DONE						(1 << 2)
#define RT2860_REG_INT_TX_DELAY_DONE				(1 << 1)
#define RT2860_REG_INT_RX_DELAY_DONE				(1 << 0)

/*
 * RT2860_REG_SCHDMA_WPDMA_GLO_CFG flags
 */
#define RT2860_REG_TX_WB_DDONE						(1 << 6)
#define RT2860_REG_RX_DMA_BUSY						(1 << 3)
#define RT2860_REG_RX_DMA_ENABLE					(1 << 2)
#define RT2860_REG_TX_DMA_BUSY						(1 << 1)
#define RT2860_REG_TX_DMA_ENABLE					(1 << 0)
#define RT2860_REG_WPDMA_BT_SIZE_SHIFT				4
#define RT2860_REG_WPDMA_BT_SIZE16					0
#define RT2860_REG_WPDMA_BT_SIZE32					1
#define RT2860_REG_WPDMA_BT_SIZE64					2
#define RT2860_REG_WPDMA_BT_SIZE128					3

/*
 * RT2860_REG_SCHDMA_WPDMA_RST_IDX flags
 */
#define RT2860_REG_RST_IDX_RX						(1 << 16)
#define RT2860_REG_RST_IDX_TX_MGMT					(1 << 5)
#define RT2860_REG_RST_IDX_TX_HCCA					(1 << 4)
#define RT2860_REG_RST_IDX_TX_AC3					(1 << 3)
#define RT2860_REG_RST_IDX_TX_AC2					(1 << 2)
#define RT2860_REG_RST_IDX_TX_AC1					(1 << 1)
#define RT2860_REG_RST_IDX_TX_AC0					(1 << 0)

/*
 * RT2860_REG_SCHDMA_DELAY_INT_CFG flags
 */
#define RT2860_REG_INT_TX_DELAY_ENABLE				(1 << 31)
#define RT2860_REG_INT_TX_MAX_PINT_SHIFT			24
#define RT2860_REG_INT_TX_MAX_PINT_MASK				0x7
#define RT2860_REG_INT_TX_MAX_PTIME_SHIFT			16
#define RT2860_REG_INT_TX_MAX_PTIME_MASK			0x8
#define RT2860_REG_INT_RX_DELAY_ENABLE				(1 << 15)
#define RT2860_REG_INT_RX_MAX_PINT_SHIFT			8
#define RT2860_REG_INT_RX_MAX_PINT_MASK				0x7
#define RT2860_REG_INT_RX_MAX_PTIME_SHIFT			0
#define RT2860_REG_INT_RX_MAX_PTIME_MASK			0x8

/*
 * RT2860_REG_PBF_SYS_CTRL flags
 */
#define RT2860_REG_HST_PM_SEL						(1 << 16)
#define RT2860_REG_MCU_READY						(1 << 7)
#define RT2860_REG_MCU_RESET						(1 << 0)

/*
 * RT2860_REG_PBF_TXRXQ_PCNT flags
 */
#define RT2860_REG_RXQ_PCNT_SHIFT					24
#define RT2860_REG_RXQ_PCNT_MASK					0xff
#define RT2860_REG_TX2Q_PCNT_SHIFT					16
#define RT2860_REG_TX2Q_PCNT_MASK					0xff
#define RT2860_REG_TX1Q_PCNT_SHIFT					8
#define RT2860_REG_TX1Q_PCNT_MASK					0xff
#define RT2860_REG_TX0Q_PCNT_SHIFT					0
#define RT2860_REG_TX0Q_PCNT_MASK					0xff

/*
 * RT2860_REG_SYS_CTRL flags
 */
#define RT2860_REG_RX_ENABLE						(1 << 3)
#define RT2860_REG_TX_ENABLE						(1 << 2)
#define RT2860_REG_BBP_HRST							(1 << 1)
#define RT2860_REG_MAC_SRST							(1 << 0)

/*
 * RT2872_REG_RF_CSR_CFG flags
 */
#define RT2872_REG_RF_CSR_BUSY						(1 << 17)
#define RT2872_REG_RF_CSR_KICK						(1 << 17)
#define RT2872_REG_RF_CSR_WRITE						(1 << 16)
#define RT2872_REG_RF_ID_SHIFT						8
#define RT2872_REG_RF_ID_MASK						0x1f
#define RT2872_REG_RF_VAL_SHIFT						0
#define RT2872_REG_RF_VAL_MASK						0xff

/*
 * RT2860_REG_BBP_CSR_CFG flags
 */
#define RT2860_REG_BBP_RW_MODE_PARALLEL					(1 << 19)
#define RT2860_REG_BBP_PAR_DUR						(1 << 19)
#define RT2860_REG_BBP_CSR_BUSY						(1 << 17)
#define RT2860_REG_BBP_CSR_KICK						(1 << 17)
#define RT2860_REG_BBP_CSR_READ						(1 << 16)
#define RT2860_REG_BBP_REG_SHIFT					8
#define RT2860_REG_BBP_REG_MASK						0xff
#define RT2860_REG_BBP_VAL_SHIFT					0
#define RT2860_REG_BBP_VAL_MASK						0xff

/*
 * RT2860_REG_RF_CSR_CFG0 flags
 */
#define RT2860_REG_RF_BUSY							(1 << 31)

/*
 * RT2860_REG_BCN_TIME_CFG flags
 */
#define RT2860_REG_BCN_TX_ENABLE					(1 << 20)
#define RT2860_REG_TBTT_TIMER_ENABLE				(1 << 19)
#define RT2860_REG_TSF_TIMER_ENABLE					(1 << 16)
#define RT2860_REG_TSF_SYNC_MODE_SHIFT				17
#define RT2860_REG_TSF_SYNC_MODE_MASK				0x3
#define RT2860_REG_TSF_SYNC_MODE_DISABLE			0
#define RT2860_REG_TSF_SYNC_MODE_STA				1
#define RT2860_REG_TSF_SYNC_MODE_IBSS				2
#define RT2860_REG_TSF_SYNC_MODE_HOSTAP				3

/*
 * RT2860_REG_STATUS_CFG flags
 */
#define RT2860_REG_STATUS_RX_BUSY					(1 << 1)
#define RT2860_REG_STATUS_TX_BUSY					(1 << 0)

/*
 * RT2860_REG_TX_PIN_CFG flags
 */
#define RT2860_REG_TRSW_ENABLE						(1 << 18)
#define RT2860_REG_RFTR_ENABLE						(1 << 16)
#define RT2860_REG_LNA_PE_G1_ENABLE					(1 << 11)
#define RT2860_REG_LNA_PE_A1_ENABLE					(1 << 10)
#define RT2860_REG_LNA_PE_G0_ENABLE					(1 << 9)
#define RT2860_REG_LNA_PE_A0_ENABLE					(1 << 8)
#define RT2860_REG_PA_PE_G1_ENABLE					(1 << 3)
#define RT2860_REG_PA_PE_A1_ENABLE					(1 << 2)
#define RT2860_REG_PA_PE_G0_ENABLE					(1 << 1)
#define RT2860_REG_PA_PE_A0_ENABLE					(1 << 0)

/*
 * RT2860_REG_TX_BAND_CFG flags
 */
#define RT2860_REG_TX_BAND_BG						(1 << 2)
#define RT2860_REG_TX_BAND_A						(1 << 1)
#define RT2860_REG_TX_BAND_HT40_ABOVE				(1 << 0)
#define RT2860_REG_TX_BAND_HT40_BELOW				(0 << 0)

/*
 * RT2860_REG_TX_RTS_CFG flags
 */
#define RT2860_REG_TX_RTS_THRESHOLD_SHIFT			8
#define RT2860_REG_TX_RTS_THRESHOLD_MASK			0xffff

/*
 * RT2860_REG_TX_CCK_PROT_CFG
 * RT2860_REG_TX_OFDM_PROT_CFG
 * RT2860_REG_TX_MM20_PROT_CFG
 * RT2860_REG_TX_MM40_PROT_CFG
 * RT2860_REG_TX_GF20_PROT_CFG
 * RT2860_REG_TX_GF40_PROT_CFG flags
 */
#define RT2860_REG_RTSTH_ENABLE						(1 << 26)
#define RT2860_REG_TXOP_ALLOW_GF40					(1 << 25)
#define RT2860_REG_TXOP_ALLOW_GF20					(1 << 24)
#define RT2860_REG_TXOP_ALLOW_MM40					(1 << 23)
#define RT2860_REG_TXOP_ALLOW_MM20					(1 << 22)
#define RT2860_REG_TXOP_ALLOW_OFDM					(1 << 21)
#define RT2860_REG_TXOP_ALLOW_CCK					(1 << 20)
#define RT2860_REG_TXOP_ALLOW_ALL					(0x3f << 20)
#define RT2860_REG_PROT_NAV_NONE					(0 << 18)
#define RT2860_REG_PROT_NAV_SHORT					(1 << 18)
#define RT2860_REG_PROT_NAV_LONG					(2 << 18)
#define RT2860_REG_PROT_CTRL_NONE					(0 << 16)
#define RT2860_REG_PROT_CTRL_RTS_CTS				(1 << 16)
#define RT2860_REG_PROT_CTRL_CTS					(2 << 16)
#define RT2860_REG_PROT_PHYMODE_SHIFT				14
#define RT2860_REG_PROT_PHYMODE_MASK				0x3
#define RT2860_REG_PROT_PHYMODE_CCK					0
#define RT2860_REG_PROT_PHYMODE_OFDM				1
#define RT2860_REG_PROT_MCS_SHIFT					0
#define RT2860_REG_PROT_MCS_MASK					0x7f

/*
 * RT2860_REG_RX_FILTER_CFG flags
 */
#define RT2860_REG_RX_FILTER_DROP_CTRL_RSV			(1 << 16)
#define RT2860_REG_RX_FILTER_DROP_BAR				(1 << 15)
#define RT2860_REG_RX_FILTER_DROP_BA				(1 << 14)
#define RT2860_REG_RX_FILTER_DROP_PSPOLL			(1 << 13)
#define RT2860_REG_RX_FILTER_DROP_RTS				(1 << 12)
#define RT2860_REG_RX_FILTER_DROP_CTS				(1 << 11)
#define RT2860_REG_RX_FILTER_DROP_ACK				(1 << 10)
#define RT2860_REG_RX_FILTER_DROP_CFEND				(1 << 9)
#define RT2860_REG_RX_FILTER_DROP_CFACK				(1 << 8)
#define RT2860_REG_RX_FILTER_DROP_DUPL				(1 << 7)
#define RT2860_REG_RX_FILTER_DROP_BCAST				(1 << 6)
#define RT2860_REG_RX_FILTER_DROP_MCAST				(1 << 5)
#define RT2860_REG_RX_FILTER_DROP_VER_ERR			(1 << 4)
#define RT2860_REG_RX_FILTER_DROP_NOT_MYBSS			(1 << 3)
#define RT2860_REG_RX_FILTER_DROP_UC_NOME			(1 << 2)
#define RT2860_REG_RX_FILTER_DROP_PHY_ERR			(1 << 1)
#define RT2860_REG_RX_FILTER_DROP_CRC_ERR			(1 << 0)

/*
 * RT2860_REG_AUTO_RSP_CFG flags
 */
#define RT2860_REG_CCK_SHORT_ENABLE					(1 << 4)

/*
 * RT2860_REG_TX_STA_FIFO flags
 */
#define RT2860_REG_TX_STA_FIFO_MCS_SHIFT			16
#define RT2860_REG_TX_STA_FIFO_MCS_MASK				0x7f
#define RT2860_REG_TX_STA_FIFO_WCID_SHIFT			8
#define RT2860_REG_TX_STA_FIFO_WCID_MASK			0xff
#define RT2860_REG_TX_STA_FIFO_PID_SHIFT			1
#define RT2860_REG_TX_STA_FIFO_PID_MASK				0xf
#define RT2860_REG_TX_STA_FIFO_ACK_REQ				(1 << 7)
#define RT2860_REG_TX_STA_FIFO_AGG					(1 << 6)
#define RT2860_REG_TX_STA_FIFO_TX_OK				(1 << 5)
#define RT2860_REG_TX_STA_FIFO_VALID				(1 << 0)

/*
 * RT2860_REG_WCID_ATTR flags
 */
#define RT2860_REG_VAP_SHIFT						4
#define RT2860_REG_VAP_MASK							0x7
#define RT2860_REG_CIPHER_MODE_SHIFT				1
#define RT2860_REG_CIPHER_MODE_MASK					0x7
#define RT2860_REG_CIPHER_MODE_NONE					0
#define RT2860_REG_CIPHER_MODE_WEP40				1
#define RT2860_REG_CIPHER_MODE_WEP104				2
#define RT2860_REG_CIPHER_MODE_TKIP					3
#define RT2860_REG_CIPHER_MODE_AES_CCMP				4
#define RT2860_REG_CIPHER_MODE_CKIP40				5
#define RT2860_REG_CIPHER_MODE_CKIP104				6
#define RT2860_REG_CIPHER_MODE_CKIP128				7
#define RT2860_REG_PKEY_ENABLE						(1 << 0)

/*
 * RT2860_REG_H2M_MAILBOX flags
 */
#define RT2860_REG_H2M_BUSY							(1 << 24)
#define RT2860_REG_H2M_TOKEN_POWERSAVE				1
#define RT2860_REG_H2M_TOKEN_RADIOOFF				2
#define RT2860_REG_H2M_TOKEN_WAKEUP					3
#define RT2860_REG_H2M_TOKEN_NO_INTR				0xff

/*
 * RT2860_REG_H2M_MAILBOX_CID flags
 */
#define RT2860_REG_H2M_CID0_SHIFT					0
#define RT2860_REG_H2M_CID1_SHIFT					8
#define RT2860_REG_H2M_CID2_SHIFT					16
#define RT2860_REG_H2M_CID3_SHIFT					24
#define RT2860_REG_H2M_CID_MASK						0xff

#endif /* #ifndef _RT2860_REG_H_ */
