/*	$Id: utf-support.h 364 2005-06-24 16:55:00Z tappe $
	
	Copyright 1996, 1997, 1998, 2002
	        Hekkelman Programmatuur B.V.  All rights reserved.
	
	Redistribution and use in source and binary forms, with or without
	modification, are permitted provided that the following conditions are met:
	1. Redistributions of source code must retain the above copyright notice,
	   this list of conditions and the following disclaimer.
	2. Redistributions in binary form must reproduce the above copyright notice,
	   this list of conditions and the following disclaimer in the documentation
	   and/or other materials provided with the distribution.
	3. All advertising materials mentioning features or use of this software
	   must display the following acknowledgement:
	   
	    This product includes software developed by Hekkelman Programmatuur B.V.
	
	4. The name of Hekkelman Programmatuur B.V. may not be used to endorse or
	   promote products derived from this software without specific prior
	   written permission.
	
	THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES,
	INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
	FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
	AUTHORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
	EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
	PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
	OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
	WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
	OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
	ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 	
*/

#ifndef UTF_SUPPORT_H
#define UTF_SUPPORT_H

int mstrlen(const char *s);
void mstrcpy(char *dst, const char *src, int count);
int mcharlen(const char *s);
char *moffset(char *s, int count);
int municode(const char *s);
int mprevcharlen(const char *s);
bool isalpha_uc(int unicode);
bool isnum_uc(int unicode);
bool isalnum_uc(int unicode);
bool isspace_uc(int unicode);
int maptounicode(int charset, char ch);
int mclass(int unicode);


class CEncodingRoster {
public:
	static const char* EncodingNameByIdx(int encoding);
	static bool IsSupportedEncoding(int encoding);
private:
	static const int sfMaxSupportedEncoding;
};

class CTextEncodingConverter {
public:
	CTextEncodingConverter();
	CTextEncodingConverter(int encoding);
	~CTextEncodingConverter();
	//
	status_t SetTo(int encoding);
	status_t ConvertToUtf8(BString& docText);
	status_t ConvertFromUtf8(BString& docText);
	//
	int Encoding() const;
	bool HadToSubstitute() const;
	int ErrorPos() const;
	status_t InitCheck() const;
private:
	void _Init(int encoding);
	void _Cleanup();
	void _CheckUtf8(const BString& docText);
	status_t _DoConversion(const char* text, int size, char*& outText, 
						   int& outSize, int charset, bool toUtf8);

	status_t fStatus;
	int fEncoding;
	char* fConvertedText;
	int fConvertedSize;
	int fErrorPos;
};

void InitUTFTables();

#endif // UTF_SUPPORT_H
