/*
	$Id: PropertyTestcase.cpp 10130 2004-11-21 21:03:29Z shatty $
	
	This file implements the first test for the OpenBeOS BPropertyInfo code.
	It tests the Construction use cases.  It does so by doing the following:
	
	*/


#include "PropertyTestcase.h"
#include <AppDefs.h>
#include <Message.h>


/* The following constants define unique values (values which are not used
   in the BPropertyInfo instances constructed) and common values (values
   which are likely to match in BPropertyInfo instances).  The wildcard
   tests list commands or specifiers to check for when a particular property
   has a command or specifier wildcard. */

const char *PropertyTestcase::uniquePropName = "no match!";
const uint32 PropertyTestcase::uniqueCommand = 11;
const uint32 PropertyTestcase::uniqueSpecifier = 11;
const char *PropertyTestcase::commonPropName = "test1";
const uint32 PropertyTestcase::commonCommand = B_GET_PROPERTY;
const uint32 PropertyTestcase::commonSpecifier = B_DIRECT_SPECIFIER;
const uint32 PropertyTestcase::wildcardCommandTests[] = { uniqueCommand,
                                                          commonCommand,
                                                          0};
const uint32 PropertyTestcase::wildcardSpecifierTests[] = { uniqueSpecifier, 
                                                            commonSpecifier,
                                                            0};
	

/*
 *  Method:  PropertyTestcase::PropertyTestcase()
 *   Descr:  This is the constructor for this class.
 */
		

	PropertyTestcase::PropertyTestcase(std::string name) :
		TestCase(name)
{
	}


/*
 *  Method:  PropertyTestcase::~PropertyTestcase()
 *   Descr:  This is the destructor for this class.
 */
 

	PropertyTestcase::~PropertyTestcase()
{
	}


/*
 *  Method:  PropertyTestcase::DuplicateProperties()
 *   Descr:  This member function returns a pointer to a malloc()'d
 *           property_info structure which is a copy of the one passed
 *           in.
 */	


	property_info *PropertyTestcase::DuplicateProperties(
	    const property_info *prop1,
	    int prop_count)
{
	int i, j, k;
	
	property_info *prop2 = NULL;
	if (prop1 != NULL) {
		prop2 = (property_info *) malloc(sizeof(property_info) * (prop_count + 1));
		memcpy(prop2, prop1, sizeof(property_info) * (prop_count + 1));
		for(i = 0; i < prop_count; i++) {
			if (prop1[i].name != NULL) {
				prop2[i].name = strdup(prop1[i].name);
			}
			if (prop1[i].usage != NULL) {
				prop2[i].usage = strdup(prop1[i].usage);
			}
			for(j = 0; j < 3; j++) {
				for(k = 0; k < 5; k++) {
					if (prop1[i].ctypes[j].pairs[k].name == NULL) {
						break;
					} else {
						prop2[i].ctypes[j].pairs[k].name =
						    strdup(prop1[i].ctypes[j].pairs[k].name);
					}
				}
				if (prop1[i].ctypes[j].pairs[0].name == NULL) {
					break;
				}
			}
		}
	}
	return(prop2);
}


/*
 *  Method:  PropertyTestcase::DuplicateValues()
 *   Descr:  This member function returns a pointer to a malloc()'d
 *           value_info structure which is a copy of the one passed
 *           in.
 */	


	value_info *PropertyTestcase::DuplicateValues(
	    const value_info *value1,
	    int value_count)
{
	int i;
	
	value_info *value2 = NULL;
	if (value1 != NULL) {
		value2 = (value_info *) malloc(sizeof(value_info) * (value_count + 1));
		memcpy(value2, value1, sizeof(value_info) * (value_count + 1));
		for(i = 0; i < value_count; i++) {
			if (value1[i].name != NULL) {
				value2[i].name = strdup(value1[i].name);
			}
			if (value1[i].usage != NULL) {
				value2[i].usage = strdup(value1[i].usage);
			}
		}
	}
	return(value2);
}
	
	
/*
 *  Method:  PropertyTestcase::PerformTest()
 *   Descr:  This member function creates 36 different BPropertyInfo
 *           instances and then passes each of them to TestProperty().
 *           The actual instances are:
 *                 - NULL property_info, NULL value_info
 *                 - NULL property_info, empty value_info
 *                 - NULL property_info, sample value_info
 *                 - empty property_info, NULL value_info
 *                 - empty property_info, empty value_info
 *                 - empty property_info, sample value_info
 *                 - sample property_info, NULL value_info
 *                 - sample property_info, empty value_info
 *                 - sample property_info, sample value_info
 *            Each of these are created in four different ways:
 *                 - one where each structure is statically allocated
 *                 - one where each structure is dynamically allocated
 *                 - one where the BPropertyInfo is unflattened from little
 *                   endian data (generated from BeOS R5 running on Intel)
 *                 - one where the BPropertyInfo is unflattened from big
 *                   endian data (generated from BeOS R5 running on a BeBox)
 *            This results in 36 different combinations to perform tests
 *            on.
 */


	void PropertyTestcase::PerformTest(void)
{
	typedef struct property_tests {
		struct property_info *props;
		struct value_info *values;
		int prop_count;
		int value_count;
		int flat_size;
		char lflat_data[768];
		char bflat_data[768];
	} property_tests;
	
	struct property_info prop1[] = { { 0 } };
	struct property_info prop2[] = {
		{ "test1", {B_GET_PROPERTY, B_SET_PROPERTY, B_EXECUTE_PROPERTY,
		            B_DELETE_PROPERTY, B_CREATE_PROPERTY, B_COUNT_PROPERTIES, 7,
		            8, 9, 10},
		           {B_DIRECT_SPECIFIER, B_NAME_SPECIFIER, B_ID_SPECIFIER,
		            B_INDEX_SPECIFIER, B_REVERSE_INDEX_SPECIFIER,
		            B_RANGE_SPECIFIER, B_REVERSE_RANGE_SPECIFIER, 8, 9, 10},
		           "test1: Test maximum property_info",
		           0,
		           {1, 2, 3, 4, 5, 6, 7, 8, 9, 10},
		           {
		            { { {"ctype11", 11}, {"ctype12", 12}, {"ctype13", 13},
		                {"ctype14", 14}, {"ctype15", 15} } },
		            { { {"ctype21", 21}, {"ctype22", 22}, {"ctype23", 23},
		                {"ctype24", 24}, {"ctype25", 25} } },
		            { { {"ctype31", 31}, {"ctype32", 32}, {"ctype33", 33},
		                {"ctype34", 34}, {"ctype35", 35} } } }
		  },
		{ "test2", {0, B_GET_PROPERTY},
		           {B_DIRECT_SPECIFIER, 0},
		           "test2: Test wildcard command",
		           1},
		{ "test3", {B_GET_PROPERTY, 0},
		           {0, B_DIRECT_SPECIFIER},
		           "test3: Test wildcard specifier",
		           2},
		{ "test4", {0, B_GET_PROPERTY},
		           {0, B_DIRECT_SPECIFIER},
		           "test4: Test wildcard command and specifier",
		           3},
        { 0 } // terminate list
    };
    
	struct value_info value1[] = { { 0 } };
	struct value_info value2[] = {
		{ "Value1", 5, B_COMMAND_KIND, "This is the usage", 0 },
		{ "Value2", 6, B_TYPE_CODE_KIND, "This is the usage", 1 },
		{ 0 } // terminate list
	};
	
	static property_tests theTests[] = {
		{ NULL, NULL, 0, 0, 9,
			{0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0},
			{0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1}
		},
		{ NULL, value1, 0, 0, 11,
			{0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0},
			{0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0}
		},
		{ NULL, value2, 0, 2, 85,
			{0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0,
			 0x0, 0x0, 0x5, 0x0, 0x0, 0x0, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x31,
			 0x0, 0x54, 0x68, 0x69, 0x73, 0x20, 0x69, 0x73, 0x20, 0x74, 0x68,
			 0x65, 0x20, 0x75, 0x73, 0x61, 0x67, 0x65, 0x0, 0x0, 0x0, 0x0, 0x0,
			 0x1, 0x0, 0x0, 0x0, 0x6, 0x0, 0x0, 0x0, 0x56, 0x61, 0x6c, 0x75,
			 0x65, 0x32, 0x0, 0x54, 0x68, 0x69, 0x73, 0x20, 0x69, 0x73, 0x20,
			 0x74, 0x68, 0x65, 0x20, 0x75, 0x73, 0x61, 0x67, 0x65, 0x0, 0x1,
			 0x0, 0x0, 0x0},
			{0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 0x2, 0x0, 0x0,
			 0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x31,
			 0x0, 0x54, 0x68, 0x69, 0x73, 0x20, 0x69, 0x73, 0x20, 0x74, 0x68,
			 0x65, 0x20, 0x75, 0x73, 0x61, 0x67, 0x65, 0x0, 0x0, 0x0, 0x0, 0x0,
			 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x6, 0x56, 0x61, 0x6c, 0x75,
			 0x65, 0x32, 0x0, 0x54, 0x68, 0x69, 0x73, 0x20, 0x69, 0x73, 0x20,
			 0x74, 0x68, 0x65, 0x20, 0x75, 0x73, 0x61, 0x67, 0x65, 0x0, 0x0,
			 0x0, 0x0, 0x1}
		},
		{ prop1, NULL, 0, 0, 9,
			{0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0},
			{0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1}
		},
		{ prop1, value1, 0, 0, 11,
			{0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0},
			{0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0}
		},
		{ prop1, value2, 0, 2, 85,
			{0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0,
			 0x0, 0x0, 0x5, 0x0, 0x0, 0x0, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x31,
			 0x0, 0x54, 0x68, 0x69, 0x73, 0x20, 0x69, 0x73, 0x20, 0x74, 0x68,
			 0x65, 0x20, 0x75, 0x73, 0x61, 0x67, 0x65, 0x0, 0x0, 0x0, 0x0, 0x0,
			 0x1, 0x0, 0x0, 0x0, 0x6, 0x0, 0x0, 0x0, 0x56, 0x61, 0x6c, 0x75,
			 0x65, 0x32, 0x0, 0x54, 0x68, 0x69, 0x73, 0x20, 0x69, 0x73, 0x20,
			 0x74, 0x68, 0x65, 0x20, 0x75, 0x73, 0x61, 0x67, 0x65, 0x0, 0x1,
			 0x0, 0x0, 0x0},
			{0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 0x2, 0x0, 0x0,
			0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x31,
			0x0, 0x54, 0x68, 0x69, 0x73, 0x20, 0x69, 0x73, 0x20, 0x74, 0x68,
			0x65, 0x20, 0x75, 0x73, 0x61, 0x67, 0x65, 0x0, 0x0, 0x0, 0x0, 0x0,
			0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x6, 0x56, 0x61, 0x6c, 0x75,
			0x65, 0x32, 0x0, 0x54, 0x68, 0x69, 0x73, 0x20, 0x69, 0x73, 0x20,
			0x74, 0x68, 0x65, 0x20, 0x75, 0x73, 0x61, 0x67, 0x65, 0x0, 0x0,
			0x0, 0x0, 0x1}
		},
		{ prop2, NULL, 4, 0, 570,
			{0x0, 0x4, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x74, 0x65, 0x73,
			 0x74, 0x31, 0x0, 0x74, 0x65, 0x73, 0x74, 0x31, 0x3a, 0x20, 0x54,
			 0x65, 0x73, 0x74, 0x20, 0x6d, 0x61, 0x78, 0x69, 0x6d, 0x75, 0x6d,
			 0x20, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x5f, 0x69,
			 0x6e, 0x66, 0x6f, 0x0, 0x0, 0x0, 0x0, 0x0, 0x54, 0x45, 0x47, 0x50,
			 0x54, 0x45, 0x53, 0x50, 0x45, 0x58, 0x45, 0x50, 0x4c, 0x45, 0x44,
			 0x50, 0x54, 0x52, 0x43, 0x50, 0x54, 0x4e, 0x43, 0x50, 0x7, 0x0,
			 0x0, 0x0, 0x8, 0x0, 0x0, 0x0, 0x9, 0x0, 0x0, 0x0, 0xa, 0x0, 0x0,
			 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x6, 0x0, 0x0, 0x0,
			 0x7, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x4,
			 0x0, 0x0, 0x0, 0x5, 0x0, 0x0, 0x0, 0x8, 0x0, 0x0, 0x0, 0x9, 0x0,
			 0x0, 0x0, 0xa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x74, 0x65,
			 0x73, 0x74, 0x32, 0x0, 0x74, 0x65, 0x73, 0x74, 0x32, 0x3a, 0x20,
			 0x54, 0x65, 0x73, 0x74, 0x20, 0x77, 0x69, 0x6c, 0x64, 0x63, 0x61,
			 0x72, 0x64, 0x20, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x0,
			 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0,
			 0x0, 0x0, 0x0, 0x74, 0x65, 0x73, 0x74, 0x33, 0x0, 0x74, 0x65, 0x73,
			 0x74, 0x33, 0x3a, 0x20, 0x54, 0x65, 0x73, 0x74, 0x20, 0x77, 0x69,
			 0x6c, 0x64, 0x63, 0x61, 0x72, 0x64, 0x20, 0x73, 0x70, 0x65, 0x63,
			 0x69, 0x66, 0x69, 0x65, 0x72, 0x0, 0x2, 0x0, 0x0, 0x0, 0x54, 0x45,
			 0x47, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x74, 0x65,
			 0x73, 0x74, 0x34, 0x0, 0x74, 0x65, 0x73, 0x74, 0x34, 0x3a, 0x20,
			 0x54, 0x65, 0x73, 0x74, 0x20, 0x77, 0x69, 0x6c, 0x64, 0x63, 0x61,
			 0x72, 0x64, 0x20, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x20,
			 0x61, 0x6e, 0x64, 0x20, 0x73, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69,
			 0x65, 0x72, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
			 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0,
			 0x0, 0x4, 0x0, 0x0, 0x0, 0x5, 0x0, 0x0, 0x0, 0x6, 0x0, 0x0, 0x0,
			 0x7, 0x0, 0x0, 0x0, 0x8, 0x0, 0x0, 0x0, 0x9, 0x0, 0x0, 0x0, 0xa,
			 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x63, 0x74, 0x79, 0x70, 0x65,
			 0x31, 0x31, 0x0, 0xb, 0x0, 0x0, 0x0, 0x63, 0x74, 0x79, 0x70, 0x65,
			 0x31, 0x32, 0x0, 0xc, 0x0, 0x0, 0x0, 0x63, 0x74, 0x79, 0x70, 0x65,
			 0x31, 0x33, 0x0, 0xd, 0x0, 0x0, 0x0, 0x63, 0x74, 0x79, 0x70, 0x65,
			 0x31, 0x34, 0x0, 0xe, 0x0, 0x0, 0x0, 0x63, 0x74, 0x79, 0x70, 0x65,
			 0x31, 0x35, 0x0, 0xf, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x63,
			 0x74, 0x79, 0x70, 0x65, 0x32, 0x31, 0x0, 0x15, 0x0, 0x0, 0x0, 0x63,
			 0x74, 0x79, 0x70, 0x65, 0x32, 0x32, 0x0, 0x16, 0x0, 0x0, 0x0, 0x63,
			 0x74, 0x79, 0x70, 0x65, 0x32, 0x33, 0x0, 0x17, 0x0, 0x0, 0x0, 0x63,
			 0x74, 0x79, 0x70, 0x65, 0x32, 0x34, 0x0, 0x18, 0x0, 0x0, 0x0, 0x63,
			 0x74, 0x79, 0x70, 0x65, 0x32, 0x35, 0x0, 0x19, 0x0, 0x0, 0x0, 0x0,
			 0x0, 0x0, 0x0, 0x63, 0x74, 0x79, 0x70, 0x65, 0x33, 0x31, 0x0, 0x1f,
			 0x0, 0x0, 0x0, 0x63, 0x74, 0x79, 0x70, 0x65, 0x33, 0x32, 0x0, 0x20,
			 0x0, 0x0, 0x0, 0x63, 0x74, 0x79, 0x70, 0x65, 0x33, 0x33, 0x0, 0x21,
			 0x0, 0x0, 0x0, 0x63, 0x74, 0x79, 0x70, 0x65, 0x33, 0x34, 0x0, 0x22,
			 0x0, 0x0, 0x0, 0x63, 0x74, 0x79, 0x70, 0x65, 0x33, 0x35, 0x0, 0x23,
			 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
			 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
			 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
			{0x1, 0x0, 0x0, 0x0, 0x4, 0x0, 0x0, 0x0, 0x1, 0x74, 0x65, 0x73,
			 0x74, 0x31, 0x0, 0x74, 0x65, 0x73, 0x74, 0x31, 0x3a, 0x20, 0x54,
			 0x65, 0x73, 0x74, 0x20, 0x6d, 0x61, 0x78, 0x69, 0x6d, 0x75, 0x6d,
			 0x20, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x5f, 0x69,
			 0x6e, 0x66, 0x6f, 0x0, 0x0, 0x0, 0x0, 0x0, 0x50, 0x47, 0x45,
			 0x54, 0x50, 0x53, 0x45, 0x54, 0x50, 0x45, 0x58, 0x45, 0x50, 0x44,
			 0x45, 0x4c, 0x50, 0x43, 0x52, 0x54, 0x50, 0x43, 0x4e, 0x54, 0x0,
			 0x0, 0x0, 0x7, 0x0, 0x0, 0x0, 0x8, 0x0, 0x0, 0x0, 0x9, 0x0, 0x0,
			 0x0, 0xa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0,
			 0x6, 0x0, 0x0, 0x0, 0x7, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x3,
			 0x0, 0x0, 0x0, 0x4, 0x0, 0x0, 0x0, 0x5, 0x0, 0x0, 0x0, 0x8, 0x0,
			 0x0, 0x0, 0x9, 0x0, 0x0, 0x0, 0xa, 0x0, 0x0, 0x0, 0x0, 0x74,
			 0x65, 0x73, 0x74, 0x32, 0x0, 0x74, 0x65, 0x73, 0x74, 0x32, 0x3a,
			 0x20, 0x54, 0x65, 0x73, 0x74, 0x20, 0x77, 0x69, 0x6c, 0x64, 0x63,
			 0x61, 0x72, 0x64, 0x20, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64,
			 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1,
			 0x0, 0x0, 0x0, 0x0, 0x74, 0x65, 0x73, 0x74, 0x33, 0x0, 0x74,
			 0x65, 0x73, 0x74, 0x33, 0x3a, 0x20, 0x54, 0x65, 0x73, 0x74, 0x20,
			 0x77, 0x69, 0x6c, 0x64, 0x63, 0x61, 0x72, 0x64, 0x20, 0x73, 0x70,
			 0x65, 0x63, 0x69, 0x66, 0x69, 0x65, 0x72, 0x0, 0x0, 0x0, 0x0,
			 0x2, 0x50, 0x47, 0x45, 0x54, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
			 0x0, 0x74, 0x65, 0x73, 0x74, 0x34, 0x0, 0x74, 0x65, 0x73, 0x74,
			 0x34, 0x3a, 0x20, 0x54, 0x65, 0x73, 0x74, 0x20, 0x77, 0x69, 0x6c,
			 0x64, 0x63, 0x61, 0x72, 0x64, 0x20, 0x63, 0x6f, 0x6d, 0x6d, 0x61,
			 0x6e, 0x64, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x73, 0x70, 0x65, 0x63,
			 0x69, 0x66, 0x69, 0x65, 0x72, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0,
			 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0,
			 0x2, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x4, 0x0, 0x0, 0x0, 0x5,
			 0x0, 0x0, 0x0, 0x6, 0x0, 0x0, 0x0, 0x7, 0x0, 0x0, 0x0, 0x8, 0x0,
			 0x0, 0x0, 0x9, 0x0, 0x0, 0x0, 0xa, 0x0, 0x0, 0x0, 0x0, 0x63,
			 0x74, 0x79, 0x70, 0x65, 0x31, 0x31, 0x0, 0x0, 0x0, 0x0, 0xb,
			 0x63, 0x74, 0x79, 0x70, 0x65, 0x31, 0x32, 0x0, 0x0, 0x0, 0x0,
			 0xc, 0x63, 0x74, 0x79, 0x70, 0x65, 0x31, 0x33, 0x0, 0x0, 0x0,
			 0x0, 0xd, 0x63, 0x74, 0x79, 0x70, 0x65, 0x31, 0x34, 0x0, 0x0,
			 0x0, 0x0, 0xe, 0x63, 0x74, 0x79, 0x70, 0x65, 0x31, 0x35, 0x0,
			 0x0, 0x0, 0x0, 0xf, 0x0, 0x0, 0x0, 0x0, 0x63, 0x74, 0x79, 0x70,
			 0x65, 0x32, 0x31, 0x0, 0x0, 0x0, 0x0, 0x15, 0x63, 0x74, 0x79,
			 0x70, 0x65, 0x32, 0x32, 0x0, 0x0, 0x0, 0x0, 0x16, 0x63, 0x74,
			 0x79, 0x70, 0x65, 0x32, 0x33, 0x0, 0x0, 0x0, 0x0, 0x17, 0x63,
			 0x74, 0x79, 0x70, 0x65, 0x32, 0x34, 0x0, 0x0, 0x0, 0x0, 0x18,
			 0x63, 0x74, 0x79, 0x70, 0x65, 0x32, 0x35, 0x0, 0x0, 0x0, 0x0,
			 0x19, 0x0, 0x0, 0x0, 0x0, 0x63, 0x74, 0x79, 0x70, 0x65, 0x33,
			 0x31, 0x0, 0x0, 0x0, 0x0, 0x1f, 0x63, 0x74, 0x79, 0x70, 0x65,
			 0x33, 0x32, 0x0, 0x0, 0x0, 0x0, 0x20, 0x63, 0x74, 0x79, 0x70,
			 0x65, 0x33, 0x33, 0x0, 0x0, 0x0, 0x0, 0x21, 0x63, 0x74, 0x79,
			 0x70, 0x65, 0x33, 0x34, 0x0, 0x0, 0x0, 0x0, 0x22, 0x63, 0x74,
			 0x79, 0x70, 0x65, 0x33, 0x35, 0x0, 0x0, 0x0, 0x0, 0x23, 0x0,
			 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
			 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
			 0x0, 0x0, 0x0, 0x0, 0x0}
		},
		{ prop2, value1, 4, 0, 572,
			{0x0, 0x4, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x74, 0x65, 0x73, 0x74,
			 0x31, 0x0, 0x74, 0x65, 0x73, 0x74, 0x31, 0x3a, 0x20, 0x54, 0x65,
			 0x73, 0x74, 0x20, 0x6d, 0x61, 0x78, 0x69, 0x6d, 0x75, 0x6d, 0x20,
			 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x5f, 0x69, 0x6e,
			 0x66, 0x6f, 0x0, 0x0, 0x0, 0x0, 0x0, 0x54, 0x45, 0x47, 0x50, 0x54,
			 0x45, 0x53, 0x50, 0x45, 0x58, 0x45, 0x50, 0x4c, 0x45, 0x44, 0x50,
			 0x54, 0x52, 0x43, 0x50, 0x54, 0x4e, 0x43, 0x50, 0x7, 0x0, 0x0, 0x0,
			 0x8, 0x0, 0x0, 0x0, 0x9, 0x0, 0x0, 0x0, 0xa, 0x0, 0x0, 0x0, 0x0,
			 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x6, 0x0, 0x0, 0x0, 0x7, 0x0,
			 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x4, 0x0, 0x0,
			 0x0, 0x5, 0x0, 0x0, 0x0, 0x8, 0x0, 0x0, 0x0, 0x9, 0x0, 0x0, 0x0,
			 0xa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x74, 0x65, 0x73, 0x74,
			 0x32, 0x0, 0x74, 0x65, 0x73, 0x74, 0x32, 0x3a, 0x20, 0x54, 0x65,
			 0x73, 0x74, 0x20, 0x77, 0x69, 0x6c, 0x64, 0x63, 0x61, 0x72, 0x64,
			 0x20, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x0, 0x1, 0x0, 0x0,
			 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
			 0x74, 0x65, 0x73, 0x74, 0x33, 0x0, 0x74, 0x65, 0x73, 0x74, 0x33,
			 0x3a, 0x20, 0x54, 0x65, 0x73, 0x74, 0x20, 0x77, 0x69, 0x6c, 0x64,
			 0x63, 0x61, 0x72, 0x64, 0x20, 0x73, 0x70, 0x65, 0x63, 0x69, 0x66,
			 0x69, 0x65, 0x72, 0x0, 0x2, 0x0, 0x0, 0x0, 0x54, 0x45, 0x47, 0x50,
			 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x74, 0x65, 0x73, 0x74,
			 0x34, 0x0, 0x74, 0x65, 0x73, 0x74, 0x34, 0x3a, 0x20, 0x54, 0x65,
			 0x73, 0x74, 0x20, 0x77, 0x69, 0x6c, 0x64, 0x63, 0x61, 0x72, 0x64,
			 0x20, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x20, 0x61, 0x6e,
			 0x64, 0x20, 0x73, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x65, 0x72,
			 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
			 0x1, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x4,
			 0x0, 0x0, 0x0, 0x5, 0x0, 0x0, 0x0, 0x6, 0x0, 0x0, 0x0, 0x7, 0x0,
			 0x0, 0x0, 0x8, 0x0, 0x0, 0x0, 0x9, 0x0, 0x0, 0x0, 0xa, 0x0, 0x0,
			 0x0, 0x0, 0x0, 0x0, 0x0, 0x63, 0x74, 0x79, 0x70, 0x65, 0x31, 0x31,
			 0x0, 0xb, 0x0, 0x0, 0x0, 0x63, 0x74, 0x79, 0x70, 0x65, 0x31, 0x32,
			 0x0, 0xc, 0x0, 0x0, 0x0, 0x63, 0x74, 0x79, 0x70, 0x65, 0x31, 0x33,
			 0x0, 0xd, 0x0, 0x0, 0x0, 0x63, 0x74, 0x79, 0x70, 0x65, 0x31, 0x34,
			 0x0, 0xe, 0x0, 0x0, 0x0, 0x63, 0x74, 0x79, 0x70, 0x65, 0x31, 0x35,
			 0x0, 0xf, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x63, 0x74, 0x79, 0x70,
			 0x65, 0x32, 0x31, 0x0, 0x15, 0x0, 0x0, 0x0, 0x63, 0x74, 0x79, 0x70,
			 0x65, 0x32, 0x32, 0x0, 0x16, 0x0, 0x0, 0x0, 0x63, 0x74, 0x79, 0x70,
			 0x65, 0x32, 0x33, 0x0, 0x17, 0x0, 0x0, 0x0, 0x63, 0x74, 0x79, 0x70,
			 0x65, 0x32, 0x34, 0x0, 0x18, 0x0, 0x0, 0x0, 0x63, 0x74, 0x79, 0x70,
			 0x65, 0x32, 0x35, 0x0, 0x19, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
			 0x63, 0x74, 0x79, 0x70, 0x65, 0x33, 0x31, 0x0, 0x1f, 0x0, 0x0, 0x0,
			 0x63, 0x74, 0x79, 0x70, 0x65, 0x33, 0x32, 0x0, 0x20, 0x0, 0x0, 0x0,
			 0x63, 0x74, 0x79, 0x70, 0x65, 0x33, 0x33, 0x0, 0x21, 0x0, 0x0, 0x0,
			 0x63, 0x74, 0x79, 0x70, 0x65, 0x33, 0x34, 0x0, 0x22, 0x0, 0x0, 0x0,
			 0x63, 0x74, 0x79, 0x70, 0x65, 0x33, 0x35, 0x0, 0x23, 0x0, 0x0, 0x0,
			 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
			 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
			 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
			{0x1, 0x0, 0x0, 0x0, 0x4, 0x0, 0x0, 0x0, 0x3, 0x74, 0x65, 0x73,
			0x74, 0x31, 0x0, 0x74, 0x65, 0x73, 0x74, 0x31, 0x3a, 0x20, 0x54,
			0x65, 0x73, 0x74, 0x20, 0x6d, 0x61, 0x78, 0x69, 0x6d, 0x75, 0x6d,
			0x20, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x5f, 0x69,
			0x6e, 0x66, 0x6f, 0x0, 0x0, 0x0, 0x0, 0x0, 0x50, 0x47, 0x45, 0x54,
			0x50, 0x53, 0x45, 0x54, 0x50, 0x45, 0x58, 0x45, 0x50, 0x44, 0x45,
			0x4c, 0x50, 0x43, 0x52, 0x54, 0x50, 0x43, 0x4e, 0x54, 0x0, 0x0,
			0x0, 0x7, 0x0, 0x0, 0x0, 0x8, 0x0, 0x0, 0x0, 0x9, 0x0, 0x0, 0x0,
			0xa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x6,
			0x0, 0x0, 0x0, 0x7, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x3, 0x0,
			0x0, 0x0, 0x4, 0x0, 0x0, 0x0, 0x5, 0x0, 0x0, 0x0, 0x8, 0x0, 0x0,
			0x0, 0x9, 0x0, 0x0, 0x0, 0xa, 0x0, 0x0, 0x0, 0x0, 0x74, 0x65,
			0x73, 0x74, 0x32, 0x0, 0x74, 0x65, 0x73, 0x74, 0x32, 0x3a, 0x20,
			0x54, 0x65, 0x73, 0x74, 0x20, 0x77, 0x69, 0x6c, 0x64, 0x63, 0x61,
			0x72, 0x64, 0x20, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x0,
			0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0,
			0x0, 0x0, 0x0, 0x74, 0x65, 0x73, 0x74, 0x33, 0x0, 0x74, 0x65,
			0x73, 0x74, 0x33, 0x3a, 0x20, 0x54, 0x65, 0x73, 0x74, 0x20, 0x77,
			0x69, 0x6c, 0x64, 0x63, 0x61, 0x72, 0x64, 0x20, 0x73, 0x70, 0x65,
			0x63, 0x69, 0x66, 0x69, 0x65, 0x72, 0x0, 0x0, 0x0, 0x0, 0x2, 0x50,
			0x47, 0x45, 0x54, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x74,
			0x65, 0x73, 0x74, 0x34, 0x0, 0x74, 0x65, 0x73, 0x74, 0x34, 0x3a,
			0x20, 0x54, 0x65, 0x73, 0x74, 0x20, 0x77, 0x69, 0x6c, 0x64, 0x63,
			0x61, 0x72, 0x64, 0x20, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64,
			0x20, 0x61, 0x6e, 0x64, 0x20, 0x73, 0x70, 0x65, 0x63, 0x69, 0x66,
			0x69, 0x65, 0x72, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0,
			0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x2, 0x0,
			0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x4, 0x0, 0x0, 0x0, 0x5, 0x0, 0x0,
			0x0, 0x6, 0x0, 0x0, 0x0, 0x7, 0x0, 0x0, 0x0, 0x8, 0x0, 0x0, 0x0,
			0x9, 0x0, 0x0, 0x0, 0xa, 0x0, 0x0, 0x0, 0x0, 0x63, 0x74, 0x79,
			0x70, 0x65, 0x31, 0x31, 0x0, 0x0, 0x0, 0x0, 0xb, 0x63, 0x74, 0x79,
			0x70, 0x65, 0x31, 0x32, 0x0, 0x0, 0x0, 0x0, 0xc, 0x63, 0x74, 0x79,
			0x70, 0x65, 0x31, 0x33, 0x0, 0x0, 0x0, 0x0, 0xd, 0x63, 0x74, 0x79,
			0x70, 0x65, 0x31, 0x34, 0x0, 0x0, 0x0, 0x0, 0xe, 0x63, 0x74, 0x79,
			0x70, 0x65, 0x31, 0x35, 0x0, 0x0, 0x0, 0x0, 0xf, 0x0, 0x0, 0x0,
			0x0, 0x63, 0x74, 0x79, 0x70, 0x65, 0x32, 0x31, 0x0, 0x0, 0x0, 0x0,
			0x15, 0x63, 0x74, 0x79, 0x70, 0x65, 0x32, 0x32, 0x0, 0x0, 0x0,
			0x0, 0x16, 0x63, 0x74, 0x79, 0x70, 0x65, 0x32, 0x33, 0x0, 0x0,
			0x0, 0x0, 0x17, 0x63, 0x74, 0x79, 0x70, 0x65, 0x32, 0x34, 0x0,
			0x0, 0x0, 0x0, 0x18, 0x63, 0x74, 0x79, 0x70, 0x65, 0x32, 0x35,
			0x0, 0x0, 0x0, 0x0, 0x19, 0x0, 0x0, 0x0, 0x0, 0x63, 0x74, 0x79,
			0x70, 0x65, 0x33, 0x31, 0x0, 0x0, 0x0, 0x0, 0x1f, 0x63, 0x74,
			0x79, 0x70, 0x65, 0x33, 0x32, 0x0, 0x0, 0x0, 0x0, 0x20, 0x63,
			0x74, 0x79, 0x70, 0x65, 0x33, 0x33, 0x0, 0x0, 0x0, 0x0, 0x21,
			0x63, 0x74, 0x79, 0x70, 0x65, 0x33, 0x34, 0x0, 0x0, 0x0, 0x0,
			0x22, 0x63, 0x74, 0x79, 0x70, 0x65, 0x33, 0x35, 0x0, 0x0, 0x0,
			0x0, 0x23, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
			0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
			0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}
		},
		{ prop2, value2, 4, 2, 646,
			{0x0, 0x4, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x74, 0x65, 0x73, 0x74,
			 0x31, 0x0, 0x74, 0x65, 0x73, 0x74, 0x31, 0x3a, 0x20, 0x54, 0x65,
			 0x73, 0x74, 0x20, 0x6d, 0x61, 0x78, 0x69, 0x6d, 0x75, 0x6d, 0x20,
			 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x5f, 0x69, 0x6e,
			 0x66, 0x6f, 0x0, 0x0, 0x0, 0x0, 0x0, 0x54, 0x45, 0x47, 0x50, 0x54,
			 0x45, 0x53, 0x50, 0x45, 0x58, 0x45, 0x50, 0x4c, 0x45, 0x44, 0x50,
			 0x54, 0x52, 0x43, 0x50, 0x54, 0x4e, 0x43, 0x50, 0x7, 0x0, 0x0, 0x0,
			 0x8, 0x0, 0x0, 0x0, 0x9, 0x0, 0x0, 0x0, 0xa, 0x0, 0x0, 0x0, 0x0,
			 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x6, 0x0, 0x0, 0x0, 0x7, 0x0,
			 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x4, 0x0, 0x0,
			 0x0, 0x5, 0x0, 0x0, 0x0, 0x8, 0x0, 0x0, 0x0, 0x9, 0x0, 0x0, 0x0,
			 0xa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x74, 0x65, 0x73, 0x74,
			 0x32, 0x0, 0x74, 0x65, 0x73, 0x74, 0x32, 0x3a, 0x20, 0x54, 0x65,
			 0x73, 0x74, 0x20, 0x77, 0x69, 0x6c, 0x64, 0x63, 0x61, 0x72, 0x64,
			 0x20, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x0, 0x1, 0x0, 0x0,
			 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
			 0x74, 0x65, 0x73, 0x74, 0x33, 0x0, 0x74, 0x65, 0x73, 0x74, 0x33,
			 0x3a, 0x20, 0x54, 0x65, 0x73, 0x74, 0x20, 0x77, 0x69, 0x6c, 0x64,
			 0x63, 0x61, 0x72, 0x64, 0x20, 0x73, 0x70, 0x65, 0x63, 0x69, 0x66,
			 0x69, 0x65, 0x72, 0x0, 0x2, 0x0, 0x0, 0x0, 0x54, 0x45, 0x47, 0x50,
			 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x74, 0x65, 0x73, 0x74,
			 0x34, 0x0, 0x74, 0x65, 0x73, 0x74, 0x34, 0x3a, 0x20, 0x54, 0x65,
			 0x73, 0x74, 0x20, 0x77, 0x69, 0x6c, 0x64, 0x63, 0x61, 0x72, 0x64,
			 0x20, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x20, 0x61, 0x6e,
			 0x64, 0x20, 0x73, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x65, 0x72,
			 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
			 0x1, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x4,
			 0x0, 0x0, 0x0, 0x5, 0x0, 0x0, 0x0, 0x6, 0x0, 0x0, 0x0, 0x7, 0x0,
			 0x0, 0x0, 0x8, 0x0, 0x0, 0x0, 0x9, 0x0, 0x0, 0x0, 0xa, 0x0, 0x0,
			 0x0, 0x0, 0x0, 0x0, 0x0, 0x63, 0x74, 0x79, 0x70, 0x65, 0x31, 0x31,
			 0x0, 0xb, 0x0, 0x0, 0x0, 0x63, 0x74, 0x79, 0x70, 0x65, 0x31, 0x32,
			 0x0, 0xc, 0x0, 0x0, 0x0, 0x63, 0x74, 0x79, 0x70, 0x65, 0x31, 0x33,
			 0x0, 0xd, 0x0, 0x0, 0x0, 0x63, 0x74, 0x79, 0x70, 0x65, 0x31, 0x34,
			 0x0, 0xe, 0x0, 0x0, 0x0, 0x63, 0x74, 0x79, 0x70, 0x65, 0x31, 0x35,
			 0x0, 0xf, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x63, 0x74, 0x79, 0x70,
			 0x65, 0x32, 0x31, 0x0, 0x15, 0x0, 0x0, 0x0, 0x63, 0x74, 0x79, 0x70,
			 0x65, 0x32, 0x32, 0x0, 0x16, 0x0, 0x0, 0x0, 0x63, 0x74, 0x79, 0x70,
			 0x65, 0x32, 0x33, 0x0, 0x17, 0x0, 0x0, 0x0, 0x63, 0x74, 0x79, 0x70,
			 0x65, 0x32, 0x34, 0x0, 0x18, 0x0, 0x0, 0x0, 0x63, 0x74, 0x79, 0x70,
			 0x65, 0x32, 0x35, 0x0, 0x19, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
			 0x63, 0x74, 0x79, 0x70, 0x65, 0x33, 0x31, 0x0, 0x1f, 0x0, 0x0, 0x0,
			 0x63, 0x74, 0x79, 0x70, 0x65, 0x33, 0x32, 0x0, 0x20, 0x0, 0x0, 0x0,
			 0x63, 0x74, 0x79, 0x70, 0x65, 0x33, 0x33, 0x0, 0x21, 0x0, 0x0, 0x0,
			 0x63, 0x74, 0x79, 0x70, 0x65, 0x33, 0x34, 0x0, 0x22, 0x0, 0x0, 0x0,
			 0x63, 0x74, 0x79, 0x70, 0x65, 0x33, 0x35, 0x0, 0x23, 0x0, 0x0, 0x0,
			 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
			 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
			 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5,
			 0x0, 0x0, 0x0, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x31, 0x0, 0x54, 0x68,
			 0x69, 0x73, 0x20, 0x69, 0x73, 0x20, 0x74, 0x68, 0x65, 0x20, 0x75,
			 0x73, 0x61, 0x67, 0x65, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0,
			 0x6, 0x0, 0x0, 0x0, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x32, 0x0, 0x54,
			 0x68, 0x69, 0x73, 0x20, 0x69, 0x73, 0x20, 0x74, 0x68, 0x65, 0x20,
			 0x75, 0x73, 0x61, 0x67, 0x65, 0x0, 0x1, 0x0, 0x0, 0x0},
			{0x1, 0x0, 0x0, 0x0, 0x4, 0x0, 0x0, 0x0, 0x3, 0x74, 0x65, 0x73,
			0x74, 0x31, 0x0, 0x74, 0x65, 0x73, 0x74, 0x31, 0x3a, 0x20, 0x54,
			0x65, 0x73, 0x74, 0x20, 0x6d, 0x61, 0x78, 0x69, 0x6d, 0x75, 0x6d,
			0x20, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x5f, 0x69,
			0x6e, 0x66, 0x6f, 0x0, 0x0, 0x0, 0x0, 0x0, 0x50, 0x47, 0x45, 0x54,
			0x50, 0x53, 0x45, 0x54, 0x50, 0x45, 0x58, 0x45, 0x50, 0x44, 0x45,
			0x4c, 0x50, 0x43, 0x52, 0x54, 0x50, 0x43, 0x4e, 0x54, 0x0, 0x0,
			0x0, 0x7, 0x0, 0x0, 0x0, 0x8, 0x0, 0x0, 0x0, 0x9, 0x0, 0x0, 0x0,
			0xa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x6,
			0x0, 0x0, 0x0, 0x7, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x3, 0x0,
			0x0, 0x0, 0x4, 0x0, 0x0, 0x0, 0x5, 0x0, 0x0, 0x0, 0x8, 0x0, 0x0,
			0x0, 0x9, 0x0, 0x0, 0x0, 0xa, 0x0, 0x0, 0x0, 0x0, 0x74, 0x65,
			0x73, 0x74, 0x32, 0x0, 0x74, 0x65, 0x73, 0x74, 0x32, 0x3a, 0x20,
			0x54, 0x65, 0x73, 0x74, 0x20, 0x77, 0x69, 0x6c, 0x64, 0x63, 0x61,
			0x72, 0x64, 0x20, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x0,
			0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0,
			0x0, 0x0, 0x0, 0x74, 0x65, 0x73, 0x74, 0x33, 0x0, 0x74, 0x65,
			0x73, 0x74, 0x33, 0x3a, 0x20, 0x54, 0x65, 0x73, 0x74, 0x20, 0x77,
			0x69, 0x6c, 0x64, 0x63, 0x61, 0x72, 0x64, 0x20, 0x73, 0x70, 0x65,
			0x63, 0x69, 0x66, 0x69, 0x65, 0x72, 0x0, 0x0, 0x0, 0x0, 0x2, 0x50,
			0x47, 0x45, 0x54, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x74,
			0x65, 0x73, 0x74, 0x34, 0x0, 0x74, 0x65, 0x73, 0x74, 0x34, 0x3a,
			0x20, 0x54, 0x65, 0x73, 0x74, 0x20, 0x77, 0x69, 0x6c, 0x64, 0x63,
			0x61, 0x72, 0x64, 0x20, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64,
			0x20, 0x61, 0x6e, 0x64, 0x20, 0x73, 0x70, 0x65, 0x63, 0x69, 0x66,
			0x69, 0x65, 0x72, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0,
			0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x2, 0x0,
			0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x4, 0x0, 0x0, 0x0, 0x5, 0x0, 0x0,
			0x0, 0x6, 0x0, 0x0, 0x0, 0x7, 0x0, 0x0, 0x0, 0x8, 0x0, 0x0, 0x0,
			0x9, 0x0, 0x0, 0x0, 0xa, 0x0, 0x0, 0x0, 0x0, 0x63, 0x74, 0x79,
			0x70, 0x65, 0x31, 0x31, 0x0, 0x0, 0x0, 0x0, 0xb, 0x63, 0x74, 0x79,
			0x70, 0x65, 0x31, 0x32, 0x0, 0x0, 0x0, 0x0, 0xc, 0x63, 0x74, 0x79,
			0x70, 0x65, 0x31, 0x33, 0x0, 0x0, 0x0, 0x0, 0xd, 0x63, 0x74, 0x79,
			0x70, 0x65, 0x31, 0x34, 0x0, 0x0, 0x0, 0x0, 0xe, 0x63, 0x74, 0x79,
			0x70, 0x65, 0x31, 0x35, 0x0, 0x0, 0x0, 0x0, 0xf, 0x0, 0x0, 0x0,
			0x0, 0x63, 0x74, 0x79, 0x70, 0x65, 0x32, 0x31, 0x0, 0x0, 0x0, 0x0,
			0x15, 0x63, 0x74, 0x79, 0x70, 0x65, 0x32, 0x32, 0x0, 0x0, 0x0,
			0x0, 0x16, 0x63, 0x74, 0x79, 0x70, 0x65, 0x32, 0x33, 0x0, 0x0,
			0x0, 0x0, 0x17, 0x63, 0x74, 0x79, 0x70, 0x65, 0x32, 0x34, 0x0,
			0x0, 0x0, 0x0, 0x18, 0x63, 0x74, 0x79, 0x70, 0x65, 0x32, 0x35,
			0x0, 0x0, 0x0, 0x0, 0x19, 0x0, 0x0, 0x0, 0x0, 0x63, 0x74, 0x79,
			0x70, 0x65, 0x33, 0x31, 0x0, 0x0, 0x0, 0x0, 0x1f, 0x63, 0x74,
			0x79, 0x70, 0x65, 0x33, 0x32, 0x0, 0x0, 0x0, 0x0, 0x20, 0x63,
			0x74, 0x79, 0x70, 0x65, 0x33, 0x33, 0x0, 0x0, 0x0, 0x0, 0x21,
			0x63, 0x74, 0x79, 0x70, 0x65, 0x33, 0x34, 0x0, 0x0, 0x0, 0x0,
			0x22, 0x63, 0x74, 0x79, 0x70, 0x65, 0x33, 0x35, 0x0, 0x0, 0x0,
			0x0, 0x23, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
			0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
			0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0,
			0x0, 0x0, 0x0, 0x0, 0x5, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x31, 0x0,
			0x54, 0x68, 0x69, 0x73, 0x20, 0x69, 0x73, 0x20, 0x74, 0x68, 0x65,
			0x20, 0x75, 0x73, 0x61, 0x67, 0x65, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
			0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x6, 0x56, 0x61, 0x6c, 0x75, 0x65,
			0x32, 0x0, 0x54, 0x68, 0x69, 0x73, 0x20, 0x69, 0x73, 0x20, 0x74,
			0x68, 0x65, 0x20, 0x75, 0x73, 0x61, 0x67, 0x65, 0x0, 0x0, 0x0,
			0x0, 0x1}
		}
	};
	int i;
	BPropertyInfo *propTest;
	property_info *propPtr;
	value_info *valuePtr;

	for (i=0; (unsigned)i < sizeof(theTests) / sizeof(theTests[0]); i++) {
		propTest = new BPropertyInfo(theTests[i].props, theTests[i].values);
		TestProperty(propTest, theTests[i].props, theTests[i].values,
					 theTests[i].prop_count, theTests[i].value_count,
				     theTests[i].flat_size, theTests[i].lflat_data,
				     theTests[i].bflat_data);
		delete propTest;
		
		propPtr = DuplicateProperties(theTests[i].props, theTests[i].prop_count);
		valuePtr = DuplicateValues(theTests[i].values, theTests[i].value_count);
		propTest = new BPropertyInfo(propPtr, valuePtr, true);
		TestProperty(propTest, theTests[i].props, theTests[i].values,
					 theTests[i].prop_count, theTests[i].value_count,
				     theTests[i].flat_size, theTests[i].lflat_data,
				     theTests[i].bflat_data);
		delete propTest;
		
		propTest = new BPropertyInfo;
		assert(propTest->Unflatten(B_PROPERTY_INFO_TYPE, theTests[i].lflat_data,
		                           theTests[i].flat_size) == B_OK);
		TestProperty(propTest, theTests[i].props, theTests[i].values,
					 theTests[i].prop_count, theTests[i].value_count,
				     theTests[i].flat_size, theTests[i].lflat_data,
				     theTests[i].bflat_data);
		delete propTest;
		
		propTest = new BPropertyInfo;
		assert(propTest->Unflatten(B_PROPERTY_INFO_TYPE, theTests[i].bflat_data,
		                           theTests[i].flat_size) == B_OK);
		TestProperty(propTest, theTests[i].props, theTests[i].values,
					 theTests[i].prop_count, theTests[i].value_count,
				     theTests[i].flat_size, theTests[i].lflat_data,
				     theTests[i].bflat_data);
		delete propTest;
	}
}
