// File:		MediaIconBits.h

#ifndef __MediaIconBits_H__
#define __MediaIconBits_H__

// ++++++++ the icons contained herein are:
//			( in order of appearance )
//
//	- M_GENERIC_ICON
//	- M_AUDIO_INPUT_ICON
//	- M_AUDIO_OUTPUT_ICON
//	- M_AUDIO_MIXER_ICON
//	- M_AUDIO_PRODUCER_ICON
//	- M_AUDIO_FILTER_ICON
//	- M_AUDIO_CONSUMER_ICON
//	- M_VIDEO_INPUT_ICON
//	- M_VIDEO_OUTPUT_ICON
//	- M_VIDEO_PRODUCER_ICON
//	- M_VIDEO_FILTER_ICON
//	- M_VIDEO_CONSUMER_ICON
//	- M_TIME_SOURCE_ICON
//	- M_FILE_READER_ICON
//	- M_FILE_WRITER_ICON

struct media_icon
{
	uchar large[1024];
	uchar small[256];
};

const media_icon M_GENERIC_ICON =
{
	{
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0e,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0e,0x1b,0x0e,
		0x0e,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0e,0x1b,0x1b,0x1b,
		0x1b,0x0e,0x0e,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0e,0x1b,0x1b,0x1b,0x1b,
		0x1b,0x1b,0x1b,0x0e,0x0e,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0e,0x1b,0x1b,0x1b,0x1b,0x1b,
		0x1b,0x1b,0x1b,0x1b,0x1b,0x0e,0x0e,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0e,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
		0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x0e,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0e,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
		0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x18,0x0e,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0e,0x3f,0x3f,0x1b,0x1b,0x1b,0x1b,0x1b,
		0x1b,0x1b,0x1b,0x1b,0x18,0x18,0x18,0x0e,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0e,0x1a,0x1a,0x3f,0x3f,0x1b,0x1b,0x1b,
		0x1b,0x1b,0x1b,0x18,0x18,0x18,0x18,0x0e,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0e,0x1a,0x1a,0x1a,0x1a,0x3f,0x3f,0x1b,
		0x1b,0x1b,0x18,0x18,0x18,0x18,0x18,0x0e,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0x0e,0xff,0x0e,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x3f,
		0x3f,0x18,0x18,0x18,0x18,0x18,0x18,0x0e,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0x0e,0x17,0x0e,0x0e,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
		0x1a,0x18,0x18,0x18,0x18,0x18,0x18,0x0e,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0x0e,0x17,0x17,0x17,0x0e,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
		0x1a,0x18,0x18,0x18,0x18,0x18,0x18,0x0e,0x0e,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0x0e,0x17,0x17,0x17,0x17,0x0e,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
		0x1a,0x18,0x18,0x18,0x18,0x18,0x18,0x0e,0x16,0x0e,0x0e,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0x0e,0x06,0x05,0x06,0x17,0x17,0x00,0x1a,0x1a,0x00,0x1a,0x1a,0x1a,0x1a,
		0x1a,0x18,0x18,0x18,0x18,0x18,0x18,0x0e,0x16,0x16,0x1a,0x0e,0x0e,0xff,0xff,0xff,
		0xff,0x0e,0x04,0x1e,0x1e,0x1e,0x05,0x06,0x00,0x1a,0x00,0x1a,0x1a,0x1a,0x1a,0x1a,
		0x1a,0x18,0x18,0x18,0x18,0x18,0x0e,0x16,0x16,0x1a,0x1a,0x1a,0x13,0x0e,0xff,0xff,
		0x0e,0x04,0x3f,0x3f,0x1e,0x1e,0x1e,0x1e,0x00,0x00,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
		0x1a,0x18,0x18,0x18,0x18,0x0e,0x16,0x16,0x1a,0x1a,0x1a,0x13,0x13,0x0e,0xff,0xff,
		0x0e,0x05,0x19,0x19,0x3f,0x3f,0x1e,0x1e,0x1e,0x06,0x06,0x00,0x1a,0x1a,0x1a,0x1a,
		0x1a,0x18,0x18,0x18,0x0e,0x16,0x16,0x1a,0x1a,0x1a,0x13,0x13,0x13,0x0e,0xff,0xff,
		0x0e,0x05,0x19,0xd5,0x0c,0x19,0x3f,0x3f,0x1e,0x1e,0x1e,0x01,0x0e,0x0e,0x1a,0x1a,
		0x1a,0x18,0x18,0x0e,0x16,0x16,0x1a,0x1a,0x1a,0x13,0x13,0x13,0x13,0x0e,0xff,0xff,
		0x0e,0x05,0x19,0xd5,0x60,0x0c,0x0a,0x19,0x3f,0x3f,0x16,0x01,0x15,0x15,0x0e,0x0e,
		0x1a,0x18,0x0e,0x3f,0x3f,0x1a,0x1a,0x1a,0x13,0x13,0x13,0x13,0x13,0x0e,0xff,0xff,
		0x0e,0x05,0x19,0xd5,0x60,0x60,0x86,0xd5,0x15,0x19,0x0f,0x03,0x03,0x04,0x0e,0x13,
		0x0e,0x0e,0x14,0x14,0x14,0x3f,0x3f,0x13,0x13,0x13,0x13,0x13,0x13,0x0e,0xff,0xff,
		0x0e,0x05,0x19,0xd5,0x60,0x60,0x86,0xd3,0x60,0x19,0x0f,0x04,0x1b,0x1b,0x04,0x03,
		0x13,0x13,0x14,0x14,0x14,0x14,0x14,0x13,0x13,0x13,0x13,0x13,0x13,0x0e,0xff,0xff,
		0x0e,0x05,0x19,0xd3,0x86,0x86,0x86,0x23,0x60,0x19,0x03,0x3f,0x3f,0x1b,0x1b,0x1b,
		0x04,0x14,0x14,0x14,0x14,0x14,0x14,0x13,0x13,0x13,0x13,0x13,0x13,0x0e,0xff,0xff,
		0x0e,0x00,0x19,0x19,0x1d,0x3f,0xd3,0xd3,0x60,0x19,0x04,0x1a,0x14,0x3f,0x3f,0x0f,
		0x04,0x14,0x14,0x14,0x14,0x14,0x14,0x13,0x13,0x13,0x13,0x13,0x13,0x0e,0xff,0xff,
		0x0e,0x16,0x02,0x02,0x19,0x19,0x3f,0x3f,0x60,0x19,0x04,0x1a,0x04,0x0d,0x1a,0x0f,
		0x04,0x14,0x14,0x14,0x14,0x14,0x14,0x13,0x13,0x13,0x13,0x13,0x13,0x0e,0x11,0xff,
		0x0e,0x16,0x16,0x16,0x02,0x02,0x19,0x1a,0x20,0x19,0x03,0x1a,0x0e,0x04,0x1a,0x0f,
		0x03,0x14,0x14,0x14,0x14,0x14,0x14,0x13,0x13,0x13,0x13,0x13,0x0e,0x11,0x11,0xff,
		0x0e,0x0e,0x16,0x16,0x16,0x16,0x02,0x02,0x19,0x2a,0x04,0x1a,0x1a,0x15,0x1a,0x0f,
		0x04,0x14,0x14,0x14,0x14,0x14,0x14,0x13,0x13,0x13,0x13,0x0e,0x11,0x11,0x11,0xff,
		0xff,0xff,0x0e,0x0e,0x16,0x16,0x16,0x16,0x02,0x05,0x04,0x1b,0x1a,0x1a,0x2b,0x0f,
		0x04,0x0e,0x14,0x14,0x14,0x14,0x14,0x13,0x13,0x13,0x0e,0x11,0x11,0x11,0x11,0xff,
		0xff,0xff,0xff,0xff,0x0e,0x0e,0x16,0x16,0x16,0x15,0x15,0x03,0x04,0x1a,0x1a,0x04,
		0x11,0x11,0x0e,0x0e,0x14,0x14,0x14,0x13,0x13,0x0e,0x11,0x11,0x11,0x11,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0x0e,0x0e,0x16,0x15,0x0e,0x11,0x00,0x04,0x04,0x11,
		0xff,0xff,0xff,0xff,0x0e,0x0e,0x14,0x13,0x0e,0x11,0x11,0x11,0x11,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0e,0x0e,0x11,0x11,0x11,0x11,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0x0e,0x0e,0x11,0x11,0x11,0xff,0xff,0xff,0xff,0xff
	},
	{
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0e,0x0e,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0x0e,0x1b,0x1b,0x0e,0x0e,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0x0e,0x1b,0x1b,0x1b,0x1b,0x1b,0x0e,0x0e,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0x0e,0x1f,0x1b,0x1b,0x1b,0x1b,0x1f,0x18,0x0e,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0x0e,0x1a,0x1f,0x1f,0x1b,0x1f,0x18,0x18,0x0e,0xff,0xff,0xff,
		0xff,0x00,0x01,0x0e,0x0e,0x1a,0x1a,0x1a,0x3f,0x18,0x18,0x18,0x0e,0xff,0xff,0xff,
		0x00,0x04,0x1c,0x05,0x04,0x1a,0x1a,0x1a,0x1a,0x18,0x18,0x18,0x0e,0x0e,0xff,0xff,
		0x00,0x3f,0x3f,0x1e,0x1e,0x06,0x04,0x1a,0x1a,0x18,0x18,0x18,0x0e,0x1a,0x0e,0x0e,
		0x00,0x19,0x86,0x18,0x3f,0x3f,0x17,0x05,0x1a,0x18,0x18,0x0e,0x1a,0x1f,0x13,0x0e,
		0x00,0x18,0xad,0xac,0x19,0x1a,0x0b,0x05,0x04,0x18,0x0e,0x1a,0x1f,0x13,0x13,0x0e,
		0x00,0x19,0xac,0xad,0x23,0x1c,0x0a,0x3f,0x1b,0x05,0x05,0x1f,0x13,0x13,0x13,0x0e,
		0x00,0x00,0x18,0x60,0x86,0x1c,0x07,0x13,0x3f,0x0f,0x05,0x14,0x13,0x13,0x13,0x0e,
		0x0e,0x16,0x04,0x00,0x22,0xc4,0x08,0x0a,0x12,0x0f,0x04,0x14,0x13,0x13,0x13,0x0e,
		0x0e,0x16,0x16,0x16,0x00,0x00,0x0b,0x11,0x82,0x0f,0x04,0x14,0x13,0x13,0x13,0x0e,
		0xff,0x0e,0x0e,0x16,0x16,0x16,0x04,0x04,0x11,0x05,0x0e,0x14,0x13,0x13,0x0e,0x11,
		0xff,0xff,0xff,0x0e,0x0e,0x0e,0x0e,0xff,0x00,0xff,0xff,0x0e,0x0e,0x0e,0x11,0x11
	}
};

const media_icon M_AUDIO_INPUT_ICON =
{
	{
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x3f,0x3f,0x3f,0x3f,
		0x3f,0x3f,0x3f,0x0f,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x09,0x09,0x09,0x12,
		0x19,0x19,0x19,0x19,0x15,0x15,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x3f,0x1c,0x1c,0x1c,0x19,
		0x12,0x09,0x09,0x09,0x15,0x0f,0x0f,0x0f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x09,0x09,0x09,0x0f,0x19,
		0x1c,0x1c,0x1c,0x17,0x05,0x05,0x0f,0x0f,0x0f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x3f,0x1c,0x1c,0x19,0x19,
		0x09,0x09,0x09,0x05,0x11,0x0f,0x05,0x0a,0x0f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x09,0x09,0x09,0x16,0x19,
		0x1c,0x1c,0x1c,0x17,0x05,0x05,0x0f,0x0f,0x0f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x3f,0x1c,0x1c,0x19,0x19,0x12,
		0x09,0x09,0x09,0x05,0x0f,0x0f,0x05,0x0e,0x0f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x09,0x09,0x09,0x12,0x19,0x1c,
		0x1c,0x1c,0x17,0x0f,0x05,0x05,0x0f,0x0f,0x0f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x3f,0x1c,0x1c,0x19,0x19,0x0c,
		0x09,0x09,0x05,0x05,0x0f,0x0f,0x05,0x0f,0x0f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x09,0x09,0x12,0x19,0x19,0x1c,
		0x1c,0x1c,0x17,0x0f,0x05,0x05,0x0d,0x0f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x3f,0x1c,0x1c,0x19,0x19,0x09,0x09,
		0x09,0x09,0x05,0x05,0x0f,0x0f,0x0a,0x0f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x09,0x09,0x0f,0x16,0x19,0x1c,0x1c,
		0x1c,0x17,0x0f,0x0f,0x05,0x05,0x0d,0x0f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x3f,0x1c,0x19,0x19,0x12,0x09,0x09,
		0x09,0x05,0x05,0x05,0x0f,0x0f,0x0f,0x0f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x09,0x09,0x12,0x19,0x19,0x1c,0x1c,
		0x1c,0x15,0x0f,0x0f,0x05,0x0a,0x0f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x19,0x19,0x19,0x19,0x09,0x09,0x09,
		0x09,0x05,0x05,0x05,0x0f,0x0f,0x0f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x19,0x19,0x19,0x19,0x09,0x09,0x09,
		0x09,0x05,0x05,0x05,0x0f,0x0f,0x0f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x19,0x19,0x19,0x19,0x19,0x19,
		0x19,0x0f,0x0f,0x0f,0x05,0x0d,0x0f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x0f,0x0f,0x0f,0x0f,
		0x0f,0x09,0x0f,0x0f,0x0f,0x0f,0x0f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x0f,0x0f,
		0x09,0x09,0x09,0x09,0x09,0x0f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x09,
		0x09,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x19,
		0x0f,0x09,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x19,
		0x0f,0x09,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x19,
		0x0f,0x09,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x0f,0x19,
		0x0f,0x09,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x3f,0x3f,0x0f,0x19,
		0x0f,0x09,0x00,0x09,0x09,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x3f,0x3f,0x3f,0x19,0x19,0x0f,0x19,
		0x0f,0x09,0x00,0x09,0x09,0x09,0x09,0x09,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x3f,0x3f,0x19,0x19,0x19,0x19,0x19,0x15,0x09,
		0x09,0x09,0x09,0x0f,0x0f,0x09,0x09,0x09,0x09,0x09,0x0f,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x15,0x15,0x1c,0x1c,0x1c,0x19,0x19,0x19,0x15,
		0x15,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x00,0x09,0x0f,0x0f,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x15,0x15,0x15,0x19,0x19,0x15,0x15,
		0x15,0x15,0x0f,0x0f,0x0f,0x09,0x09,0x09,0x00,0x09,0x0f,0x0f,0x0f,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x15,0x15,0x0f,0x0f,
		0x0f,0x0f,0x09,0x09,0x09,0x00,0x00,0x00,0x0f,0x0f,0x0f,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x0f,0x0f,0x0f,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,0xff
	},
	{
		0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0x00,0x3f,0x3f,0x3f,0x19,0x0f,0x00,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x0f,0x15,0x05,0x0f,0x0a,0x00,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0x00,0x3f,0x19,0x19,0x19,0x19,0x05,0x0e,0x00,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0x00,0x00,0x0f,0x15,0x09,0x05,0x0f,0x0f,0x00,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0x00,0x3f,0x3f,0x19,0x19,0x19,0x05,0x00,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0x00,0x00,0x19,0x15,0x05,0x05,0x0f,0x00,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0x00,0x19,0x0f,0x19,0x0f,0x0f,0x05,0x00,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0x00,0x19,0x19,0x19,0x19,0x0f,0x05,0x00,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x0f,0x09,0x00,0x00,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x19,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x19,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0x00,0x00,0x3f,0x19,0x09,0x00,0x00,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0x00,0x3f,0x3f,0x19,0x09,0x09,0x0f,0x00,0x00,0x0f,0xff,0xff,0xff,
		0xff,0xff,0xff,0x00,0x00,0x19,0x19,0x15,0x15,0x0f,0x00,0x00,0x0f,0x0f,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x0f,0x0f,0x0f,0xff,0xff,0xff
	}
};
	
const media_icon M_AUDIO_OUTPUT_ICON = 
{
	{
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x3f,0x1c,0x00,0x00,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x3f,0x1c,0x1c,0x1c,0x1c,
		0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x3f,0x1c,0x1c,0x1c,0x1c,0x1c,
		0x1c,0x1c,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x3f,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
		0x1c,0x1c,0x1c,0x1c,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x3f,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
		0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x3f,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
		0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x17,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x17,0x3f,0x3f,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
		0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x17,0x0f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x17,0x17,0x17,0x3f,0x3f,0x1c,0x1c,0x1c,0x1c,
		0x1c,0x1c,0x1c,0x1c,0x1c,0x17,0x0f,0x0f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x17,0x17,0x17,0x17,0x17,0x3f,0x3f,0x1d,0x1c,
		0x1c,0x1c,0x1c,0x1c,0x17,0x0f,0x0f,0x0f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x17,0x17,0x17,0x17,0x17,0x18,0x17,0x3f,0x3f,
		0x1c,0x1c,0x1c,0x17,0x0f,0x0f,0x0f,0x0f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x17,0x17,0x00,0x00,0x00,0x18,0x17,0x17,0x17,
		0x3f,0x3f,0x17,0x0f,0x0f,0x0f,0x0f,0x0f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x17,0x00,0x0b,0x0a,0x0b,0x00,0x00,0x17,0x17,
		0x17,0x14,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x17,0x00,0x08,0x0b,0x0b,0x0a,0x0b,0x00,0x17,
		0x17,0x14,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x17,0x00,0x0b,0x08,0x09,0x08,0x0b,0x08,0x11,
		0x17,0x14,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x17,0x00,0x0b,0x08,0x17,0x0f,0x0b,0x0f,0x08,
		0x17,0x14,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x17,0x00,0x0b,0x08,0x0f,0x0f,0x0a,0x0f,0x09,
		0x17,0x14,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x17,0x00,0x0b,0x0a,0x0b,0x0a,0x0f,0x0f,0x09,
		0x17,0x14,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x17,0x17,0x00,0x0b,0x11,0x0f,0x11,0x0f,0x08,
		0x17,0x14,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x17,0x17,0x11,0x09,0x0f,0x0f,0x0e,0x11,0x09,
		0x17,0x14,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x17,0x17,0x17,0x11,0x08,0x09,0x08,0x09,0x17,
		0x17,0x14,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,
		0x17,0x14,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x00,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,
		0x17,0x14,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x00,0x0f,0x0f,0x0f,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x17,0x17,0x17,0x17,0x17,0x17,0x2d,0xeb,0x17,
		0x17,0x14,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x00,0x0f,0x0f,0x0f,0x0f,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x17,0x17,0x17,0x17,0x2d,0x2b,0x17,
		0x17,0x14,0x0f,0x0f,0x0f,0x0f,0x0f,0x00,0x0f,0x0f,0x0f,0x0f,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x17,0x17,0x18,0x17,0x17,
		0x17,0x14,0x0f,0x0f,0x0f,0x0f,0x00,0x0f,0x0f,0x0f,0x0f,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x17,0x17,0x17,
		0x17,0x14,0x0f,0x0f,0x0f,0x00,0x0f,0x0f,0x0f,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x17,
		0x17,0x14,0x0f,0x0f,0x00,0x0f,0x0f,0x0f,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,
		0x00,0x14,0x0f,0x00,0x0f,0x0f,0x0f,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0x00,0x00,0x0f,0x0f,0x0f,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff
	},
	{
		0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0x00,0x3f,0x1c,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0x00,0x3f,0x1c,0x1c,0x1c,0x1c,0x00,0x00,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0x00,0x3f,0x3f,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x00,0xff,0xff,0xff,
		0xff,0xff,0xff,0x00,0x17,0x18,0x3f,0x3f,0x1c,0x1c,0x1c,0x17,0x00,0xff,0xff,0xff,
		0xff,0xff,0xff,0x00,0x17,0x17,0x18,0x18,0x3f,0x3f,0x17,0x0f,0x00,0xff,0xff,0xff,
		0xff,0xff,0xff,0x00,0x11,0x00,0x00,0x11,0x17,0x14,0x0f,0x0f,0x00,0xff,0xff,0xff,
		0xff,0xff,0xff,0x00,0x00,0x08,0x09,0x00,0x11,0x14,0x0f,0x0f,0x00,0xff,0xff,0xff,
		0xff,0xff,0xff,0x00,0x00,0x08,0x0f,0x0b,0x0b,0x14,0x0f,0x0f,0x00,0xff,0xff,0xff,
		0xff,0xff,0xff,0x00,0x11,0x00,0x0a,0x0b,0x0b,0x14,0x0f,0x0f,0x00,0xff,0xff,0xff,
		0xff,0xff,0xff,0x00,0x17,0x11,0x08,0x09,0x11,0x14,0x0f,0x0f,0x00,0xff,0xff,0xff,
		0xff,0xff,0xff,0x00,0x17,0x17,0x17,0x17,0x17,0x14,0x0f,0x0f,0x00,0x0f,0x0f,0xff,
		0xff,0xff,0xff,0x00,0x00,0x17,0x17,0xeb,0x17,0x14,0x0f,0x0f,0x00,0x0f,0x0f,0xff,
		0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x17,0x17,0x14,0x0f,0x00,0x0f,0x0f,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x14,0x00,0x0f,0x0f,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x0f,0x0f,0xff,0xff,0xff,0xff
	}
};
	
const media_icon M_AUDIO_MIXER_ICON =
{
	{
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x3f,0x00,0x00,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x3f,0x17,0x17,0x18,
		0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x3f,0x17,0x17,0x18,0x17,
		0x17,0x18,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x3f,0x17,0x3c,0x36,0x17,0x18,
		0x17,0x17,0x18,0x17,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x3f,0x17,0x17,0x18,0x17,0x31,0x2b,
		0x18,0x18,0x3f,0x16,0x18,0x17,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x3f,0x17,0x17,0x18,0x17,0x17,0x18,0x17,
		0x18,0x00,0x00,0x3f,0x0a,0x0b,0x17,0x18,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x3f,0x17,0x17,0x18,0x17,0x17,0x18,0x17,0x18,
		0x17,0x11,0x11,0x0b,0x3f,0x11,0x00,0x17,0x17,0x18,0x00,0x00,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0x00,0x3f,0x17,0x3c,0x36,0x17,0x18,0x17,0x17,0x18,0x17,
		0x18,0x17,0x0b,0x3f,0x11,0x00,0x00,0x3f,0x3f,0x17,0x17,0x18,0x00,0x00,0xff,0xff,
		0xff,0xff,0xff,0xff,0x00,0x3f,0x17,0x17,0x18,0x17,0x31,0x2b,0x18,0x18,0x3f,0x16,
		0x18,0x17,0x17,0x00,0x00,0x11,0x11,0x00,0x00,0x3f,0x17,0x17,0x18,0x0a,0x00,0xff,
		0xff,0xff,0xff,0x00,0x3f,0x17,0x17,0x18,0x17,0x17,0x18,0x17,0x18,0x00,0x00,0x3f,
		0x0a,0x0b,0x17,0x18,0x17,0x17,0x18,0x11,0x11,0x00,0x17,0x17,0x0b,0x0b,0x00,0xff,
		0xff,0xff,0x00,0x3f,0x17,0x17,0x18,0x17,0x17,0x18,0x17,0x18,0x17,0x11,0x11,0x0b,
		0x3f,0x11,0x00,0x17,0x17,0x18,0x17,0x17,0x18,0x17,0x18,0x0a,0x0b,0x0a,0x00,0xff,
		0xff,0x00,0x3f,0x17,0x3c,0x36,0x17,0x18,0x17,0x17,0x18,0x17,0x18,0x17,0x0b,0x3f,
		0x11,0x00,0x00,0x3f,0x3f,0x17,0x17,0x18,0x17,0x17,0x0b,0x0b,0x0a,0x00,0x00,0xff,
		0x00,0x3f,0x17,0x17,0x18,0x17,0x31,0x2b,0x18,0x18,0x3f,0x16,0x18,0x17,0x17,0x00,
		0x00,0x11,0x11,0x00,0x00,0x3f,0x17,0x17,0x18,0x0a,0x0b,0x0b,0x00,0x0a,0x00,0xff,
		0x00,0x3f,0x3f,0x17,0x17,0x18,0x17,0x17,0x18,0x00,0x00,0x3f,0x0a,0x0b,0x17,0x18,
		0x17,0x17,0x18,0x11,0x11,0x00,0x17,0x17,0x0b,0x0b,0x0a,0x00,0x0b,0x0b,0x00,0x0e,
		0x00,0x11,0x11,0x3f,0x3f,0x17,0x17,0x18,0x17,0x11,0x11,0x0b,0x3f,0x11,0x00,0x17,
		0x17,0x18,0x17,0x17,0x18,0x17,0x18,0x0a,0x0b,0x0a,0x00,0x0b,0x0b,0x0a,0x00,0x0f,
		0x00,0x11,0x11,0x11,0x11,0x3f,0x3f,0x17,0x17,0x18,0x0a,0x3f,0x11,0x00,0x00,0x3f,
		0x3f,0x17,0x17,0x18,0x17,0x17,0x0b,0x0b,0x0a,0x00,0x0b,0x0b,0x0a,0x00,0x0f,0x0f,
		0x00,0x11,0x11,0x11,0x11,0x11,0x11,0x3f,0x3f,0x17,0x17,0x00,0x00,0x11,0x11,0x00,
		0x00,0x3f,0x17,0x17,0x18,0x0a,0x0b,0x0b,0x00,0x0a,0x0b,0x0a,0x00,0x0f,0x0f,0x0f,
		0x00,0x00,0x00,0x11,0x11,0x11,0x11,0x11,0x11,0x3f,0x3f,0x17,0x17,0x18,0x17,0x11,
		0x11,0x00,0x17,0x18,0x0a,0x0b,0x0b,0x00,0x0a,0x0b,0x0b,0x00,0x0e,0x0f,0x0f,0xff,
		0x00,0x11,0x11,0x00,0x00,0x11,0x11,0x11,0x11,0x11,0x11,0x3f,0x3f,0x17,0x17,0x18,
		0x17,0x17,0x18,0x0a,0x0b,0x0b,0x00,0x0a,0x0b,0x0b,0x00,0x0e,0x0f,0x0f,0xff,0xff,
		0x00,0x11,0x11,0x11,0x11,0x00,0x00,0x11,0x11,0x11,0x11,0x11,0x11,0x3f,0x3f,0x17,
		0x17,0x18,0x0a,0x0b,0x0b,0x00,0x0a,0x0b,0x0a,0x00,0x0f,0x0f,0x0f,0xff,0xff,0xff,
		0x00,0x11,0x11,0x11,0x11,0x11,0x11,0x00,0x00,0x11,0x11,0x11,0x11,0x11,0x11,0x3f,
		0x17,0x0b,0x0a,0x0b,0x00,0x0a,0x0b,0x0b,0x00,0x0f,0x0e,0x0f,0xff,0xff,0xff,0xff,
		0xff,0x00,0x00,0x11,0x11,0x11,0x11,0x11,0x11,0x00,0x00,0x11,0x11,0x11,0x11,0x11,
		0x0a,0x0b,0x0a,0x00,0x0b,0x0b,0x0a,0x00,0x0f,0x0f,0x0f,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0x00,0x00,0x11,0x11,0x11,0x11,0x11,0x11,0x00,0x00,0x11,0x11,0x11,
		0x0a,0x0b,0x00,0x0a,0x0b,0x0b,0x00,0x0f,0x0e,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x11,0x11,0x11,0x11,0x11,0x11,0x00,0x00,0x11,
		0x0a,0x00,0x0b,0x0a,0x0b,0x00,0x0f,0x0f,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x11,0x11,0x11,0x11,0x11,0x11,0x00,
		0x00,0x0a,0x0b,0x0a,0x00,0x0f,0x0f,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x11,0x11,0x11,0x11,0x11,
		0x0a,0x0b,0x0a,0x00,0x0f,0x0f,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x11,0x11,0x11,
		0x0a,0x0b,0x00,0x0f,0x0f,0x0e,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x11,
		0x0a,0x00,0x0f,0x0f,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,
		0x00,0x0e,0x0f,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff
	},
	{
		0xff,0xff,0xff,0xff,0xff,0xff,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0x00,0x17,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0x00,0x17,0x17,0x18,0x3f,0x00,0x00,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0x00,0x17,0x17,0x31,0x18,0x00,0x3f,0x3f,0x00,0x00,0xff,0xff,0xff,
		0xff,0xff,0x00,0x17,0x17,0x18,0x3f,0x17,0x17,0x00,0x00,0x3f,0x3f,0x00,0x00,0xff,
		0xff,0x00,0x17,0x17,0x31,0x18,0x00,0x3f,0x3f,0x17,0x17,0x00,0x00,0x18,0x17,0x00,
		0x00,0x17,0x18,0x17,0x3f,0x17,0x17,0x00,0x00,0x3f,0x3f,0x17,0x17,0x18,0x0a,0x00,
		0x00,0x3f,0x31,0x17,0x00,0x3f,0x3f,0x17,0x17,0x00,0x00,0x18,0x17,0x0b,0x04,0x00,
		0x00,0x17,0x18,0x3f,0x3f,0x00,0x00,0x3f,0x3f,0x17,0x17,0x18,0x0a,0x05,0x0a,0x00,
		0x00,0x11,0x11,0x18,0x17,0x3f,0x3f,0x00,0x00,0x17,0x17,0x0b,0x04,0x0b,0x00,0x0f,
		0x00,0x04,0x04,0x11,0x11,0x18,0x17,0x3f,0x3f,0x17,0x0b,0x04,0x0a,0x00,0x0f,0xff,
		0x00,0x11,0x11,0x04,0x04,0x11,0x11,0x17,0x18,0x0a,0x05,0x0a,0x00,0x0f,0xff,0xff,
		0xff,0x00,0x00,0x11,0x11,0x04,0x04,0x11,0x0b,0x04,0x0b,0x00,0x0e,0xff,0xff,0xff,
		0xff,0xff,0xff,0x00,0x00,0x11,0x11,0x04,0x04,0x0b,0x00,0x0f,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x11,0x0a,0x00,0x0f,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x0e,0xff,0xff,0xff,0xff,0xff,0xff
	}
};

const media_icon M_AUDIO_PRODUCER_ICON =
{
	{
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x63,0x63,0x00,0x00,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x5c,0x5c,0x5c,0x63,0x63,0x00,
		0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x5c,0x5c,0x00,0x00,0x5c,0x63,
		0x63,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x3f,0x00,0x00,0x17,0x00,0x00,0x5c,
		0x5c,0x63,0x63,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x3f,0x3f,0x00,0x17,0x00,0x00,0x00,0x5c,
		0x5c,0x5c,0x5c,0x63,0x63,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x3f,0x3f,0x00,0x17,0x00,0x00,0x00,0x00,0x00,
		0x5c,0x5c,0x5c,0x00,0x00,0x63,0x63,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0x00,0x3f,0x3f,0x00,0x17,0x00,0x00,0x00,0x14,0x3f,0x00,
		0x00,0x00,0x00,0x17,0x00,0x00,0x5c,0x63,0x63,0x00,0x00,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0x00,0x3f,0x3f,0x00,0x17,0x00,0x00,0x00,0x14,0x3f,0x00,0x3f,
		0x3f,0x00,0x17,0x00,0x00,0x00,0x00,0x00,0x5c,0x63,0x63,0x00,0x00,0xff,0xff,0xff,
		0xff,0xff,0xff,0x00,0x3f,0x3f,0x00,0x3f,0x00,0x00,0x00,0x14,0x3f,0x00,0x3f,0x3f,
		0x00,0x17,0x00,0x00,0x00,0x00,0x17,0x00,0x00,0x5c,0x5c,0x63,0x63,0x00,0x00,0xff,
		0xff,0xff,0x00,0x3f,0x3f,0x3f,0x00,0x00,0x00,0x00,0x14,0x3f,0x00,0x3f,0x3f,0x00,
		0x17,0x00,0x00,0x00,0x00,0x17,0x00,0x00,0x00,0x5c,0x5c,0x5c,0x5c,0x63,0x00,0xff,
		0xff,0x00,0x3f,0x3f,0x3f,0x3f,0x00,0x3f,0x00,0x14,0x3f,0x00,0x3f,0x3f,0x00,0x17,
		0x00,0x00,0x00,0x00,0x17,0x00,0x00,0x00,0x00,0x00,0x5c,0x5c,0x5c,0x00,0x00,0xff,
		0x00,0x3f,0x3f,0x3f,0x3f,0x00,0x3f,0x3f,0x3f,0x3f,0x00,0x3f,0x3f,0x00,0x3f,0x00,
		0x00,0x00,0x00,0x17,0x00,0x00,0x00,0x14,0x3f,0x00,0x00,0x00,0x5c,0x00,0x00,0xff,
		0x00,0x3f,0x3f,0x3f,0x00,0x3f,0x3f,0x3f,0x3f,0x00,0x3f,0x3f,0x3f,0x00,0x00,0x00,
		0x00,0x00,0x17,0x00,0x00,0x00,0x14,0x3f,0x00,0x3f,0x3f,0x3f,0x00,0x63,0x00,0xff,
		0xff,0x00,0x00,0x00,0x3f,0x3f,0x3f,0x3f,0x00,0x3f,0x3f,0x3f,0x3f,0x00,0x3f,0x00,
		0x00,0x3f,0x00,0x00,0x00,0x14,0x3f,0x00,0x3f,0x3f,0x3f,0x3f,0x00,0x63,0x00,0xff,
		0xff,0x00,0x17,0x00,0x00,0x3f,0x3f,0x00,0x3f,0x3f,0x3f,0x3f,0x00,0x3f,0x3f,0x3f,
		0x00,0x00,0x00,0x00,0x14,0x3f,0x00,0x3f,0x3f,0x3f,0x3f,0x00,0x00,0x63,0x00,0x0f,
		0xff,0x00,0x1c,0x17,0x17,0x00,0x00,0x3f,0x3f,0x3f,0x3f,0x00,0x3f,0x3f,0x3f,0x3f,
		0x00,0x3f,0x00,0x14,0x3f,0x00,0x3f,0x3f,0x3f,0x3f,0x00,0x14,0x00,0x63,0x00,0x0f,
		0xff,0x00,0x00,0x1c,0x1c,0x17,0x17,0x00,0x00,0x3f,0x00,0x3f,0x3f,0x3f,0x3f,0x00,
		0x3f,0x3f,0x3f,0x3f,0x00,0x3f,0x3f,0x3f,0x3f,0x00,0x14,0x14,0x00,0x00,0x0f,0x0f,
		0xff,0xff,0xff,0x00,0x00,0x1c,0x1c,0x17,0x17,0x00,0x00,0x3f,0x3f,0x3f,0x00,0x3f,
		0x3f,0x3f,0x3f,0x00,0x3f,0x3f,0x3f,0x3f,0x00,0x14,0x14,0x14,0x00,0x0f,0x0f,0x0f,
		0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x1c,0x1c,0x17,0x17,0x00,0x00,0x00,0x3f,0x3f,
		0x3f,0x3f,0x00,0x3f,0x3f,0x3f,0x3f,0x00,0x14,0x14,0x14,0x00,0x0f,0x0f,0x0f,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x1c,0x1c,0x17,0x17,0x00,0x00,0x3f,
		0x3f,0x00,0x3f,0x3f,0x3f,0x3f,0x00,0x14,0x14,0x14,0x00,0x0f,0x0f,0x0f,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x1c,0x1c,0x17,0x17,0x00,
		0x00,0x3f,0x3f,0x3f,0x3f,0x00,0x14,0x14,0x14,0x00,0x0f,0x0f,0x0f,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x1c,0x1c,0x17,
		0x17,0x00,0x00,0x3f,0x00,0x14,0x14,0x14,0x00,0x0f,0x0f,0x0f,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x1c,
		0x1c,0x17,0x17,0x00,0x14,0x14,0x14,0x00,0x0f,0x0f,0x0f,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,
		0x00,0x1c,0x1c,0x17,0x14,0x14,0x00,0x0f,0x0f,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0x00,0x00,0x1c,0x14,0x00,0x0f,0x0f,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0x00,0x00,0x0f,0x0f,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff
	},
	{
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0x00,0x5c,0x5c,0x63,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0x00,0x3f,0x00,0x00,0x5c,0x5c,0x63,0x00,0x00,0xff,0xff,0xff,0xff,
		0xff,0xff,0x00,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x5c,0x63,0x00,0x00,0xff,0xff,
		0xff,0x00,0x3f,0x00,0x00,0x00,0x3f,0x00,0x00,0x00,0x00,0x5c,0x5c,0x63,0x00,0xff,
		0x00,0x3f,0x3f,0x00,0x00,0x3f,0x00,0x14,0x00,0x14,0x00,0x00,0x5c,0x5c,0x00,0xff,
		0x00,0x3f,0x00,0x3f,0x3f,0x00,0x14,0x00,0x14,0x00,0x00,0x3f,0x00,0x00,0x00,0xff,
		0x00,0x00,0x00,0x3f,0x00,0x3f,0x00,0x14,0x00,0x00,0x3f,0x00,0x3f,0x0f,0x00,0xff,
		0x00,0x17,0x17,0x00,0x00,0x00,0x3f,0x3f,0x00,0x3f,0x00,0x3f,0x3f,0x0f,0x00,0x0f,
		0xff,0x00,0x00,0x17,0x17,0x00,0x00,0x00,0x3f,0x00,0x3f,0x3f,0x00,0x0f,0x00,0x0f,
		0xff,0xff,0xff,0x00,0x00,0x17,0x17,0x00,0x00,0x3f,0x3f,0x00,0x14,0x00,0x0f,0xff,
		0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x17,0x17,0x00,0x00,0x14,0x00,0x0f,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x17,0x14,0x00,0x0f,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x0f,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff
	}
};

const media_icon M_AUDIO_FILTER_ICON =
{
	{
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0e,0x0e,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0e,0x5c,0x5c,
		0x0e,0x0e,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0e,0x5c,0xd8,0x3f,
		0x3f,0x5c,0x0e,0x0e,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0e,0x5c,0xd8,0x17,0x3f,
		0x17,0x00,0x5c,0x5c,0x0e,0x0e,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0e,0x5c,0xd8,0xd8,0x00,0x0e,
		0x0e,0x00,0xd8,0x3f,0x3f,0x5c,0x0e,0x0e,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0e,0xfb,0xfb,0xd8,0xd8,0x00,
		0x00,0xd8,0x17,0x3f,0x17,0x00,0x5c,0x5c,0x0e,0x0e,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0e,0x0e,0x5c,0x5c,0xfb,0xfb,0xd8,
		0xd8,0xd8,0x00,0x0e,0x0e,0x00,0xd8,0x3f,0x3f,0x5c,0x0e,0x0e,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0e,0x5c,0x5c,0x0e,0x0e,0x5c,0x5c,0xfb,
		0xfb,0xd8,0xd8,0x00,0x00,0xd8,0x17,0x3f,0x17,0x00,0x5c,0x5c,0x0e,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0e,0x5c,0xd8,0xd8,0x5c,0x5c,0x0e,0x0e,0x5c,
		0x5c,0xfb,0xfb,0xd8,0xd8,0xd8,0x00,0x0e,0x0e,0x00,0xd8,0xfb,0x3f,0x00,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0e,0x5c,0xd8,0xd8,0xd8,0xd8,0x5c,0x5c,0x0e,
		0x0e,0x5c,0x5c,0xfb,0xfb,0xd8,0xd8,0x00,0x00,0xd8,0xfb,0x3f,0x5c,0x00,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0x0e,0x5c,0xd8,0x0e,0x0e,0xd8,0xd8,0xd8,0x5c,0xda,
		0x7b,0x0e,0x0e,0x5c,0x5c,0xfb,0xfb,0xd8,0xd8,0xfb,0x3f,0x5c,0xa9,0x00,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0x0e,0x5c,0xd8,0x0e,0x00,0x00,0x0e,0x0e,0xd8,0x5c,0x7b,
		0x2a,0x5c,0x5c,0x0e,0x0e,0x5c,0x5c,0xfb,0xfb,0x3f,0x5c,0xa9,0xa9,0x00,0xff,0xff,
		0xff,0xff,0xff,0xff,0x0e,0x5c,0xd8,0x0e,0x00,0x0e,0x0e,0x00,0x00,0x0e,0x0e,0x5c,
		0x5c,0x5c,0xd8,0x5c,0x5c,0x0e,0x0e,0x5c,0x5c,0x5c,0xa9,0xa9,0xa9,0x00,0xff,0xff,
		0xff,0xff,0xff,0xff,0x0e,0x5c,0xd8,0x0e,0x00,0x00,0x00,0x0e,0x0e,0x00,0x00,0x0e,
		0x0e,0xd8,0xd8,0xd8,0xd8,0x5c,0x5c,0xa9,0x0e,0xa9,0x17,0x17,0xa9,0x00,0xff,0xff,
		0xff,0xff,0xff,0x0e,0x5c,0xd8,0x0e,0x00,0x0e,0x0e,0x00,0x00,0x00,0x0e,0x0e,0x00,
		0x00,0x0e,0x0e,0xd8,0xd8,0xd8,0xfb,0x0e,0xa9,0x3f,0x00,0x0e,0xa9,0x00,0xff,0xff,
		0xff,0xff,0x0e,0x5c,0xd8,0x0e,0x0e,0x00,0x00,0x00,0x0e,0x0e,0x00,0x00,0x00,0x0e,
		0x0e,0x00,0x00,0x0e,0xd8,0xfb,0x5c,0x0e,0xa9,0x17,0x00,0x0e,0xa9,0x00,0xff,0xff,
		0xff,0x00,0x5c,0xfb,0xfb,0xd8,0xd8,0x0e,0x0e,0x00,0x00,0x00,0x0e,0x0e,0x00,0x00,
		0x00,0x0e,0x00,0x0e,0xd8,0xfb,0x0e,0x09,0xa9,0x0e,0x0e,0xa9,0x00,0x0f,0x0f,0xff,
		0xff,0x00,0x5c,0x5c,0x5c,0xfb,0xfb,0xd8,0xd8,0x0e,0x0e,0x00,0x00,0x00,0x0e,0x0e,
		0x00,0x00,0x0e,0xd8,0xfb,0x5c,0x09,0xa9,0xa9,0xa9,0xa9,0x00,0x0f,0x0f,0xff,0xff,
		0xff,0xff,0x00,0x5c,0x5c,0x5c,0x5c,0xfb,0xfb,0xd8,0xd8,0x0e,0x0e,0x00,0x00,0x00,
		0x00,0x0e,0xd8,0xfb,0x5c,0x5c,0x09,0xa9,0xa9,0xa9,0x00,0x0f,0x0f,0xff,0xff,0xff,
		0xff,0xff,0x00,0x0e,0x0e,0x5c,0x5c,0x5c,0x5c,0xfb,0xfb,0xd8,0xd8,0x0e,0x0e,0x00,
		0x0e,0xd8,0xfb,0x5c,0x5c,0x09,0xa9,0xa9,0xa9,0x00,0x0f,0x0f,0xff,0xff,0xff,0xff,
		0xff,0x00,0x5c,0x09,0x09,0x0e,0x0e,0x5c,0x5c,0x5c,0x5c,0xfb,0xfb,0xd8,0xd8,0x0e,
		0x0e,0xd8,0xfb,0x5c,0x09,0xa9,0xa9,0xa9,0x00,0x0f,0x0f,0xff,0xff,0xff,0xff,0xff,
		0xff,0x00,0x00,0x5c,0x5c,0x09,0x09,0x0e,0x0e,0x5c,0x5c,0x5c,0x5c,0xfb,0xfb,0xd8,
		0xd8,0xfb,0x5c,0x5c,0x09,0xa9,0xa9,0x00,0x0f,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0x00,0x00,0x5c,0x5c,0x09,0x09,0x0e,0x0e,0x5c,0x5c,0x5c,0x5c,0xfb,
		0xfb,0x5c,0x5c,0x09,0xa9,0xa9,0x00,0x0f,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x5c,0x5c,0x09,0x09,0x0e,0x0e,0x5c,0x5c,0x5c,
		0xfb,0x5c,0x09,0xa9,0xa9,0x00,0x0f,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x5c,0x5c,0x09,0x09,0x0e,0x0e,0x5c,
		0xfb,0x0e,0x09,0xa9,0x00,0x0f,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x5c,0x5c,0x09,0x09,0x0e,
		0x0e,0x09,0xa9,0x00,0x0f,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x5c,0x5c,0x09,
		0x09,0xa9,0x00,0x0f,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x5c,
		0x00,0x00,0x0f,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,
		0x00,0x0f,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff
	},
	{
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0x0e,0x0e,0x0e,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0x0e,0x0e,0x3f,0x00,0x0e,0x0e,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0x0e,0xd8,0x00,0x0e,0x3f,0x00,0x0e,0x0e,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0x0e,0xa9,0xfb,0xfb,0xd8,0x00,0x0e,0x3f,0x00,0x0e,0x0e,0xff,
		0xff,0xff,0xff,0x0e,0x5c,0xd8,0x5c,0x0e,0xfb,0xfb,0xd8,0x00,0xd8,0x3f,0x00,0xff,
		0xff,0xff,0x0e,0x5c,0x0e,0x0e,0xd8,0xda,0x2a,0x0e,0xfb,0xd8,0x3f,0xa9,0x00,0xff,
		0xff,0x0e,0x5c,0x0e,0x00,0x00,0x0e,0x0e,0xda,0xd8,0x5c,0xa9,0x17,0x0e,0x00,0xff,
		0x0e,0x5c,0xd8,0x0e,0x00,0x00,0x00,0x00,0x0e,0xd8,0xfb,0x17,0x00,0x0e,0x00,0xff,
		0x00,0x5c,0xfb,0xd8,0x0e,0x0e,0x00,0x00,0x0e,0x5c,0x0e,0xa9,0x0e,0x00,0x0f,0xff,
		0x00,0x09,0x5c,0x5c,0xfb,0xd8,0x0e,0x0e,0xd8,0x5c,0x09,0xa9,0x00,0x0f,0xff,0xff,
		0x00,0x0e,0x09,0x09,0x5c,0x5c,0xfb,0xd8,0xfb,0x09,0xa9,0x00,0x0f,0xff,0xff,0xff,
		0x00,0x00,0x0e,0x0e,0x09,0x09,0x5c,0xfb,0x09,0xa9,0x00,0x0f,0xff,0xff,0xff,0xff,
		0xff,0xff,0x00,0x00,0x0e,0x0e,0x09,0x09,0x09,0x00,0x0f,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0x00,0x00,0x0e,0x0e,0x00,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff
	}
};

const media_icon M_AUDIO_CONSUMER_ICON =
{
	{
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x1b,0x1c,0x00,0x00,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0x00,0x1b,0x1c,0x1b,0x1c,0x1c,0x00,0x00,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0x00,0x1b,0x1c,0x1b,0x1c,0x1c,0x1b,0x1c,0x1c,0x00,0x00,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0x00,0x1b,0x1c,0x1b,0x1c,0x1c,0x1b,0x1c,0x1c,0x1b,0x1c,0x1b,0x00,
		0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0x00,0x1b,0x1c,0x1b,0x1c,0x1c,0x1b,0x1c,0x1c,0x1b,0x1c,0x1b,0x1c,0x1c,
		0x1b,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0x00,0x1b,0x1c,0x1b,0x1c,0x1c,0x1b,0x1c,0x1c,0x1b,0x1c,0x1b,0x1c,0x1c,0x1b,
		0x1c,0x1c,0x1b,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0x00,0x3f,0x1b,0x1c,0x1b,0x1c,0x1c,0x1b,0x1c,0x1c,0x1b,0x1c,0x1b,0x1c,0x1c,0x1b,
		0x1c,0x1c,0x1b,0x1c,0x1b,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0x00,0x17,0x3f,0x3f,0x1b,0x1c,0x1b,0x1c,0x1c,0x1b,0x1c,0x1c,0x1b,0x1c,0x1b,0x1c,
		0x1c,0x1b,0x1c,0x1c,0x1b,0x1c,0x3f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0x00,0x17,0x17,0x18,0x3f,0x3f,0x1b,0x1c,0x1b,0x1c,0x1c,0x1b,0x1c,0x1c,0x1b,0x1c,
		0x1b,0x1c,0x1c,0x1b,0x1c,0x3f,0x0e,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0x00,0x17,0x0f,0x17,0x18,0x17,0x3f,0x3f,0x1b,0x1c,0x1b,0x1c,0x1c,0x1b,0x1c,0x1c,
		0x1b,0x1c,0x1b,0x1c,0x3f,0x0e,0x0f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0x00,0x17,0x0f,0x0f,0x0f,0x17,0x17,0x18,0x3f,0x3f,0x1b,0x1c,0x1b,0x1c,0x1c,0x1b,
		0x1c,0x1c,0x1b,0x3f,0x0e,0x0f,0x0f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0x00,0x17,0x0f,0x00,0x00,0x0f,0x0f,0x17,0x17,0x18,0x3f,0x3f,0x1b,0x1c,0x1b,0x1c,
		0x1c,0x1b,0x3f,0x0e,0x0f,0x0f,0x0f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0x00,0x17,0x0f,0x00,0x00,0x00,0x00,0x0f,0x0f,0x17,0x17,0x18,0x3f,0x3f,0x1b,0x1c,
		0x1b,0x3f,0x0e,0x0f,0x0f,0x0f,0x0f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0x00,0x17,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x0f,0x0f,0x17,0x17,0x18,0x3f,0x1b,
		0x3f,0x0e,0x0f,0x0f,0x0f,0x0f,0x0f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0x00,0x17,0x0f,0x00,0x00,0x37,0x00,0x00,0x00,0x00,0x00,0x0f,0x0f,0x17,0x17,0x3f,
		0x0e,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x00,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0xff,
		0x00,0x17,0x0f,0x00,0x00,0x37,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3f,0x17,0x3f,
		0x0e,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x00,0xff,0xff,0x00,0x00,0x0f,0x0f,0x0f,0xff,
		0x00,0x17,0x0f,0x37,0x36,0x00,0x37,0x00,0x00,0x00,0x00,0x00,0x00,0x3f,0x17,0x3f,
		0x0e,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x00,0xff,0x00,0x0f,0x0f,0xff,0xff,0xff,0xff,
		0x00,0x17,0x0f,0x00,0x00,0x00,0x37,0x00,0x36,0x00,0x37,0x00,0x00,0x3f,0x17,0x3f,
		0x0e,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x00,0xff,0x00,0x0f,0xff,0xff,0xff,0xff,0xff,
		0x00,0x17,0x0f,0x00,0x00,0x00,0x37,0x36,0x37,0x00,0x37,0x00,0x00,0x3f,0x17,0x3f,
		0x0e,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x00,0xff,0x00,0x0f,0xff,0xff,0xff,0xff,0xff,
		0x00,0x17,0x0f,0x00,0x00,0x00,0x37,0x00,0x36,0x37,0x37,0x00,0x00,0x3f,0x17,0x3f,
		0x0e,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x00,0xff,0xff,0x00,0x0e,0xff,0xff,0xff,0xff,
		0x00,0x17,0x0f,0x00,0x00,0x00,0x00,0x00,0x37,0x00,0x00,0x36,0x00,0x3f,0x17,0x3f,
		0x0e,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x00,0xff,0xff,0xff,0x00,0x0e,0xff,0xff,0xff,
		0x00,0x17,0x3f,0x3f,0x00,0x00,0x00,0x00,0x37,0x00,0x00,0x00,0x00,0x3f,0x17,0x3f,
		0x0e,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x00,0xff,0xff,0xff,0x00,0x0f,0xff,0xff,0xff,
		0x00,0x17,0x17,0x18,0x3f,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3f,0x17,0x3f,
		0x0e,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x00,0x0f,0x0e,0xff,0x00,0x0f,0xff,0xff,0xff,
		0xff,0x00,0x00,0x17,0x17,0x18,0x3f,0x3f,0x00,0x00,0x00,0x00,0x00,0x3f,0x17,0x3f,
		0x0e,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x00,0x0f,0x0e,0x00,0x0f,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0x00,0x00,0x17,0x17,0x18,0x3f,0x3f,0x00,0x00,0x00,0x3f,0x17,0x3f,
		0x0e,0x0f,0x0f,0x0f,0x0f,0x0f,0x00,0x0f,0x0f,0x00,0x0f,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x17,0x17,0x18,0x3f,0x3f,0x00,0x3f,0x17,0x3f,
		0x0e,0x0f,0x0f,0x0f,0x0f,0x00,0x00,0x00,0x00,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x17,0x17,0x18,0x3f,0x3f,0x17,0x3f,
		0x0e,0x0f,0x0f,0x0f,0x00,0x0f,0x0f,0x0f,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x17,0x17,0x18,0x17,0x3f,
		0x0e,0x0f,0x0f,0x00,0x0f,0x0f,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x17,0x17,0x3f,
		0x0e,0x0f,0x00,0x0f,0x0f,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x3f,
		0x0e,0x00,0x0f,0x0f,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,
		0x00,0x0e,0x0f,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff
	},
	{
		0xff,0xff,0xff,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0x00,0x1b,0x1c,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0x00,0x1b,0x1c,0x1b,0x1c,0x1c,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0x00,0x3f,0x1b,0x1c,0x1b,0x1c,0x1c,0x1b,0x1c,0x00,0x00,0xff,0xff,0xff,0xff,0xff,
		0x00,0x17,0x3f,0x3f,0x1b,0x1c,0x1b,0x1c,0x1c,0x1b,0x1c,0x00,0xff,0xff,0xff,0xff,
		0x00,0x0e,0x18,0x17,0x3f,0x3f,0x1b,0x1c,0x1b,0x1c,0x0f,0x00,0xff,0xff,0xff,0xff,
		0x00,0x0e,0x00,0x00,0x18,0x17,0x3f,0x3f,0x1b,0x0f,0x0f,0x00,0xff,0xff,0xff,0xff,
		0x00,0x0e,0x00,0x00,0x00,0x00,0x18,0x17,0x0f,0x0f,0x0f,0x00,0xff,0xff,0x00,0x00,
		0x00,0x0e,0x36,0x00,0x37,0x00,0x00,0x18,0x0f,0x0f,0x0e,0x00,0xff,0x00,0x0e,0x0e,
		0x00,0x0e,0x00,0x36,0x37,0x00,0x00,0x18,0x0f,0x0f,0x0e,0x00,0xff,0x00,0x0e,0xff,
		0x00,0x0f,0x00,0x00,0x36,0x37,0x37,0x18,0x0e,0x0f,0x0f,0x00,0xff,0x00,0x0e,0xff,
		0x00,0x17,0x00,0x00,0x37,0x00,0x00,0x17,0x0f,0x0f,0x0f,0x00,0xff,0x00,0x0f,0xff,
		0x00,0x00,0x17,0x17,0x00,0x00,0x00,0x18,0x0f,0x0e,0x0f,0x00,0x00,0x00,0x0f,0xff,
		0xff,0xff,0x00,0x00,0x17,0x17,0x00,0x18,0x0f,0x0e,0x00,0x00,0x00,0x0e,0xff,0xff,
		0xff,0xff,0xff,0xff,0x00,0x00,0x17,0x17,0x0f,0x00,0x0f,0x0f,0x0e,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x0e,0x0f,0xff,0xff,0xff,0xff,0xff
	}
};

const media_icon M_VIDEO_INPUT_ICON =
{
	{
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x1c,0x1c,0x00,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x1c,0x1c,0x01,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0x00,0x00,0x1b,0x1b,0x1c,0x1c,0x1c,0x00,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0x01,0x01,0x1a,0x1a,0x1b,0x1b,0x1b,0x01,0xff,0xff,0xff,0xff,
		0xff,0xff,0x00,0x00,0x1c,0x1c,0x1c,0x1b,0x1c,0x1c,0x0f,0x00,0xff,0xff,0xff,0xff,
		0xff,0xff,0x00,0x00,0x1c,0x1c,0x1a,0x1a,0x1b,0x1b,0x1b,0x1b,0x01,0xff,0xff,0xff,
		0xff,0x00,0x3f,0x1c,0x1c,0x1c,0x1a,0x1a,0x0f,0x0f,0x00,0x00,0xff,0xff,0xff,0xff,
		0x00,0x00,0x1a,0x1a,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x3f,0x3f,0x0a,0x00,0xff,0xff,
		0xff,0x00,0x3f,0x1c,0x1c,0x1a,0x0f,0x0f,0x01,0x01,0x00,0x00,0xff,0xff,0x00,0x00,
		0x1c,0x1c,0x1a,0x1a,0x1c,0x1c,0x1c,0x1c,0x3f,0x3f,0x0f,0x0f,0x0a,0x00,0xff,0xff,
		0xff,0x00,0x3f,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1a,0x1a,0x02,0x02,0x1c,0x1c,
		0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x3f,0x3f,0x0f,0x0f,0x0f,0x0f,0x0a,0x00,0xff,0xff,
		0xff,0x00,0x15,0x15,0x1a,0x1a,0x3f,0x3f,0x1c,0x1c,0x1b,0x1c,0x1c,0x1c,0x1c,0x1c,
		0x1c,0x1c,0x1c,0x1c,0x3f,0x3f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0a,0x00,0xff,0xff,
		0xff,0xff,0x00,0x00,0x15,0x15,0x1a,0x1a,0x1a,0x1a,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
		0x1c,0x1c,0x3f,0x3f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0a,0x00,0xff,0xff,
		0xff,0xff,0xff,0xff,0x00,0x00,0x15,0x15,0x15,0x15,0x3f,0x3f,0x3f,0x1c,0x1c,0x1c,
		0x3f,0x3f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0a,0x00,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x0b,0x0b,0x0a,0x0a,0x14,0x14,0x3f,0x3f,
		0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0a,0x00,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x0b,0x0a,0x14,0x14,0x3f,0x0f,0x0f,
		0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0a,0x00,0xff,0xff,
		0xff,0xff,0xff,0xff,0x05,0x05,0x05,0x05,0x00,0x00,0x14,0x14,0x3f,0x0f,0x0f,0x0f,
		0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0a,0x01,0xff,0xff,0xff,
		0xff,0xff,0x05,0x05,0x05,0x05,0x05,0x05,0x00,0x00,0x14,0x3f,0x0f,0x0f,0x0f,0x0f,
		0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0a,0x00,0xff,0xff,0xff,0xff,
		0xff,0x02,0x02,0x02,0x1c,0x0f,0x00,0x06,0x00,0x00,0x3f,0x07,0x0b,0x0f,0x0f,0x0f,
		0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0e,0x0e,0x0a,0x00,0x0f,0x0f,0x0f,0x0f,
		0xff,0x02,0x02,0x1c,0x06,0x0f,0x06,0x00,0x00,0x00,0x07,0x07,0x0b,0x0f,0x0f,0x0f,
		0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0e,0x0a,0x0a,0x00,0x00,0x0f,0x0f,0x0f,0x0f,
		0x00,0x00,0x15,0x02,0x06,0x06,0x3f,0x06,0x07,0x0f,0x07,0x07,0x07,0x0b,0x0f,0x0f,
		0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0a,0x0a,0x00,0x00,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
		0x00,0x00,0x15,0x06,0x06,0x02,0x3f,0x00,0x07,0x0f,0x07,0x07,0x07,0x0b,0x0f,0x0f,
		0x0f,0x0f,0x0f,0x0f,0x0a,0x0a,0x00,0x00,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0xff,0xff,
		0x00,0x00,0x15,0x06,0x06,0x02,0x3f,0x00,0x07,0x0f,0x07,0x07,0x07,0x07,0x0b,0x0f,
		0x0f,0x0f,0x0a,0x0a,0x00,0x00,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0xff,0xff,0xff,0xff,
		0x00,0x00,0x15,0x06,0x06,0x06,0x3f,0x00,0x07,0x0f,0x0f,0x0f,0x07,0x07,0x0b,0x0b,
		0x0a,0x0a,0x00,0x00,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0x02,0x02,0x02,0x02,0x06,0x02,0x02,0x07,0x05,0x00,0x7b,0x0f,0x0f,0x00,0x0b,
		0x00,0x00,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0x02,0x02,0x02,0x02,0x02,0x06,0x02,0x05,0xff,0x00,0x7b,0x07,0x07,0x00,0x00,
		0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0x00,0x00,0x00,0x00,0x05,0x05,0xff,0xff,0x00,0x00,0x00,0x00,0x0f,0x0f,
		0x0f,0x0f,0x0f,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff
	},
	{
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0xff,0xff,0xff,
		0xff,0x00,0x00,0x1b,0x1c,0x00,0xff,0xff,0xff,0x00,0x01,0x3f,0x1b,0x01,0xff,0xff,
		0x00,0x3f,0x1c,0x1a,0x01,0x00,0xff,0x00,0x00,0x1a,0x1c,0x1c,0x3f,0x0f,0x00,0xff,
		0x00,0x15,0x15,0x3f,0x1c,0x1b,0x02,0x1c,0x1c,0x1c,0x3f,0x0f,0x0f,0x0f,0x00,0xff,
		0xff,0x00,0x00,0x15,0x15,0x3f,0x3f,0x3f,0x3f,0x0f,0x0f,0x0f,0x0f,0x0f,0x00,0xff,
		0xff,0xff,0xff,0x00,0x00,0x0a,0x15,0x0a,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x00,0xff,
		0xff,0x05,0x05,0x05,0x00,0x14,0x0b,0x0a,0x0f,0x0f,0x0f,0x0f,0x0f,0x00,0xff,0xff,
		0x02,0x02,0x1c,0x0e,0x00,0x07,0x07,0x07,0x0f,0x0f,0x0f,0x0f,0x06,0x00,0x0f,0x0f,
		0x00,0x15,0x06,0x3f,0x05,0x07,0x07,0x07,0x0f,0x0f,0x06,0x00,0x00,0x0f,0x0f,0x0f,
		0x00,0x06,0x06,0x3f,0x05,0x07,0x07,0x07,0x0f,0x00,0x00,0x0f,0x0f,0x0f,0xff,0xff,
		0x02,0x02,0x02,0x02,0x05,0x7b,0x07,0x00,0x00,0x0f,0x0f,0x0f,0xff,0xff,0xff,0xff,
		0xff,0x00,0x00,0x05,0xff,0x00,0x00,0x0f,0x0f,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff
	}
};

const media_icon M_VIDEO_OUTPUT_ICON =
{
	{
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0x00,0xff,0xff,0xff,0xff,0x00,0x00,0xff,0xff,0xff,
		0xff,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0x00,0x1b,0x00,0x00,0xff,0x00,0x1b,0x1c,0x00,0x00,0xff,
		0xff,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0x00,0x1b,0x1c,0x1b,0x1c,0x00,0x0b,0x1b,0x1c,0x1c,0x1b,0x00,
		0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0x00,0x1b,0x1c,0x1b,0x1c,0x1c,0x1b,0x1c,0x0b,0x0a,0x1c,0x1b,0x1c,
		0x1c,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0x00,0x3f,0x1b,0x1c,0x1b,0x1c,0x1c,0x1b,0x1c,0x1c,0x1b,0x0b,0x0a,0x1c,
		0x1c,0x00,0x19,0x00,0x00,0xff,0xff,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0x00,0x15,0x3f,0x3f,0x1b,0x1c,0x1b,0x1c,0x1c,0x1b,0x1c,0x1c,0x1b,0x0b,
		0x0a,0x00,0x1a,0x19,0x1a,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0x00,0x15,0x15,0x15,0x3f,0x3f,0x1b,0x1c,0x1b,0x1c,0x1c,0x1b,0x1c,0x1c,
		0x1b,0x00,0x0b,0x19,0x1a,0x00,0x0f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0x00,0x15,0x15,0x15,0x16,0x15,0x3f,0x3f,0x1b,0x1c,0x1b,0x1c,0x1c,0x1b,
		0x1c,0x00,0x19,0x0b,0x00,0x0f,0x0f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0x00,0x15,0x15,0x0b,0x15,0x15,0x15,0x16,0x3f,0x3f,0x1b,0x1c,0x1b,0x1c,
		0x1c,0x00,0x19,0x00,0x1a,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0x00,0x15,0x15,0x0b,0x0a,0x0b,0x15,0x15,0x16,0x15,0x3f,0x3f,0x1b,0x1c,
		0x1b,0x00,0x00,0x11,0x11,0x11,0x11,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0x00,0x15,0x15,0x0b,0x0a,0x86,0x0b,0x0b,0x15,0x15,0x15,0x16,0x3f,0x3f,
		0x1b,0x1c,0x1b,0x1c,0x1c,0x3f,0x0e,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0x00,0x15,0x15,0x0b,0x0a,0x86,0x86,0x86,0x0b,0x0b,0x15,0x15,0x16,0x15,
		0x3f,0x3f,0x1b,0x1c,0x3f,0x0e,0x0f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0x00,0x15,0x15,0x0b,0x0a,0x86,0x60,0x60,0x86,0x86,0x0e,0x0a,0x16,0x15,
		0x15,0x15,0x3f,0x3f,0x0e,0x0f,0x0f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0x00,0x15,0x15,0x0b,0x0a,0x86,0x60,0x60,0x60,0x60,0x86,0x86,0x0e,0x0b,
		0x15,0x15,0x15,0x16,0x0e,0x0f,0x0f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0x00,0x15,0x15,0x0b,0x0a,0x86,0x60,0x60,0x60,0x60,0x86,0x86,0xad,0xad,
		0x0e,0x1f,0x16,0x15,0x0f,0x0f,0x0f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0x00,0x15,0x15,0x0b,0x0a,0x86,0x60,0x60,0x60,0x60,0x86,0x3f,0xad,0xad,
		0xad,0x3f,0x15,0x15,0x0f,0x0f,0x0f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0x00,0x15,0x15,0x0b,0x0a,0x86,0x60,0x60,0x60,0x60,0x86,0x86,0xad,0xad,
		0xad,0x3f,0x15,0x15,0x0f,0x0f,0x0f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0x00,0x15,0x15,0x0b,0x0a,0x3f,0x60,0x60,0x60,0x60,0x86,0x86,0xad,0xad,
		0xad,0x3f,0x15,0x15,0x0f,0x0f,0x0f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0x00,0x15,0x15,0x0b,0x3f,0x3f,0x3f,0x3f,0x60,0x60,0x86,0x86,0xad,0xad,
		0xad,0x3f,0x15,0x15,0x0f,0x0f,0x0f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0x00,0x15,0x15,0x15,0x16,0x15,0x3f,0x3f,0x3f,0x3f,0x86,0x86,0xad,0xad,
		0xad,0x3f,0x15,0x15,0x0f,0x0f,0x0f,0x00,0x11,0x11,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0x00,0x00,0x15,0x15,0x15,0x16,0x15,0x15,0x3f,0x3f,0x3f,0x3f,0xad,0xad,
		0xad,0x3f,0x15,0x15,0x0f,0x0f,0x0f,0x00,0x11,0x11,0x11,0x11,0xff,0xff,0xff,0xff,
		0xff,0xff,0x11,0x0c,0x00,0x00,0x16,0x15,0x15,0x15,0x16,0x15,0x3f,0x3f,0x3f,0x3f,
		0xad,0x3f,0x15,0x15,0x0f,0x0f,0x0f,0x00,0x11,0x11,0x11,0x11,0x11,0x11,0xff,0xff,
		0xff,0xff,0xff,0xff,0x11,0x11,0x00,0x00,0x15,0x15,0x15,0x16,0x15,0x15,0x3f,0x3f,
		0x3f,0x3f,0x15,0x15,0x0f,0x0f,0x0f,0x00,0x11,0x11,0x11,0x11,0x11,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0x11,0x11,0x00,0x00,0x15,0x15,0x15,0x16,0x15,0x15,
		0x3f,0x3f,0x15,0x15,0x0f,0x0f,0x0f,0x00,0x11,0x11,0x11,0x11,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x11,0x11,0x00,0x00,0x15,0x15,0x15,0x16,
		0x20,0x20,0x15,0x16,0x0e,0x0f,0x0f,0x00,0x11,0x11,0x11,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x11,0x11,0x00,0x00,0x15,0x15,
		0x20,0x20,0x2a,0x15,0x0f,0x0f,0x0f,0x00,0x11,0x11,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x11,0x11,0x00,0x00,
		0x15,0x15,0x2a,0x16,0x0e,0x0f,0x00,0x11,0x11,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x11,0x11,
		0x00,0x00,0x15,0x15,0x0f,0x00,0x11,0x11,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0x11,0x11,0x00,0x00,0x00,0x11,0x11,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0x11,0x11,0x11,0x11,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff
	},
	{
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0x09,0x06,0x05,0x06,0xff,0xff,0x00,0xff,0xff,0x00,0xff,0xff,0xff,0xff,
		0xff,0x05,0x3f,0x3f,0x1e,0x17,0x05,0x06,0x00,0xff,0x00,0xff,0xff,0xff,0xff,0xff,
		0xff,0x04,0x3f,0x3f,0x1d,0x1e,0x1d,0x19,0x00,0x00,0x0d,0xff,0xff,0xff,0xff,0xff,
		0xff,0x05,0x13,0x14,0x3f,0x3f,0x1e,0x1e,0x1e,0x06,0x06,0x00,0xff,0xff,0xff,0xff,
		0xff,0x05,0x11,0xd5,0x0c,0x13,0x3f,0x3f,0x1e,0x1e,0x1e,0x01,0xff,0xff,0xff,0xff,
		0xff,0x05,0x11,0xd5,0x60,0x0c,0x0a,0x15,0x3f,0x3f,0x16,0x01,0xff,0xff,0xff,0xff,
		0xff,0x05,0x11,0xd5,0x60,0x60,0x86,0xd5,0x15,0x17,0xaf,0x03,0xff,0xff,0xff,0xff,
		0xff,0x05,0x11,0xd5,0x60,0x60,0x86,0xd3,0x60,0x19,0x0f,0x03,0xff,0xff,0xff,0xff,
		0xff,0x05,0x11,0xd3,0x86,0x86,0x86,0x23,0x60,0x19,0x0f,0x03,0xff,0xff,0xff,0xff,
		0xff,0x00,0x15,0x1c,0x1d,0x1f,0xd3,0xd3,0x60,0x19,0x10,0x05,0x0b,0xff,0xff,0xff,
		0xff,0xff,0x02,0x02,0x11,0x19,0x1f,0x1f,0x60,0x16,0x11,0x05,0x0b,0x0b,0x0b,0xff,
		0xff,0xff,0xff,0xff,0x02,0x02,0x11,0x1a,0x20,0x15,0x12,0x05,0x0b,0x0b,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0x02,0x02,0x12,0x2a,0x0f,0x00,0x0b,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x02,0x05,0x00,0x0b,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff
	}
};

const media_icon M_VIDEO_PRODUCER_ICON =
{
	{
		0xff,0xff,0xff,0xff,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0x00,0x18,0x10,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0x00,0x18,0x3f,0x18,0x10,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0x00,0x10,0x18,0x18,0x10,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0x00,0x10,0x10,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0x00,0x10,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0x00,0x10,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0x00,0x10,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0x00,0x00,0x18,0x18,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x10,0x00,0xff,0xff,0xff,0x00,0x00,0xff,0xff,
		0x00,0x00,0x18,0x18,0x04,0x04,0x18,0x18,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x10,0x00,0xff,0x00,0x00,0x18,0x18,0x00,0x00,
		0x18,0x18,0x00,0x04,0x04,0x04,0x04,0x04,0x18,0x18,0x00,0x00,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x18,0x18,0x18,0x10,0x18,0x18,
		0x00,0x00,0x00,0x00,0x00,0x04,0x04,0x04,0x04,0x04,0x18,0x18,0x00,0x00,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x18,0x18,0x18,0x18,0x08,0x16,0x3f,0x10,
		0x18,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x08,0x08,0x08,0x08,0x00,0xff,
		0xff,0xff,0xff,0xff,0xff,0x00,0x10,0x10,0x3f,0x3f,0x18,0x18,0x18,0x1b,0x08,0x16,
		0x3f,0x10,0x18,0x18,0x00,0x00,0x18,0x18,0x08,0x08,0x08,0x08,0x08,0x08,0x00,0xff,
		0xff,0xff,0xff,0xff,0xff,0x00,0x10,0x10,0x10,0x10,0x3f,0x3f,0x18,0x18,0x18,0x1b,
		0x08,0x16,0x3f,0x10,0x18,0x18,0x00,0x00,0x08,0x08,0x08,0x08,0x08,0x08,0x00,0xff,
		0xff,0xff,0xff,0xff,0x00,0x18,0x18,0x18,0x10,0x10,0x10,0x10,0x3f,0x3f,0x18,0x18,
		0x18,0x1b,0x08,0x16,0x3f,0x18,0x18,0x18,0x00,0x00,0x08,0x08,0x08,0x08,0x00,0xff,
		0xff,0xff,0xff,0x00,0x3f,0x3f,0x18,0x18,0x18,0x18,0x10,0x10,0x10,0x10,0x3f,0x3f,
		0x18,0x18,0x18,0x1b,0x18,0x18,0x1b,0x1b,0x0a,0x0a,0x00,0x08,0x08,0x08,0x00,0xff,
		0xff,0xff,0xff,0x00,0x00,0x00,0x3f,0x3f,0x18,0x18,0x18,0x18,0x10,0x10,0x10,0x10,
		0x3f,0x3f,0x18,0x18,0x1b,0x1b,0x0a,0x0a,0x0a,0x0a,0x00,0x08,0x08,0x08,0x00,0xff,
		0xff,0xff,0xff,0x00,0x04,0x00,0x00,0x00,0x3f,0x3f,0x18,0x18,0x18,0x18,0x10,0x10,
		0x10,0x10,0x3f,0x1b,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x00,0x08,0x08,0x00,0xff,
		0xff,0xff,0x00,0x10,0x04,0x00,0x00,0x00,0x00,0x00,0x3f,0x3f,0x18,0x18,0x18,0x18,
		0x10,0x10,0x10,0x16,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x00,0x08,0x08,0x00,0xff,
		0xff,0xff,0x00,0x10,0x04,0x04,0x04,0x00,0x00,0x00,0x00,0x00,0x10,0x0a,0x0a,0x0a,
		0x10,0x10,0x10,0x16,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x00,0x08,0x00,0xff,
		0xff,0x00,0x10,0x10,0x10,0x04,0x04,0x04,0x00,0x00,0x00,0x00,0x10,0x0a,0x0a,0x0a,
		0x10,0x10,0x10,0x16,0x0a,0x0a,0x0a,0x0a,0x0a,0x02,0x02,0x0a,0x00,0x08,0x00,0xff,
		0xff,0x00,0x10,0x10,0x10,0x04,0x04,0x04,0x04,0x00,0x00,0x00,0x00,0x10,0x0a,0x0a,
		0x10,0x10,0x10,0x16,0x0a,0x0a,0x0a,0x02,0x02,0x16,0x16,0x10,0x0a,0x00,0x00,0xff,
		0xff,0xff,0x00,0x00,0x10,0x10,0x10,0x04,0x04,0x00,0x00,0x00,0x00,0x10,0x0a,0x0a,
		0x10,0x10,0x10,0x16,0x0a,0x02,0x02,0x16,0x16,0x10,0x10,0x0a,0x0a,0x00,0x00,0xff,
		0xff,0xff,0xff,0x04,0x00,0x00,0x10,0x10,0x10,0x00,0xf9,0xf9,0x00,0x00,0x10,0x0a,
		0x10,0x10,0x10,0x16,0x02,0x16,0x16,0x10,0x10,0x0a,0x0a,0x0a,0x0a,0x0a,0x00,0x04,
		0xff,0x2a,0x2a,0xff,0xff,0x04,0x00,0x00,0x10,0xf9,0xf9,0xf9,0xf9,0x00,0x10,0x0a,
		0x10,0x10,0x10,0x16,0x0a,0x10,0x10,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x00,0x04,
		0x2a,0x2a,0x2a,0x2a,0xff,0xff,0xff,0x04,0x00,0xa5,0xf9,0xf9,0xf7,0x00,0x00,0x10,
		0x10,0x10,0x10,0x16,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x00,0x00,0x04,0x04,
		0xeb,0x2a,0x2a,0xf7,0xff,0xff,0xf3,0xf3,0xff,0xa5,0xa5,0xf7,0xf7,0x10,0x10,0x10,
		0x10,0x10,0x10,0x16,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x00,0x00,0x04,0x04,0xff,0xff,
		0xeb,0xeb,0xf7,0xf7,0x08,0xf3,0xf3,0xf3,0xf3,0xff,0xa5,0xf7,0x00,0x00,0x10,0x10,
		0x10,0x10,0x10,0x16,0x0a,0x0a,0x0a,0x0a,0x00,0x00,0x04,0x04,0xff,0xff,0xff,0xff,
		0xff,0xeb,0xf7,0x08,0x08,0x25,0xf3,0xf3,0x00,0xff,0xff,0x04,0x04,0x04,0x00,0x00,
		0x10,0x10,0x10,0x16,0x0a,0x0a,0x00,0x00,0x04,0x04,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0x25,0x25,0x00,0x00,0x08,0xff,0xff,0xff,0xff,0xff,0x04,
		0x00,0x00,0x10,0x16,0x00,0x00,0x04,0x04,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0x25,0x00,0x08,0x08,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0x04,0x00,0x00,0x04,0x04,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff
	},
	{
		0xff,0xff,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0x00,0x3f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0x00,0x18,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0x00,0x10,0x00,0xff,0xff,0xff,0xff,0xff,0x00,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0x00,0x00,0xff,0x00,0x00,0xff,0x00,0x18,0x00,0x00,0xff,0xff,0xff,
		0xff,0xff,0xff,0x00,0x00,0x00,0x18,0x00,0x00,0x10,0x04,0x18,0x18,0x00,0x00,0xff,
		0xff,0xff,0xff,0x00,0x3f,0x18,0x10,0x3f,0x18,0x00,0x00,0x00,0x08,0x18,0x08,0x00,
		0xff,0xff,0x00,0x10,0x10,0x3f,0x3f,0x18,0x10,0x3f,0x18,0x00,0x10,0x08,0x08,0x00,
		0xff,0xff,0x00,0x3f,0x18,0x10,0x10,0x3f,0x3f,0x18,0x18,0x1b,0x0a,0x00,0x08,0x00,
		0xff,0xff,0x04,0x00,0x3f,0x3f,0x18,0x10,0x10,0x3f,0x0a,0x0a,0x0a,0x0a,0x08,0x00,
		0xff,0x00,0x04,0x04,0x00,0x00,0x3f,0x0a,0x10,0x10,0x0a,0x0a,0x0a,0x0a,0x00,0x00,
		0xff,0x00,0x10,0x04,0x04,0x00,0x00,0x0a,0x10,0x10,0x0a,0x0a,0x02,0x10,0x0a,0x00,
		0xff,0xff,0x00,0x00,0x10,0xf9,0x00,0x10,0x10,0x10,0x02,0x10,0x10,0x0a,0x0a,0x00,
		0x2a,0x2a,0xff,0xff,0x00,0xf9,0xf9,0x00,0x10,0x10,0x0a,0x0a,0x0a,0x0a,0x00,0x04,
		0xeb,0xf7,0x08,0xf3,0xf3,0xa5,0x00,0x00,0x10,0x10,0x0a,0x0a,0x00,0x04,0xff,0xff,
		0xff,0xff,0xff,0x25,0x00,0xff,0xff,0xff,0x00,0x00,0x00,0x04,0xff,0xff,0xff,0xff
	}
};

const media_icon M_VIDEO_FILTER_ICON = M_GENERIC_ICON;

const media_icon M_VIDEO_CONSUMER_ICON = M_GENERIC_ICON;

const media_icon M_TIME_SOURCE_ICON =
{
	{
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x6d,0x47,0x47,0x47,0x47,
		0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x6d,0x6d,0x47,0x47,0x47,0x47,0x47,
		0x3f,0x47,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x6d,0x6d,0x47,0x47,0x47,0x47,0x47,0x3f,
		0x47,0x47,0x47,0x47,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x3f,0x3f,0x3f,0x3f,0x3f,0x47,0x47,0x3f,0x47,
		0x47,0x47,0x47,0x47,0x6d,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0x00,0x3f,0x94,0x94,0x94,0x94,0x94,0x3f,0x3f,0x47,0x47,
		0x47,0x47,0x47,0x6d,0x6d,0x6d,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0x00,0x94,0x94,0x94,0x00,0x00,0x00,0x94,0x94,0x94,0x3f,0x3f,
		0x47,0x47,0x6d,0x6d,0x6d,0x6d,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0x00,0x94,0x94,0x00,0x00,0x86,0x86,0x86,0x00,0x00,0x94,0x94,0x94,
		0x3f,0x6d,0x6d,0x6d,0x6d,0x94,0x94,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0x00,0x94,0x94,0x00,0x86,0x86,0x3f,0x3f,0x86,0x86,0x86,0x00,0x00,0x94,
		0x94,0x3f,0x6d,0x6d,0x94,0x94,0x94,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0x00,0x94,0x00,0x86,0x3f,0x3f,0x3f,0x3f,0x00,0x86,0x86,0x86,0x86,0x00,
		0x94,0x94,0x3f,0x94,0x94,0x94,0x7f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0x00,0x94,0x94,0x00,0x86,0x3f,0x3f,0x3f,0x60,0x60,0x60,0x60,0x86,0x86,0x86,
		0x00,0x94,0x3f,0x94,0x94,0x7f,0x7f,0x7f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0x00,0x94,0x00,0x86,0x3f,0x3f,0x3f,0x60,0x60,0x00,0x60,0x60,0x60,0x86,0x86,
		0x00,0x94,0x94,0x6d,0x7f,0x7f,0x7f,0x7f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0x00,0x94,0x00,0x86,0x3f,0x3f,0x60,0x60,0x60,0x00,0x60,0x60,0x3f,0x60,0x86,
		0x86,0x00,0x94,0x6d,0x7f,0x7f,0x7f,0x7f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0x00,0x94,0x00,0x86,0x00,0x3f,0x60,0x60,0x60,0x00,0x60,0x3f,0x3f,0x3f,0x86,
		0x86,0x00,0x94,0x94,0x7f,0x7f,0x7f,0x7f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0x00,0x94,0x00,0x86,0x3f,0x3f,0x60,0x60,0x60,0x00,0x60,0x60,0x3f,0x60,0x60,
		0x86,0x86,0x00,0x94,0x7f,0x7f,0x7f,0x7f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0x00,0x94,0x00,0x86,0x3f,0x3f,0x60,0x60,0x60,0x00,0x60,0x60,0x60,0x60,0x60,
		0x86,0x86,0x01,0x94,0x7f,0x7f,0x7f,0x7f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0x00,0x94,0x00,0x86,0x3f,0x60,0x60,0x60,0x60,0x00,0x00,0x60,0x60,0x60,0x60,
		0x86,0x86,0x01,0x94,0x7f,0x7f,0x7f,0x7f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0x00,0x94,0x94,0x00,0x86,0x60,0x60,0x60,0x60,0x60,0x60,0x00,0x00,0x60,0x60,
		0x86,0x86,0x01,0x94,0x7f,0x7f,0x7f,0x7f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0x00,0x94,0x94,0x00,0x86,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x01,0x00,
		0x86,0x86,0x00,0x94,0x7f,0x7f,0x7f,0x7f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0x00,0x94,0x94,0x94,0x00,0x86,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x86,
		0x86,0x01,0x94,0x94,0x7f,0x7f,0x7f,0x7f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0x00,0x94,0x94,0x94,0x00,0x86,0x86,0x60,0x60,0x00,0x60,0x60,0x60,0x86,0x86,
		0x86,0x01,0x94,0x94,0x7f,0x7f,0x7f,0x7f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0x00,0x94,0x94,0x94,0x94,0x00,0x00,0x86,0x86,0x60,0x60,0x60,0x86,0x86,0x86,
		0x01,0x94,0x94,0x94,0x7f,0x7f,0x7f,0x7f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0x00,0x94,0x94,0x94,0x94,0x94,0x94,0x00,0x00,0x86,0x86,0x86,0x86,0x00,0x00,
		0x94,0x94,0x94,0x94,0x7f,0x7f,0x7f,0x7f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0x00,0x00,0x94,0x94,0x94,0x94,0x94,0x94,0x94,0x00,0x00,0x00,0x00,0x94,0x94,
		0x94,0x94,0x94,0x94,0x7f,0x7f,0x7f,0x7f,0x01,0x0e,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0x00,0x00,0x94,0x94,0x94,0x94,0x94,0x94,0x94,0x94,0x94,0x94,0x94,
		0x94,0x94,0x94,0x94,0x7f,0x7f,0x7f,0x7f,0x01,0x0e,0x0f,0x0f,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x94,0x94,0x94,0x94,0x94,0x94,0x94,0x94,0x94,
		0x94,0x94,0x94,0x94,0x7f,0x7f,0x7f,0x7f,0x01,0x0e,0x0f,0x0f,0x0f,0x0f,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x94,0x94,0x94,0x94,0x94,0x94,0x94,
		0x94,0x94,0x94,0x94,0x7f,0x7f,0x7f,0x7f,0x01,0x0e,0x0f,0x0f,0x0f,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x94,0x94,0x94,0x94,0x94,
		0x94,0x94,0x94,0x94,0x7f,0x7f,0x7f,0x01,0x0e,0x0f,0x0f,0x0f,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x94,0x94,0x94,
		0x94,0x94,0x94,0x94,0x7f,0x7f,0x00,0x0f,0x0f,0x0f,0x0f,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x94,
		0x94,0x94,0x94,0x94,0x7f,0x00,0x0f,0x0f,0x0f,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,
		0x00,0x94,0x94,0x94,0x00,0x0f,0x0f,0x0f,0x0e,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0x00,0x00,0x00,0x0e,0x0f,0x0f,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff
	},
	{
		0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0x00,0x6d,0x6d,0x47,0x47,0x47,0x00,0x00,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0x00,0x6d,0x94,0x94,0x3f,0x3f,0x47,0x6d,0x94,0x00,0xff,0xff,0xff,0xff,
		0xff,0x00,0x94,0x94,0x00,0x00,0x00,0x94,0x3f,0x94,0x94,0x00,0xff,0xff,0xff,0xff,
		0xff,0x00,0x94,0x00,0x3f,0x86,0x86,0x00,0x94,0x6d,0x94,0x7f,0x00,0xff,0xff,0xff,
		0x00,0x94,0x00,0x3f,0x60,0x00,0x86,0x86,0x00,0x94,0x7f,0x7f,0x00,0xff,0xff,0xff,
		0x00,0x94,0x00,0x60,0x60,0x00,0x60,0x86,0x00,0x94,0x7f,0x7f,0x00,0xff,0xff,0xff,
		0x00,0x94,0x00,0x60,0x60,0x00,0x60,0x60,0x86,0x00,0x7f,0x7f,0x00,0xff,0xff,0xff,
		0x00,0x94,0x00,0x60,0x60,0x00,0x00,0x60,0x86,0x00,0x7f,0x7f,0x00,0xff,0xff,0xff,
		0x00,0x94,0x00,0x86,0x60,0x60,0x60,0x00,0x86,0x00,0x7f,0x7f,0x00,0xff,0xff,0xff,
		0x00,0x94,0x94,0x00,0x86,0x86,0x86,0x86,0x00,0x94,0x7f,0x7f,0x00,0xff,0xff,0xff,
		0x00,0x94,0x94,0x94,0x00,0x00,0x00,0x00,0x94,0x94,0x7f,0x7f,0x00,0xff,0xff,0xff,
		0xff,0x00,0x00,0x94,0x94,0x94,0x94,0x94,0x94,0x94,0x7f,0x7f,0x00,0x0f,0x0f,0xff,
		0xff,0xff,0xff,0x00,0x00,0x94,0x94,0x94,0x94,0x94,0x7f,0x00,0x00,0x0f,0x0f,0xff,
		0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x94,0x94,0x00,0x00,0x0f,0x0f,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x0e,0x0f,0xff,0xff,0xff
	}
};

const media_icon M_FILE_READER_ICON =
{
	{
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x1a,0x00,0x00,0xff,
		0xff,0xff,0xff,0xff,0xff,0x00,0x0e,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x1a,0x1a,0x1a,0x1a,0x00,
		0x00,0xff,0xff,0xff,0x00,0x0e,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
		0x1a,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0e,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x1a,0x1a,0x1a,0x1a,0x00,0x00,0x00,
		0x00,0x00,0x00,0x17,0x3f,0x04,0x00,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x1a,0x1a,0x1a,0x00,0x00,0x3f,0x3f,0x3f,
		0x3f,0x3f,0x3f,0x00,0x00,0x00,0x0e,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x1a,0x1a,0x1a,0x00,0x3f,0x3f,0x00,0x00,0x00,
		0x00,0x00,0x00,0x3f,0x3f,0x00,0x1a,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0x00,0x1a,0x1a,0x1a,0x00,0x3f,0x0e,0x00,0x87,0x87,0x87,
		0x87,0x87,0x87,0x01,0x0f,0x3f,0x00,0x1a,0x1a,0x00,0x00,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0x00,0x1a,0x1a,0x1a,0x1a,0x00,0x3f,0x00,0xae,0xae,0xae,0xae,
		0xae,0xae,0xae,0xae,0x00,0x3f,0x00,0x0e,0x1a,0x1a,0x1a,0x00,0x00,0xff,0xff,0xff,
		0xff,0xff,0xff,0x00,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x3f,0x0e,0xae,0x86,0x86,0x86,
		0x86,0x86,0x86,0xae,0x10,0x1f,0x00,0x0f,0x0f,0x1a,0x3f,0x15,0x0e,0x00,0xff,0xff,
		0xff,0xff,0x00,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x00,0x3f,0x0e,0x00,0x00,0x00,
		0x00,0x00,0x00,0x0f,0x3f,0x00,0x00,0x0e,0x0f,0x3f,0x15,0x0e,0x0e,0x00,0xff,0xff,
		0xff,0x00,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x87,0x00,0x3f,0x3f,0x3f,0x3f,
		0x3f,0x3f,0x3f,0x3f,0x00,0x87,0x00,0x0f,0x3f,0x15,0x0e,0x0e,0x0e,0x00,0xff,0xff,
		0x00,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x87,0x87,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x87,0x87,0x00,0x0f,0x15,0x0e,0x0e,0x0e,0x0e,0x00,0x0f,0x0f,
		0x00,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x87,0x60,0x60,0x60,0x60,
		0x3f,0x87,0x87,0x87,0x87,0x00,0x0f,0x15,0x0e,0x0e,0x0e,0x0e,0x00,0x0f,0x0f,0x0f,
		0x00,0x15,0x15,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x00,0x60,0x60,0x60,
		0x3f,0x87,0x87,0x00,0x00,0x0f,0x15,0x0e,0x0e,0x0e,0x0e,0x00,0x0f,0x0f,0x0f,0xff,
		0x00,0x15,0x15,0x15,0x15,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x00,0x00,
		0x00,0x00,0x00,0x0e,0x0f,0x15,0x0e,0x0e,0x0e,0x0e,0x00,0x0f,0x0f,0x0f,0xff,0xff,
		0x00,0x15,0x15,0x39,0x34,0x15,0x15,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
		0x1a,0x1a,0x1a,0x3f,0x15,0x0e,0x0e,0x0e,0x0e,0x00,0x0f,0x0f,0x0f,0xff,0xff,0xff,
		0x00,0x15,0x15,0x35,0x34,0x2b,0x2b,0x15,0x15,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,
		0x1a,0x1a,0x3f,0x15,0x0e,0x0e,0x0e,0x0e,0x00,0x0f,0x0f,0x0f,0xff,0xff,0xff,0xff,
		0xff,0x00,0x00,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x3f,0x3f,0x1a,0x1a,0x1a,
		0x1a,0x3f,0x0e,0x0e,0x0e,0x0e,0x0e,0x00,0x0f,0x0f,0x0f,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0x00,0x00,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x3f,0x3f,0x1a,
		0x3f,0x0e,0x0e,0x0e,0x0e,0x0e,0x00,0x0f,0x0f,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x3f,
		0x15,0x0e,0x0e,0x0e,0x0e,0x00,0x0f,0x0f,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x15,0x15,0x15,0x15,0x15,0x15,0x1b,
		0x15,0x0e,0x0e,0x0e,0x00,0x0f,0x0f,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x15,0x15,0x15,0x15,0x1b,
		0x15,0x0e,0x0e,0x00,0x0f,0x0f,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x15,0x15,0x1b,
		0x15,0x0e,0x00,0x0f,0x0f,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x1b,
		0x15,0x00,0x0e,0x0f,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,
		0x00,0x0e,0x0f,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff
	},
	{
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0xff,0xff,0xff,0x00,0x00,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0x00,0x1a,0x1a,0x00,0x00,0x00,0x00,0x00,0x0e,0xff,0xff,
		0xff,0xff,0xff,0xff,0x00,0x1a,0x00,0x0f,0x0f,0x0f,0x00,0x00,0x0e,0xff,0xff,0xff,
		0xff,0xff,0xff,0x00,0x1a,0x00,0x3f,0x00,0x00,0x00,0x00,0x1a,0x00,0x00,0xff,0xff,
		0xff,0xff,0x00,0x1a,0x00,0x3f,0x0e,0x87,0x87,0x87,0x0f,0x00,0x3f,0x00,0x00,0xff,
		0xff,0x00,0x1a,0x1a,0x00,0x3f,0xae,0x86,0x86,0x86,0x10,0x00,0x0f,0x0e,0x00,0xff,
		0x00,0x3f,0x3f,0x1a,0x00,0x87,0x3f,0x3f,0x0f,0x3f,0x87,0x00,0x0e,0x0e,0x00,0x0e,
		0x00,0x15,0x15,0x3f,0x3f,0x00,0x00,0x60,0x3f,0x87,0x00,0x0f,0x0e,0x00,0x0f,0x0f,
		0x00,0x15,0x35,0x2b,0x15,0x1f,0x3f,0x00,0x00,0x00,0x0f,0x0e,0x00,0x0e,0x0e,0xff,
		0x00,0x00,0x15,0x15,0x15,0x15,0x15,0x3f,0x0e,0x0e,0x0e,0x00,0x0e,0x0e,0xff,0xff,
		0xff,0xff,0x00,0x00,0x15,0x15,0x15,0x17,0x0e,0x0e,0x00,0x0e,0x0e,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0x00,0x00,0x15,0x17,0x0e,0x00,0x0e,0x0e,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x0e,0x0e,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff
	}
};

const media_icon M_FILE_WRITER_ICON =
{
	{
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x0b,0x3f,0x5a,0x00,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x5a,0x0b,0x3f,0x5a,0x5a,0x00,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x0b,0x5a,0x0b,0x3f,0x5a,0x5a,0x00,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x5c,0x0b,0x5a,0x3f,0x08,0x5a,0x5a,0x00,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x1a,0x00,0x00,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x5c,0xfd,0x0a,0x3f,0xa3,0xa3,0x08,0x09,0x00,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x1a,0x1a,0x1a,0x1a,0x00,
		0x00,0xff,0xff,0xff,0xff,0x00,0x5c,0xfd,0x11,0x3f,0x08,0xa3,0xa3,0xca,0x00,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
		0x1a,0x00,0x00,0xff,0x00,0x5c,0xfd,0x11,0x3f,0xfa,0x08,0x09,0x08,0x00,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
		0x1a,0x1a,0x1a,0x00,0x5c,0xfd,0x11,0x3f,0xfa,0x08,0x5c,0x5c,0x00,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
		0x1a,0x1a,0x00,0x5c,0xfd,0x11,0x3f,0xfa,0x08,0x5c,0x5c,0x00,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
		0x1a,0x0a,0x5c,0xfd,0x11,0x3f,0xfa,0x08,0x5c,0x5c,0x00,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0x00,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
		0x0a,0x5c,0xfd,0x11,0x3f,0xfa,0x08,0x5c,0x5c,0x00,0x00,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0x00,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x0a,
		0x5c,0xfd,0x11,0x3f,0xfa,0x08,0x5c,0x5c,0x00,0x1a,0x1a,0x00,0x00,0xff,0xff,0xff,
		0xff,0xff,0xff,0x00,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x0a,
		0xfd,0x11,0x3f,0xfa,0x08,0x5c,0x5c,0x00,0x1a,0x1a,0x3f,0x15,0x0e,0x00,0xff,0xff,
		0xff,0xff,0x00,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x0a,0x0b,
		0x0a,0x3f,0xfa,0x08,0x5c,0x5c,0x00,0x1a,0x1a,0x3f,0x15,0x0e,0x0e,0x00,0xff,0xff,
		0xff,0x00,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x0a,0x3f,
		0x0a,0xfa,0x08,0x5c,0x5c,0x00,0x1a,0x1a,0x3f,0x15,0x0e,0x0e,0x0e,0x00,0xff,0xff,
		0x00,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x0a,0x3f,
		0x0a,0x00,0x00,0x00,0x00,0x1a,0x1a,0x3f,0x15,0x0e,0x0e,0x0e,0x0e,0x00,0x0f,0x0f,
		0x00,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x0a,0x3f,0x5a,
		0x5b,0x5b,0x5b,0x00,0x1a,0x1a,0x3f,0x15,0x0e,0x0e,0x0e,0x0e,0x00,0x0f,0x0f,0x0f,
		0x00,0x15,0x15,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x0a,0x09,0x5b,
		0x5b,0x00,0x00,0x1a,0x1a,0x3f,0x15,0x0e,0x0e,0x0e,0x0e,0x00,0x0f,0x0f,0x0f,0xff,
		0x00,0x15,0x15,0x15,0x15,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x0a,0x09,0x00,
		0x00,0x1a,0x1a,0x1a,0x3f,0x15,0x0e,0x0e,0x0e,0x0e,0x00,0x0f,0x0f,0x0f,0xff,0xff,
		0x00,0x15,0x15,0x39,0x34,0x15,0x15,0x3f,0x3f,0x1a,0x1a,0x1a,0x0a,0x00,0x00,0x1a,
		0x1a,0x1a,0x1a,0x3f,0x15,0x0e,0x0e,0x0e,0x0e,0x00,0x0f,0x0f,0x0f,0xff,0xff,0xff,
		0x00,0x15,0x15,0x35,0x34,0x2b,0x2b,0x15,0x15,0x3f,0x3f,0x1a,0x00,0x00,0x1a,0x1a,
		0x1a,0x1a,0x3f,0x15,0x0e,0x0e,0x0e,0x0e,0x00,0x0f,0x0f,0x0f,0xff,0xff,0xff,0xff,
		0xff,0x00,0x00,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x3f,0x3f,0x1a,0x1a,0x1a,
		0x1a,0x3f,0x0e,0x0e,0x0e,0x0e,0x0e,0x00,0x0f,0x0f,0x0f,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0x00,0x00,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x3f,0x3f,0x1a,
		0x3f,0x0e,0x0e,0x0e,0x0e,0x0e,0x00,0x0f,0x0f,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x3f,
		0x15,0x0e,0x0e,0x0e,0x0e,0x00,0x0f,0x0f,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x15,0x15,0x15,0x15,0x15,0x15,0x1b,
		0x15,0x0e,0x0e,0x0e,0x00,0x0f,0x0f,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x15,0x15,0x15,0x15,0x1b,
		0x15,0x0e,0x0e,0x00,0x0f,0x0f,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x15,0x15,0x1b,
		0x15,0x0e,0x00,0x0f,0x0f,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x1b,
		0x15,0x00,0x0e,0x0f,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,
		0x00,0x0e,0x0f,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff
	},
	{
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x0b,0x5a,
		0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0xff,0xff,0xff,0xff,0x00,0x0b,0x3f,0x5a,
		0xff,0xff,0xff,0xff,0xff,0x00,0x1a,0x1a,0x00,0x00,0xff,0x00,0xfd,0x3f,0xa3,0xca,
		0xff,0xff,0xff,0xff,0x00,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0xfd,0x3f,0x08,0x5c,0xff,
		0xff,0xff,0xff,0x00,0x1a,0x1a,0x1a,0x1a,0x1a,0x0a,0xfd,0x3f,0x08,0x5c,0xff,0xff,
		0xff,0xff,0x00,0x1a,0x1a,0x1a,0x1a,0x1a,0x5c,0xfd,0x3f,0x08,0x5c,0x00,0x00,0xff,
		0xff,0x00,0x1a,0x1a,0x1a,0x1a,0x1a,0x0a,0x0a,0x3f,0x08,0x5c,0x0e,0x0e,0x00,0xff,
		0x00,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x0a,0x0a,0x00,0x00,0x0e,0x0e,0x0e,0x00,0x0e,
		0x00,0x15,0x15,0x3f,0x3f,0x1a,0x1a,0x3f,0x5b,0x5b,0x00,0x0e,0x0e,0x00,0x0f,0x0f,
		0x00,0x15,0x35,0x2b,0x15,0x1f,0x3f,0x09,0x00,0x0e,0x0e,0x0e,0x00,0x0e,0x0e,0xff,
		0x00,0x00,0x15,0x15,0x15,0x15,0x00,0x3f,0x0e,0x0e,0x0e,0x00,0x0e,0x0e,0xff,0xff,
		0xff,0xff,0x00,0x00,0x15,0x15,0x15,0x17,0x0e,0x0e,0x00,0x0e,0x0e,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0x00,0x00,0x15,0x17,0x0e,0x00,0x0e,0x0e,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x0e,0x0e,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff
	}
};

#endif // __MediaIconBits_H__
