/*
 * Copyright 2004-2010, Haiku Inc. All Rights Reserved.
 * Distributed under the terms of the MIT License.
 */
#ifndef _USB_HID_PAGE_MEDICAL_INSTRUMENT_H
#define _USB_HID_PAGE_MEDICAL_INSTRUMENT_H


/* Reference:
 *		HID Usage Page 0x40: MEDICAL INSTRUMENT
 *		HID Usage Tables Ver. 1.12
 *		http://www.usb.org/developers/devclass_docs/Hut1_12.pdf
 */

// Usage IDs
enum {
	B_HID_UID_MI_ULTRASOUND = 0x01,
	
	B_HID_UID_MI_VCR_ACQUISITION = 0x20,
	B_HID_UID_MI_FREEZE_THAW,
	B_HID_UID_MI_SLIP_STORE,
	B_HID_UID_MI_UPDATE,
	B_HID_UID_MI_NEXT,
	B_HID_UID_MI_SAVE,
	B_HID_UID_MI_PRINT,
	B_HID_UID_MI_MICROPHONE_ENABLE,
	
	B_HID_UID_MI_CINE = 0x40,
	B_HID_UID_MI_TRANSMIT_POWER,
	B_HID_UID_MI_VOLUME,
	B_HID_UID_MI_FOCUS,
	B_HID_UID_MI_DEPTH,
	
	B_HID_UID_MI_SOFT_STEP_PRIMARY = 0x60,
	B_HID_UID_MI_SOFT_STEP_SECONDARY,
	
	B_HID_UID_MI_DEPTH_GAIN_COMPENSATION = 0x70,
	
	B_HID_UID_MI_ZOOM_SELECT = 0x80,
	B_HID_UID_MI_ZOOM_ADJUST,
	B_HID_UID_MI_SPECTRAL_DOPPLER_MODE_SELECT,
	B_HID_UID_MI_SPECTRAL_DOPPLER_ADJUST,
	B_HID_UID_MI_COLOR_DOPPLER_MODE_SELECT,
	B_HID_UID_MI_COLOR_DOPPLER_ADJUST,
	B_HID_UID_MI_MOTION_MODE_SELECT,
	B_HID_UID_MI_MOTION_MODE_ADJUST,
	B_HID_UID_MI_2D_MODE_SELECT,
	B_HID_UID_MI_2D_MODE_ADJUST,
	
	B_HID_UID_MI_SOFT_CONTROL_SELECT = 0xa,
	B_HID_UID_MI_SOFT_CONTROL_ADJUST
};


#endif // _USB_HID_PAGE_MEDICAL_INSTRUMENT_H
