/*
 * Copyright 2004-2010, Haiku Inc. All Rights Reserved.
 * Distributed under the terms of the MIT License.
 */
#ifndef _USB_HID_PAGE_KEYBOARD_H
#define _USB_HID_PAGE_KEYBOARD_H


/* Reference:
 *		HID Usage Page 0x07: KEYBOARD
 *		HID Usage Tables Ver. 1.12
 *		http://www.usb.org/developers/devclass_docs/Hut1_12.pdf
 */

// Usage IDs
enum {
	B_HID_UID_KB_ERROR_ROLL_OVER = 0x01,
	B_HID_UID_KB_POST_FAIL,
	B_HID_UID_KB_ERROR_UNDEFINED,
	
	B_HID_UID_KB_a_AND_A = 0x04,
	B_HID_UID_KB_b_AND_B,
	B_HID_UID_KB_c_AND_C,
	B_HID_UID_KB_d_AND_D,
	B_HID_UID_KB_e_AND_E,
	B_HID_UID_KB_f_AND_F,
	B_HID_UID_KB_g_AND_G,
	B_HID_UID_KB_h_AND_H,
	B_HID_UID_KB_i_AND_I,
	B_HID_UID_KB_j_AND_J,
	B_HID_UID_KB_k_AND_K,
	B_HID_UID_KB_l_AND_L,
	B_HID_UID_KB_m_AND_M,
	B_HID_UID_KB_n_AND_N,
	B_HID_UID_KB_o_AND_O,
	B_HID_UID_KB_p_AND_P,
	B_HID_UID_KB_q_AND_Q,
	B_HID_UID_KB_r_AND_R,
	B_HID_UID_KB_s_AND_S,
	B_HID_UID_KB_t_AND_T,
	B_HID_UID_KB_u_AND_U,
	B_HID_UID_KB_v_AND_V,
	B_HID_UID_KB_w_AND_W,
	B_HID_UID_KB_x_AND_X,
	B_HID_UID_KB_y_AND_Y,
	B_HID_UID_KB_z_AND_Z,
	
	B_HID_UID_KB_1_AND_EXCLAMATION_MARK = 0x1e,
	B_HID_UID_KB_2_AND_AT,
	B_HID_UID_KB_3_AND_HASH,
	B_HID_UID_KB_4_AND_DOLLAR,
	B_HID_UID_KB_5_AND_PERCENT,
	B_HID_UID_KB_6_AND_CIRCUMFLEX,
	B_HID_UID_KB_7_AND_AMPERSAND,
	B_HID_UID_KB_8_AND_ASTERISK,
	B_HID_UID_KB_9_AND_LPAREN,
	B_HID_UID_KB_0_AND_RPAREN,
	
	B_HID_UID_KB_ENTER = 0x28,
	B_HID_UID_KB_ESCAPE,
	B_HID_UID_KB_DELETE,
	B_HID_UID_KB_TAB,
	B_HID_UID_KB_SPACEBAR,
	B_HID_UID_KB_DASH_AND_UNDERSCORE,
	B_HID_UID_KB_EQUAL_SIGN_AND_PLUS,
	B_HID_UID_KB_LBRACKET_AND_LBRACE,
	B_HID_UID_KB_RBRACKET_AND_RBRACE,
	B_HID_UID_KB_BACKSLASH_AND_PIPE,
	B_HID_UID_KB_NON_US_HASH_AND_TILDE,		// some notes
	B_HID_UID_KB_SEMICOLON_AND_COLON,
	B_HID_UID_KB_APOSTROPHE_AND_QUOTATION_MARK,
	B_HID_UID_KB_GRAVE_ACCENT_AND_TILDE,
	B_HID_UID_KB_COMMA_AND_LCHEVRON,
	B_HID_UID_KB_PERIOD_AND_RCHEVRON,
	B_HID_UID_KB_SLASH_AND_QUESTION_MARK,
	B_HID_UID_KB_CAPS_LOCK,	
	
	B_HID_UID_KB_F1 = 0x3a,
	B_HID_UID_KB_F2,
	B_HID_UID_KB_F3,
	B_HID_UID_KB_F4,
	B_HID_UID_KB_F5,
	B_HID_UID_KB_F6,
	B_HID_UID_KB_F7,
	B_HID_UID_KB_F8,
	B_HID_UID_KB_F9,
	B_HID_UID_KB_F10,
	B_HID_UID_KB_F11,
	B_HID_UID_KB_F12,
	
	B_HID_UID_KB_PRINT_SCREEN = 0x46,
	B_HID_UID_KB_SCROLL_LOCK,
	B_HID_UID_KB_PAUSE,
	B_HID_UID_KB_INSERT,
	B_HID_UID_KB_HOME,
	B_HID_UID_KB_PAGE_UP,
	B_HID_UID_KB_DELETE_FORWARD,
	B_HID_UID_KB_END,
	B_HID_UID_KB_PAGE_DOWN,
	B_HID_UID_KB_RIGHT_ARROW,
	B_HID_UID_KB_LEFT_ARROW,
	B_HID_UID_KB_DOWN_ARROW,
	B_HID_UID_KB_UP_ARROW,
	B_HID_UID_KB_NUM_LOCK_AND_CLEAR,
	
	B_HID_UID_KP_DIVIDE = 0x54,
	B_HID_UID_KP_MULTIPLY,
	B_HID_UID_KP_SUBTRACT,
	B_HID_UID_KP_ADD,
	B_HID_UID_KP_ENTER,
	B_HID_UID_KP_1_AND_END,
	B_HID_UID_KP_2_AND_DOWN_ARROW,
	B_HID_UID_KP_3_AND_PAGE_DOWN,
	B_HID_UID_KP_4_AND_LEFT_ARROW,
	B_HID_UID_KP_5,
	B_HID_UID_KP_6_AND_RIGHT_ARROW,
	B_HID_UID_KP_7_AND_HOME,
	B_HID_UID_KP_8_AND_UP_ARROW,
	B_HID_UID_KP_9_AND_PAGE_UP,
	B_HID_UID_KP_0_AND_INSERT,
	B_HID_UID_KP_PERIOD_AND_DELETE,
	
	B_HID_UID_KB_NON_US_BACKSLASH_AND_PIPE = 0x64,
	B_HID_UID_KB_APPLICATION,
	B_HID_UID_KB_POWER,
	
	B_HID_UID_KP_EQUAL_SIGN = 0x67,
	B_HID_UID_KB_F13,
	B_HID_UID_KB_F14,
	B_HID_UID_KB_F15,
	B_HID_UID_KB_F16,
	B_HID_UID_KB_F17,
	B_HID_UID_KB_F18,
	B_HID_UID_KB_F19,
	B_HID_UID_KB_F20,
	B_HID_UID_KB_F21,
	B_HID_UID_KB_F22,
	B_HID_UID_KB_F23,
	B_HID_UID_KB_F24,
	
	B_HID_UID_KB_EXECUTE = 0x74,
	B_HID_UID_KB_HELP,
	B_HID_UID_KB_MENU,
	B_HID_UID_KB_SELECT,
	B_HID_UID_KB_STOP,
	B_HID_UID_KB_AGAIN,
	B_HID_UID_KB_UNDO,
	B_HID_UID_KB_CUT,
	B_HID_UID_KB_COPY,
	B_HID_UID_KB_PASTE,
	B_HID_UID_KB_FIND,
	B_HID_UID_KB_MUTE,
	B_HID_UID_KB_VOLUME_UP,
	B_HID_UID_KB_VOLUME_DOWN,
	B_HID_UID_KB_LOCKING_CAPS_LOCK,
	B_HID_UID_KB_LOCKING_NUM_LOCK,
	B_HID_UID_KB_LOCKING_SCROLL_LOCK,
	
	B_HID_UID_KP_COMMA = 0x85,
	B_HID_UID_KB_EQUAL_SIGN,
	
	B_HID_UID_KB_INTERNATIONAL_1 = 0x87,
	B_HID_UID_KB_INTERNATIONAL_2,
	B_HID_UID_KB_INTERNATIONAL_3,
	B_HID_UID_KB_INTERNATIONAL_4,
	B_HID_UID_KB_INTERNATIONAL_5,
	B_HID_UID_KB_INTERNATIONAL_6,
	B_HID_UID_KB_INTERNATIONAL_7,
	B_HID_UID_KB_INTERNATIONAL_8,
	
	B_HID_UID_KB_LANG_1 = 0x90,
	B_HID_UID_KB_LANG_2,
	B_HID_UID_KB_LANG_3,
	B_HID_UID_KB_LANG_4,
	B_HID_UID_KB_LANG_5,
	B_HID_UID_KB_LANG_6,
	B_HID_UID_KB_LANG_7,
	B_HID_UID_KB_LANG_8,
	B_HID_UID_KB_LANG_9,
	
	B_HID_UID_KB_ALTERNATE_ERASE = 0x99,
	B_HID_UID_KB_SYSREQ_ATTENTION,
	B_HID_UID_KB_CANCEL,
	B_HID_UID_KB_CLEAR,
	B_HID_UID_KB_PRIOR,
	B_HID_UID_KB_RETURN,
	B_HID_UID_KB_SEPARATOR,
	B_HID_UID_KB_OUT,
	B_HID_UID_KB_OPER,
	B_HID_UID_KB_CLEAR_AGAIN,
	B_HID_UID_KB_CRSEL_PROPS,
	B_HID_UID_KB_EXSEL,
	
	B_HID_UID_KB_00 = 0xb0,
	B_HID_UID_KB_000,
	B_HID_UID_KB_THOUSANDS_SEPARATOR,
	B_HID_UID_KB_DECIMAL_SEPARATOR,
	B_HID_UID_KB_CURRENCY_UNIT,
	B_HID_UID_KB_CURRENCY_SUBUNIT,
	
	B_HID_UID_KP_LPAREN = 0xb6,
	B_HID_UID_KP_RPAREN,
	B_HID_UID_KP_LBRACE,
	B_HID_UID_KP_RBRACE,
	B_HID_UID_KP_TAB,
	B_HID_UID_KP_BACKSPACE,
	B_HID_UID_KP_A,
	B_HID_UID_KP_B,
	B_HID_UID_KP_C,
	B_HID_UID_KP_D,
	B_HID_UID_KP_E,
	B_HID_UID_KP_F,
	B_HID_UID_KP_XOR,
	B_HID_UID_KP_CIRCUMFLEX,
	B_HID_UID_KP_PERCENT,
	B_HID_UID_KP_LCHEVRON,
	B_HID_UID_KP_RCHEVRON,
	B_HID_UID_KP_AMPERSAND,
	B_HID_UID_KP_AMPERSAND2,
	B_HID_UID_KP_PIPE,
	B_HID_UID_KP_PIPE2,
	B_HID_UID_KP_COLON,
	B_HID_UID_KP_HASH,
	B_HID_UID_KP_SPACE,
	B_HID_UID_KP_AT,
	B_HID_UID_KP_EXCLAMATION_MARK,
	B_HID_UID_KP_MEMORY_STORE,
	B_HID_UID_KP_MEMORY_RECALL,
	B_HID_UID_KP_MEMORY_CLEAR,
	B_HID_UID_KP_MEMORY_ADD,
	B_HID_UID_KP_MEMORY_SUBTRACT,
	B_HID_UID_KP_MEMORY_MULTIPLY,
	B_HID_UID_KP_MEMORY_DIVIDE,
	B_HID_UID_KP_PLUS_MINUS,
	B_HID_UID_KP_CLEAR,
	B_HID_UID_KP_CLEAR_ENTRY,
	B_HID_UID_KP_BINARY,
	B_HID_UID_KP_OCTAL,
	B_HID_UID_KP_DECIMAL,
	B_HID_UID_KP_HEXADECIMAL,
	
	B_HID_UID_KB_LEFT_CONTROL = 0xe0,
	B_HID_UID_KB_LEFT_SHIFT,
	B_HID_UID_KB_LEFT_ALT,
	B_HID_UID_KB_LEFT_GUI,
	B_HID_UID_KB_RIGHT_CONTROL,
	B_HID_UID_KB_RIGHT_SHIFT,
	B_HID_UID_KB_RIGHT_ALT,
	B_HID_UID_KB_RIGHT_GUI
};


#endif // _USB_HID_PAGE_KEYBOARD_H
