/*
 * Copyright 2001-2005, Haiku.
 * Distributed under the terms of the MIT License.
 *
 * Authors:
 *		Erik Jaesler (erik@cgsoftware.com)
 *		Axel Dörfler, axeld@pinc-software.de
 */
#ifndef _TOKEN_SPACE_H
#define _TOKEN_SPACE_H


#include <map>
#include <stack>

#include <BeBuild.h>
#include <Locker.h>
#include <SupportDefs.h>


// token types as specified in targets
#define B_PREFERRED_TOKEN	-2		/* A little bird told me about this one */
#define B_NULL_TOKEN		-1
#define B_ANY_TOKEN			0

// token types in the token list
#define B_HANDLER_TOKEN		1
#define B_SERVER_TOKEN		2


namespace BPrivate {

typedef void (*new_token_callback)(int16, void*);
typedef void (*remove_token_callback)(int16, void*);
typedef bool (*get_token_callback)(int16, void*);

class BTokenSpace : public BLocker {
	public:
		BTokenSpace();
		~BTokenSpace();

		int32		NewToken(int16 type, void* object,
							 new_token_callback callback = NULL);
		bool		RemoveToken(int32 token, remove_token_callback callback = NULL);
		bool		CheckToken(int32 token, int16 type) const;
		status_t	GetToken(int32 token, int16 type, void** object,
							 get_token_callback callback = NULL) const;

		status_t	GetList(int32*& tokens, int32& count) const;

// Possible expansion
//		void Dump(BDataIO&, bool) const;
//		int32 NewToken(void*, BDirectMessageTarget*, void (*)(short, void*));
//		bool SetTokenTarget(uint32, BDirectMessageTarget*);
//		BDirectMessageTarget* TokenTarget(uint32 token, int16 type);

	private:
		struct TTokenInfo {
			int16	type;
			void*	object;
		};

		typedef std::map<int32, TTokenInfo>	TTokenMap;

		TTokenMap			fTokenMap;
		std::stack<int32>	fTokenBin;
		int32				fTokenCount;
};

// Possible expansion
//_delete_tokens_();
//_init_tokens_();
//get_handler_token(short, void*);
//get_token_list(long, long*);
//new_handler_token(short, void*);
//remove_handler_token(short, void*);

extern _IMPEXP_BE BTokenSpace gDefaultTokens;

}	// namespace BPrivate

#endif	// _TOKEN_SPACE_H
