/*
 * Copyright 2004-2007, Haiku, Inc. All Rights Reserved.
 * Distributed under the terms of the MIT License.
 *
 * Authors:
 *		Andrew McCall <mccall@@digitalparadise.co.uk>
 *		Mike Berg <mike@berg-net.us>
 *		Julun <host.haiku@gmx.de>
 *
 */
#ifndef ANALOG_CLOCK_H
#define ANALOG_CLOCK_H


#include <Bitmap.h>


void ReplaceTransparentColor(BBitmap *bitmap, rgb_color with);

const int32 kUpArrowWidth = 16;
const int32 kUpArrowHeight = 7;
const color_space kUpArrowColorSpace = B_CMAP8;

const unsigned char kUpArrowBits [] = {
	0xff,0xff,0xff,0xff,0x13,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x18,0x3f,0xff,0xff,
	0xff,0xff,0xff,0x13,0x1e,0x13,0xff,0xff,0xff,0xff,0xff,0xff,0x18,0x3f,0xff,0xff,
	0xff,0xff,0x13,0x1e,0xff,0x18,0x13,0xff,0xff,0xff,0xff,0xff,0x18,0x3f,0xff,0xff,
	0xff,0x13,0x1e,0xff,0xff,0xff,0x18,0x13,0xff,0xff,0xff,0xff,0x18,0x3f,0xff,0xff,
	0x13,0x1e,0x18,0x18,0x18,0x18,0x18,0x18,0x0b,0xff,0xff,0xff,0x18,0x3f,0xff,0xff,
	0x13,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x13,0xff,0xff,0x18,0x3f,0xff,0xff,
	0xff,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0xff,0xff,0x18,0x3f,0xff,0xff
};

const int32 kDownArrowWidth = 16;
const int32 kDownArrowHeight = 7;
const color_space kDownArrowColorSpace = B_CMAP8;

const unsigned char kDownArrowBits [] = {
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x0b,0xff,0xff,0xff,0x18,0x3f,0xff,0xff,
	0x13,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x16,0x0b,0x13,0xff,0xff,0x18,0x3f,0xff,0xff,
	0xff,0x13,0xff,0xff,0xff,0xff,0x16,0x0b,0x13,0x13,0xff,0xff,0x18,0x3f,0xff,0xff,
	0xff,0xff,0x13,0xff,0xff,0x16,0x0b,0x13,0x13,0xff,0xff,0xff,0x18,0x3f,0xff,0xff,
	0xff,0xff,0xff,0x13,0x16,0x0b,0x13,0x13,0xff,0xff,0xff,0xff,0x18,0x3f,0xff,0xff,
	0xff,0xff,0xff,0xff,0x0b,0x13,0x13,0xff,0xff,0xff,0xff,0xff,0x18,0x3f,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0x13,0xff,0xff,0xff,0xff,0xff,0xff,0x18,0x3f,0xff,0xff
};

#endif	// ANALOG_CLOCK_H

