/*

	Lowest-level classes in liblayout
	- minimax, used to store information about minimum size, maximum size, and weigth of objects
	- MView, a class that knows how to layout itself

*/

#ifndef _LAYOUT_H
#define _LAYOUT_H

#if __POWERPC__
#pragma simple_class_byval off
#endif

#include <BeBuild.h>

#if !defined(IMPEXPLIBLAYOUT) && defined(BUILDING_LIBLAYOUT)
#define IMPEXPLIBLAYOUT	_EXPORT
#else
#define IMPEXPLIBLAYOUT	_IMPORT
#endif

#include <Rect.h>
#include <GraphicsDefs.h>
#include <stdlib.h>

class BMessage;
class BFont;

// use macro to make code slightly more readable
#define MVPTR(x) dynamic_cast<MView*>(x)

enum fontspec
{
	M_PLAIN_FONT=0,
	M_BOLD_FONT,
	M_FIXED_FONT
};


// this structure is exported from liblayout, and contains the version number
struct LAYOUT_VERSION_INFO
{
	uchar major;
	uchar minor;
	ushort patchlevel;
};

extern "C" LAYOUT_VERSION_INFO IMPEXPLIBLAYOUT LIBLAYOUT_VERSION;


class IMPEXPLIBLAYOUT minimax	// Order now, by dialing the number on your screen!
{
struct xypair { float x,y;};

	public:		xypair	mini;
				xypair	maxi;
				float	weight;
				
				minimax(int minx=0,int miny=0,
						int maxx=10000,int maxy=10000,
						float wght=1.0);
};

class IMPEXPLIBLAYOUT MView
{
	protected:	rgb_color	FILL_COLOR;
				rgb_color	LOW_COLOR;
				rgb_color	HI_COLOR;

				// helper functions for archiving/unarchiving the MView
				// part of MView hybrids
				status_t archive(BMessage *);
				status_t unarchive(BMessage *);

	public:		minimax	mpm;		// currently active minimax (calculated from ct_mpm and environmental constraints)
				minimax ct_mpm;		// size specified at construction-time
				ulong	flags;		// various flags
									// upper 16 bits are reserve for liblayout-use
									// bits 8-15 are reserved for per-class liblayout-use
									// bits 0-7 are available

				MView();
				virtual ~MView();
				virtual	minimax	layoutprefs()=0;
				virtual BRect	layout(BRect rect)=0;

				// reload the font from one of the fonts in the font-array
				virtual void	reloadfont(BFont *font[]);
				// get a BFont with the required fontspec
				const BFont 	*getfont(fontspec font);

				// set the color of the MView
				virtual void	setcolor(rgb_color col, bool deep=true);
				// this one calls the above function
						void	setcolor(uchar red, uchar green, uchar blue, bool deep=true);
					rgb_color	getcolor(); // get the base color (what is set through setcolor() )
				
	private:
			virtual void _expansionmview1();
			virtual void _expansionmview2();
			virtual void _expansionmview3();
			virtual void _expansionmview4();

			uint32 _expansiondata[4];
};


// constants used in messaging all start with a '!'
#define M_POPUP_SELECTED		'!pop'
#define M_CHECKBOX_SELECTED		'!chk'
#define M_BUTTON_SELECTED		'!but'
#define M_RADIO_SELECTED 		'!rad'
#define M_PLAYBW_SELECTED		'!ylp'
#define M_PLAYFW_SELECTED		'!ply'
#define M_FFWD_SELECTED			'!fwd'
#define M_REW_SELECTED 			'!rwd'
#define M_STOP_SELECTED			'!stp'
#define M_VOLUME_CHANGED		'!vol'
#define M_EJECT_SELECTED		'!ejt'
#define M_PREV_SELECTED			'!prv'
#define M_NEXT_SELECTED			'!nxt'
#define M_PROGRESSBAR_CLICKED	'!pbc'
#define M_PROGRESSBAR_DRAGGED	'!pbd'
#define M_PROGRESSBAR_RELEASED	'!pbr'
#define M_ACTIVATE_LAYER		'!lyr'

// when sent to a window, it recalculates the entire window
#define M_RECALCULATE_SIZE		'!rsz'

// font-change message is understood by MWindow and MApplication,
// but is not generated by liblayout.
#define M_FONT_CHANGED			'!FNT'

extern IMPEXPLIBLAYOUT rgb_color M_FILL_COLOR;
extern IMPEXPLIBLAYOUT rgb_color M_LOW_COLOR;
extern IMPEXPLIBLAYOUT rgb_color M_HI_COLOR;
extern IMPEXPLIBLAYOUT rgb_color BLACK_COLOR;
extern IMPEXPLIBLAYOUT rgb_color WHITE_COLOR;

void IMPEXPLIBLAYOUT SetDefaultColors(uchar red, uchar green, uchar blue);
void IMPEXPLIBLAYOUT SetDefaultColors(rgb_color cs);

// misc flags
// note that not all controls responds to all flags

enum{
	M_REPORT_IMMEDIATE=			0x00010000,		// report first click on control
	M_REPORT_REPEAT	=			0x00020000,		// report if control is clicked and held
	M_REPORT_RELEASE=			0x00040000,		// report release of button over control
	M_REPORT_RELEASE_ALWAYS=	0x00080000,		// always report release of button
	M_REPORT_MASK=				0x000f0000,		// all of the above
	
	// mostly for internal use, therefore not documented (yet)
	M_USE_CALCULATED_MINX=		0x00100000,
	M_USE_CALCULATED_MINY=		0x00200000,
	M_USE_CALCULATED_MAXX=		0x00400000,
	M_USE_CALCULATED_MAXY=		0x00800000,
	M_NO_X_LEFTOVERS=			0x01000000, // don't add "leftover" space to this object
	M_NO_Y_LEFTOVERS=			0x02000000, // don't add "leftover" space to this object
	M_NO_COLOR_CHANGES=			0x20000000, // don't listen to color-drop messages
	M_NO_FONT_CHANGES=			0x40000000, // don't listen to font-change messages
	M_USE_FULL_SIZE	=	  (int)	0x80000000	// don't respect max-size (set for grouping classes)
};


#endif
